/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaluating.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.evaluating.entityservice.AbstractEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.AbstractNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenNodeResEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;

public class CalcSonService {
    private static final ObjGenEvalRecordEntityService GEN_EVAL_RECORD_ENTITY_SERVICE = ObjGenEvalRecordEntityService.getInstance();
    private static final ObjGenNodeResEntityService GEN_NODE_RES_ENTITY_SERVICE = ObjGenNodeResEntityService.getInstance();
    private static final ObjAddSubEvalRecordEntityService ADD_SUB_EVAL_RECORD_ENTITY_SERVICE = ObjAddSubEvalRecordEntityService.getInstance();
    private static final ObjAddSubNodeResEntityService ADD_SUB_NODE_RES_ENTITY_SERVICE = ObjAddSubNodeResEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();

    public static CalcSonService getInstance() {
        return ServiceFactory.getService(CalcSonService.class);
    }

    public void calcSON(Long ruNodeId, Long areaTypeId) {
        AbstractNodeResEntityService nodeResEntityService;
        AbstractEvalRecordEntityService evalRecordEntityService;
        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId)) {
            evalRecordEntityService = GEN_EVAL_RECORD_ENTITY_SERVICE;
            nodeResEntityService = GEN_NODE_RES_ENTITY_SERVICE;
        } else {
            evalRecordEntityService = ADD_SUB_EVAL_RECORD_ENTITY_SERVICE;
            nodeResEntityService = ADD_SUB_NODE_RES_ENTITY_SERVICE;
        }
        DynamicObject[] records = evalRecordEntityService.queryRecordsByRuNodeId(ruNodeId);
        if (records.length <= 0) {
            return;
        }
        HashMap calcMap = new HashMap(16);
        HashMap<Long, DynamicObject> indicatorRecordMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject record : records) {
            List<DynamicObject> ruRoleRecordList;
            HashMap ruRoleRecordMap;
            Long indicatorId = record.getLong("indicator");
            Long ruRoleId = record.getLong("flowrurole");
            if (calcMap.containsKey(indicatorId)) {
                ruRoleRecordMap = (HashMap)calcMap.get(indicatorId);
            } else {
                ruRoleRecordMap = new HashMap(16);
                calcMap.put(indicatorId, ruRoleRecordMap);
                indicatorRecordMap.put(indicatorId, record);
            }
            if (ruRoleRecordMap.containsKey(ruRoleId)) {
                ruRoleRecordList = (List)ruRoleRecordMap.get(ruRoleId);
            } else {
                ruRoleRecordList = new ArrayList();
                ruRoleRecordMap.put(ruRoleId, ruRoleRecordList);
            }
            ruRoleRecordList.add(record);
        }
        Map roleWeightMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryRoleWeightByNodeId(ruNodeId);
        ArrayList<DynamicObject> indNodeResList = new ArrayList<DynamicObject>(calcMap.size());
        for (Map.Entry calcMapEntry : calcMap.entrySet()) {
            BigDecimal son = BigDecimal.ZERO;
            for (Map.Entry roleRecordEntry : ((Map)calcMapEntry.getValue()).entrySet()) {
                BigDecimal roleScoreSum = BigDecimal.ZERO;
                for (DynamicObject record : (List)roleRecordEntry.getValue()) {
                    roleScoreSum = roleScoreSum.add(record.getBigDecimal(AssessScoreAbbrEnum.SOE.getCode()));
                }
                BigDecimal sor = roleScoreSum.divide(new BigDecimal(((List)roleRecordEntry.getValue()).size()), 6, 4).multiply((BigDecimal)roleWeightMap.get(roleRecordEntry.getKey())).divide(new BigDecimal(100), 6, 4);
                son = son.add(sor);
            }
            indNodeResList.add(nodeResEntityService.generateNodeRes((DynamicObject)indicatorRecordMap.get(calcMapEntry.getKey()), son));
        }
        nodeResEntityService.saveNodeRes(indNodeResList.toArray(new DynamicObject[0]), ruNodeId);
    }
}

