/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.evaluating.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.entityservice.AbstractAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.service.AssessRuleDomainService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjNodeResEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjSumAreaRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.service.ActEvalObjDetailDomainService;
import kd.opmc.epa.business.domain.evaluating.service.CalcSonService;
import kd.opmc.epa.business.domain.ext.ICalcAreaOnSumNodeService;
import kd.opmc.epa.business.domain.ext.ICalcCrossNodeService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.RuNodeTaskBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowAssistDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class EvalResultCalcDomainService {
    private static final Log LOG = LogFactory.getLog(EvalResultCalcDomainService.class);
    private static final ObjGenNodeResEntityService GEN_NODE_RES_ENTITY_SERVICE = ObjGenNodeResEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService GEN_AREA_INDICATOR_ENTITY_SERVICE = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjGenAreaInsEntityService GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubNodeResEntityService ADD_SUB_NODE_RES_ENTITY_SERVICE = ObjAddSubNodeResEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACT_EVAL_OBJ_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjSumAreaRecordEntityService OBJ_SUM_AREA_RECORD_ENTITY_SERVICE = ObjSumAreaRecordEntityService.getInstance();
    private static final FlowAssistDomainService FLOW_ASSIST_DOMAIN_SERVICE = FlowAssistDomainService.getInstance();
    private static final ActEvalObjDetailDomainService ACT_EVAL_OBJ_DETAIL_DOMAIN_SERVICE = ActEvalObjDetailDomainService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final AssessRuleDomainService ASSESS_RULE_DOMAIN_SERVICE = AssessRuleDomainService.getInstance();
    private static final ObjNodeResEntityService OBJ_NODE_RES_ENTITY_SERVICE = ObjNodeResEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final CalcSonService CALC_SON_SERVICE = CalcSonService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"EvalResultCalcDomainService#&", (int)2, (int)8);

    public static EvalResultCalcDomainService getInstance() {
        return ServiceFactory.getService(EvalResultCalcDomainService.class);
    }

    public void calcRuNodeResult(Long ruNodeId, Long actEvalObjId) {
        DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruNodeId);
        if (this.notNeedCalc(ruNode.getLong("flownodedef.nodetype.id"))) {
            return;
        }
        DynamicObject actEvalObj = ACT_EVAL_OBJ_ENTITY_SERVICE.queryForCalcNodeResult(actEvalObjId);
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(actEvalObj.getLong("activity.assessform.id"));
        this.calcRuNodeResult(actEvalObj, assessForm, ruNode);
    }

    private boolean notNeedCalc(Long nodeTypeId) {
        return !NodeTypeConstants.EVALUATE_SCORE.equals(nodeTypeId) && !NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeTypeId);
    }

    private void calcRuNodeResult(DynamicObject actEvalObj, DynamicObject assessForm, DynamicObject ruNode) {
        Long ruNodeId = ruNode.getLong("id");
        long nodeType = ruNode.getLong("flownodedef.nodetype.id");
        boolean isCrossNode = ruNode.getBoolean("flownodedef.crossscore");
        BigDecimal sont = NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeType) || NodeTypeConstants.EVALUATE_SCORE.equals(nodeType) && !isCrossNode ? this.calcSumNodeResult(ruNodeId) : (isCrossNode ? this.calcCrossNodeResult(ruNodeId, assessForm, actEvalObj) : this.calcNormNodeResult(ruNodeId, assessForm, actEvalObj));
        sont = this.getFormScoreInLimit(sont, assessForm);
        OBJ_NODE_RES_ENTITY_SERVICE.saveNodeRes(actEvalObj, sont, ruNodeId);
    }

    private BigDecimal calcCrossNodeResult(Long ruNodeId, DynamicObject assessForm, DynamicObject actEvalObj) {
        HRPluginProxy CALC_CROSS_NODE_PROXY = new HRPluginProxy((Object)ICalcCrossNodeService.getInstance(), ICalcCrossNodeService.class, "kd.opmc.epa.business.domain.ext.ICalcCrossNodeService#calcCrossNodeSon", (PluginFilter)null);
        CALC_CROSS_NODE_PROXY.callReplaceIfPresent(plugin -> plugin.calcCrossNodeSon(ruNodeId));
        BigDecimal sont = BigDecimal.ZERO;
        sont = sont.add(this.calcNormAreaForSONT(ruNodeId, assessForm, actEvalObj));
        sont = sont.add(this.calcPlusMinusAreaForSONT(ruNodeId));
        return sont;
    }

    private BigDecimal calcNormNodeResult(Long ruNodeId, DynamicObject assessForm, DynamicObject actEvalObj) {
        CALC_SON_SERVICE.calcSON(ruNodeId, AssessRuleConstants.NORM_INDCTR_AREA_PK);
        CALC_SON_SERVICE.calcSON(ruNodeId, AssessRuleConstants.PLUS_MINUS_AREA_PK);
        BigDecimal sont = BigDecimal.ZERO;
        sont = sont.add(this.calcNormAreaForSONT(ruNodeId, assessForm, actEvalObj));
        sont = sont.add(this.calcPlusMinusAreaForSONT(ruNodeId));
        return sont;
    }

    private BigDecimal calcSumNodeResult(Long ruNodeId) {
        CALC_SON_SERVICE.calcSON(ruNodeId, AssessRuleConstants.NORM_INDCTR_AREA_PK);
        CALC_SON_SERVICE.calcSON(ruNodeId, AssessRuleConstants.PLUS_MINUS_AREA_PK);
        BigDecimal sont = BigDecimal.ZERO;
        DynamicObject[] records = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryRecordsByRuNodeId(ruNodeId);
        if (records.length <= 0) {
            return sont;
        }
        HashMap calcMap = new HashMap(16);
        for (DynamicObject record : records) {
            List<BigDecimal> oseList;
            Long ruRoleId = record.getLong("flowrurole");
            BigDecimal ose = record.getBigDecimal("ose");
            if (calcMap.containsKey(ruRoleId)) {
                oseList = (List)calcMap.get(ruRoleId);
            } else {
                oseList = new ArrayList();
                calcMap.put(ruRoleId, oseList);
            }
            oseList.add(ose);
        }
        Map roleWeightMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryRoleWeightByNodeId(ruNodeId);
        for (Map.Entry roleOseEntry : calcMap.entrySet()) {
            BigDecimal roleScoreSum = BigDecimal.ZERO;
            for (BigDecimal ose : (List)roleOseEntry.getValue()) {
                roleScoreSum = roleScoreSum.add(ose);
            }
            BigDecimal roleScore = roleScoreSum.divide(new BigDecimal(((List)roleOseEntry.getValue()).size()), 6, 4).multiply((BigDecimal)roleWeightMap.get(roleOseEntry.getKey())).divide(new BigDecimal(100), 6, 4);
            sont = sont.add(roleScore);
        }
        return sont;
    }

    private BigDecimal calcPlusMinusAreaForSONT(Long ruNodeId) {
        DynamicObject[] nodeResults = ADD_SUB_NODE_RES_ENTITY_SERVICE.queryNodeResByRuNodeId(ruNodeId);
        if (nodeResults.length <= 0) {
            return BigDecimal.ZERO;
        }
        HashMap<Long, BigDecimal> soznMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject nodeResult : nodeResults) {
            Long areaId = nodeResult.getLong("area");
            BigDecimal son = nodeResult.getBigDecimal(AssessScoreAbbrEnum.SON.getCode());
            BigDecimal sozn = (BigDecimal)soznMap.get(areaId);
            soznMap.put(areaId, sozn == null ? son : sozn.add(son));
        }
        DynamicObject[] areas = ADD_SUB_AREA_INS_ENTITY_SERVICE.queryAreaInfoByIds(soznMap.keySet());
        BigDecimal sontArea = BigDecimal.ZERO;
        for (DynamicObject area : areas) {
            if (!area.getBoolean("areaconf.ispartin")) continue;
            Long areaId = area.getLong("id");
            sontArea = sontArea.add(this.getAreaScoreInLimit((BigDecimal)soznMap.get(areaId), area));
        }
        return sontArea;
    }

    private BigDecimal calcNormAreaForSONT(Long ruNodeId, DynamicObject assessForm, DynamicObject actEvalObj) {
        Long areaId;
        ScoreCalcWayEnum calcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)assessForm.getString("scorecalcway"));
        DynamicObject[] nodeResults = GEN_NODE_RES_ENTITY_SERVICE.queryNodeResByRuNodeId(ruNodeId, calcWayEnum);
        HashMap<Long, BigDecimal> soznMap = new HashMap<Long, BigDecimal>(16);
        DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
        for (DynamicObject areaInfo : areaEntry) {
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))) continue;
            soznMap.put(areaInfo.getLong("areains"), BigDecimal.ZERO);
        }
        for (DynamicObject nodeResult : nodeResults) {
            BigDecimal sozn;
            Long areaId2 = nodeResult.getLong("area");
            BigDecimal son = nodeResult.getBigDecimal(AssessScoreAbbrEnum.SON.getCode());
            if (calcWayEnum == ScoreCalcWayEnum.WEIGHT) {
                son = son.multiply(nodeResult.getBigDecimal("indicator.realweight")).divide(new BigDecimal(100), 6, 4);
            }
            soznMap.put(areaId2, (sozn = (BigDecimal)soznMap.get(areaId2)) == null ? son : sozn.add(son));
        }
        Boolean isSameScoreSystem = "1".equals(assessForm.getString("consistentwitharea"));
        DynamicObject[] areas = GEN_AREA_INS_ENTITY_SERVICE.queryAreaInfoByIds(soznMap.keySet(), isSameScoreSystem);
        BigDecimal sontArea = BigDecimal.ZERO;
        DynamicObject formScoreSystem = assessForm.getDynamicObject("scoresystem");
        DynamicObject[] inds = GEN_AREA_INDICATOR_ENTITY_SERVICE.queryImportIndByAreaIds(soznMap.keySet());
        HashMap areaImportIndMap = Maps.newHashMapWithExpectedSize((int)areas.length);
        for (DynamicObject ind : inds) {
            areaId = ind.getLong("instanceid");
            List areaInds = areaImportIndMap.computeIfAbsent(areaId, k -> new ArrayList());
            areaInds.add(ind);
        }
        for (DynamicObject area : areas) {
            if (!area.getBoolean("areaconf.ispartin")) continue;
            areaId = area.getLong("id");
            BigDecimal sozn = (BigDecimal)soznMap.get(areaId);
            List areaInds = (List)areaImportIndMap.get(areaId);
            if (CollectionUtils.isNotEmpty((Collection)areaInds)) {
                for (DynamicObject areaInd : areaInds) {
                    BigDecimal socre = areaInd.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
                    if (calcWayEnum == ScoreCalcWayEnum.WEIGHT) {
                        socre = socre.multiply(areaInd.getBigDecimal("realweight")).divide(new BigDecimal(100), 6, 4);
                    }
                    sozn = sozn.add(socre);
                }
            }
            if (!isSameScoreSystem.booleanValue()) {
                DynamicObject areaScoreSystem = area.getDynamicObject("scoresystem");
                if (formScoreSystem.getLong("id") != areaScoreSystem.getLong("id")) {
                    sozn = sozn.divide(areaScoreSystem.getBigDecimal("maxscore"), 6, 4).multiply(formScoreSystem.getBigDecimal("maxscore"));
                }
            }
            sontArea = sontArea.add(sozn);
        }
        return sontArea;
    }

    public void calcRuProcResult(Long ruNodeId, Long ruProcId, Long actEvalObjId) {
        String evalFinishType;
        DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruNodeId);
        if (this.notNeedCalc(ruNode.getLong("flownodedef.nodetype.id"))) {
            return;
        }
        DynamicObject actEvalObj = ACT_EVAL_OBJ_ENTITY_SERVICE.queryForCalcProcResult(actEvalObjId);
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(actEvalObj.getLong("activity.assessform.id"));
        this.calcRuNodeResult(actEvalObj, assessForm, ruNode);
        Map nodeWeightMap = FLOW_RUN_SUP_DOMAIN_SERVICE.queryNodeWeightByProcId(ruProcId);
        boolean existEvalSumNode = !FLOW_RUN_SUP_DOMAIN_SERVICE.notExistEvalSumNode(ruProcId);
        this.calcNormAreaForProc(assessForm, nodeWeightMap, actEvalObj);
        this.calcPlusMinusAreaForProc(assessForm, nodeWeightMap);
        if (existEvalSumNode) {
            HRPluginProxy CALC_AREA_ON_SUM_NODE_PROXY = new HRPluginProxy((Object)ICalcAreaOnSumNodeService.getInstance(), ICalcAreaOnSumNodeService.class, "kd.opmc.epa.business.domain.ext.ICalcAreaOnSumNodeService#calcAreaForProc", (PluginFilter)null);
            CALC_AREA_ON_SUM_NODE_PROXY.callReplaceIfPresent(plugin -> plugin.calcAreaForProc(assessForm, nodeWeightMap));
        }
        if (HRStringUtils.isNotEmpty((String)(evalFinishType = actEvalObj.getString("evalfinishtype"))) && !HRStringUtils.equals((String)EvalfinishtypeEnum.FINISHED_UPDATE_EVAL.getType(), (String)evalFinishType)) {
            return;
        }
        this.calcFormResult(ruProcId, actEvalObj, assessForm, nodeWeightMap);
    }

    private Map<Long, BigDecimal> calcIecsAndSoz(DynamicObject[] nodeResults, Long areaTypeId, DynamicObject assessForm, Map<Long, BigDecimal> nodeWeightMap) {
        DynamicObject[] indicators;
        AbstractAreaIndicatorEntityService areaIndicatorEntityService = AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId) ? GEN_AREA_INDICATOR_ENTITY_SERVICE : ADD_SUB_AREA_INDICATOR_ENTITY_SERVICE;
        HashMap<Long, Map<Long, List<DynamicObject>>> calcMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(16);
        this.buildAreaCalcMap(calcMap, nodeResults);
        HashMap<Long, BigDecimal> areaResMap = new HashMap<Long, BigDecimal>(16);
        HashMap indicatorResMap = new HashMap(16);
        ScoreCalcWayEnum calcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)assessForm.getString("scorecalcway"));
        boolean isHaveWeight = AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaTypeId) && calcWayEnum == ScoreCalcWayEnum.WEIGHT;
        for (Map.Entry calcMapEntry : calcMap.entrySet()) {
            BigDecimal soz = BigDecimal.ZERO;
            for (Map.Entry indicatorNodeResEntry : ((Map)calcMapEntry.getValue()).entrySet()) {
                BigDecimal iecs = BigDecimal.ZERO;
                for (DynamicObject nodeRes : (List)indicatorNodeResEntry.getValue()) {
                    iecs = iecs.add(nodeRes.getBigDecimal(AssessScoreAbbrEnum.SON.getCode()).multiply(nodeWeightMap.get(nodeRes.getLong("flowrunode"))).divide(new BigDecimal(100), 6, 4));
                }
                BigDecimal soi = isHaveWeight ? iecs.multiply(((DynamicObject)((List)indicatorNodeResEntry.getValue()).get(0)).getBigDecimal("indicator.realweight")).divide(new BigDecimal(100), 6, 4) : iecs;
                indicatorResMap.put(indicatorNodeResEntry.getKey(), new Tuple((Object)iecs, (Object)soi));
                soz = soz.add(soi);
            }
            areaResMap.put((Long)calcMapEntry.getKey(), soz);
        }
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject indicator : indicators = areaIndicatorEntityService.queryIndicatorByIds(indicatorResMap.keySet())) {
            Tuple tuple = (Tuple)indicatorResMap.get(indicator.getLong("id"));
            indicator.set(AssessScoreAbbrEnum.IECS.getCode(), tuple.item1);
            indicator.set(AssessScoreAbbrEnum.IES.getCode(), tuple.item1);
            indicator.set(AssessScoreAbbrEnum.SOI.getCode(), tuple.item2);
            indicator.set("modifier", (Object)userId);
            indicator.set("modifytime", (Object)date);
        }
        areaIndicatorEntityService.save(indicators);
        return areaResMap;
    }

    private void calcNormAreaForProc(DynamicObject assessForm, Map<Long, BigDecimal> nodeWeightMap, DynamicObject actEvalObj) {
        Long areaId;
        DynamicObject[] nodeResults = GEN_NODE_RES_ENTITY_SERVICE.queryNodeResByRuNodeId(nodeWeightMap.keySet());
        Map<Long, BigDecimal> areaResMap = this.calcIecsAndSoz(nodeResults, AssessRuleConstants.NORM_INDCTR_AREA_PK, assessForm, nodeWeightMap);
        DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaentry");
        for (DynamicObject areaInfo : areaEntry) {
            if (!AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))) continue;
            areaResMap.putIfAbsent(areaInfo.getLong("areains"), BigDecimal.ZERO);
        }
        DynamicObject formScoreSystem = assessForm.getDynamicObject("scoresystem");
        Boolean isSameScoreSystem = "1".equals(assessForm.getString("consistentwitharea"));
        DynamicObject[] areas = GEN_AREA_INS_ENTITY_SERVICE.queryAreaInfoByIds(areaResMap.keySet(), isSameScoreSystem);
        DynamicObject[] inds = GEN_AREA_INDICATOR_ENTITY_SERVICE.queryImportIndByAreaIds(areaResMap.keySet());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ScoreCalcWayEnum calcWayEnum = ScoreCalcWayEnum.getScoreCalcWay((String)assessForm.getString("scorecalcway"));
        HashMap areaImportIndMap = Maps.newHashMapWithExpectedSize((int)areas.length);
        for (DynamicObject indicator : inds) {
            areaId = indicator.getLong("instanceid");
            List areaInds = areaImportIndMap.computeIfAbsent(areaId, k -> new ArrayList());
            areaInds.add(indicator);
            BigDecimal soi = indicator.getBigDecimal(AssessScoreAbbrEnum.IECS.getCode());
            if (calcWayEnum == ScoreCalcWayEnum.WEIGHT) {
                soi = soi.multiply(indicator.getBigDecimal("realweight")).divide(new BigDecimal(100), 6, 4);
            }
            indicator.set(AssessScoreAbbrEnum.SOI.getCode(), (Object)soi);
        }
        for (DynamicObject area : areas) {
            areaId = area.getLong("id");
            BigDecimal csoz = areaResMap.get(areaId);
            List areaInds = (List)areaImportIndMap.get(areaId);
            if (CollectionUtils.isNotEmpty((Collection)areaInds)) {
                for (DynamicObject areaInd : areaInds) {
                    csoz = csoz.add(areaInd.getBigDecimal(AssessScoreAbbrEnum.SOI.getCode()));
                }
            }
            BigDecimal soz = csoz;
            if (!isSameScoreSystem.booleanValue()) {
                DynamicObject areaScoreSystem = area.getDynamicObject("scoresystem");
                if (formScoreSystem.getLong("id") != areaScoreSystem.getLong("id")) {
                    soz = csoz.divide(areaScoreSystem.getBigDecimal("maxscore"), 6, 4).multiply(formScoreSystem.getBigDecimal("maxscore"));
                }
            }
            area.set(AssessScoreAbbrEnum.CSOZ.getCode(), (Object)csoz);
            area.set(AssessScoreAbbrEnum.SOZ.getCode(), (Object)soz);
            area.set("modifier", (Object)userId);
            area.set("modifytime", (Object)date);
        }
        GEN_AREA_INDICATOR_ENTITY_SERVICE.save(inds);
        GEN_AREA_INS_ENTITY_SERVICE.save(areas);
    }

    private void calcPlusMinusAreaForProc(DynamicObject assessForm, Map<Long, BigDecimal> nodeWeightMap) {
        DynamicObject[] nodeResults = ADD_SUB_NODE_RES_ENTITY_SERVICE.queryNodeResByRuNodeId(nodeWeightMap.keySet());
        if (nodeResults.length <= 0) {
            return;
        }
        Map<Long, BigDecimal> areaResMap = this.calcIecsAndSoz(nodeResults, AssessRuleConstants.PLUS_MINUS_AREA_PK, assessForm, nodeWeightMap);
        DynamicObject[] areas = ADD_SUB_AREA_INS_ENTITY_SERVICE.queryAreaByIds(areaResMap.keySet());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject area : areas) {
            Long areaId = area.getLong("id");
            BigDecimal soz = areaResMap.get(areaId);
            soz = this.getAreaScoreInLimit(soz, area);
            area.set(AssessScoreAbbrEnum.CSOZ.getCode(), (Object)soz);
            area.set(AssessScoreAbbrEnum.SOZ.getCode(), (Object)soz);
            area.set("modifier", (Object)userId);
            area.set("modifytime", (Object)date);
        }
        ADD_SUB_AREA_INS_ENTITY_SERVICE.save(areas);
    }

    private void buildAreaCalcMap(Map<Long, Map<Long, List<DynamicObject>>> calcMap, DynamicObject[] nodeResults) {
        for (DynamicObject nodeResult : nodeResults) {
            List<Object> nodeResList;
            Map<Long, List<DynamicObject>> indicatorNodeResMap;
            Long indicatorId = nodeResult.getLong("indicator.id");
            Long areaId = nodeResult.getLong("area");
            if (calcMap.containsKey(areaId)) {
                indicatorNodeResMap = calcMap.get(areaId);
            } else {
                indicatorNodeResMap = new HashMap<Long, List<DynamicObject>>(16);
                calcMap.put(areaId, indicatorNodeResMap);
            }
            if (indicatorNodeResMap.containsKey(indicatorId)) {
                nodeResList = indicatorNodeResMap.get(indicatorId);
            } else {
                nodeResList = new ArrayList();
                indicatorNodeResMap.put(indicatorId, nodeResList);
            }
            nodeResList.add(nodeResult);
        }
    }

    private BigDecimal getAreaScoreInLimit(BigDecimal areaScore, DynamicObject area) {
        BigDecimal maxAreaScore = area.getBigDecimal("maxareascore");
        if (areaScore.compareTo(maxAreaScore) >= 0) {
            return maxAreaScore;
        }
        BigDecimal minAreaScore = area.getBigDecimal("minareascore");
        if (minAreaScore.compareTo(areaScore) >= 0) {
            return minAreaScore;
        }
        return areaScore;
    }

    private BigDecimal getFormScoreInLimit(BigDecimal formScore, DynamicObject assessForm) {
        BigDecimal minScore;
        BigDecimal maxScore;
        EvaSumLimit evaSumLimit = EvaSumLimit.getEvaSumLimit((String)assessForm.getString("evasumlimit"));
        if (evaSumLimit == EvaSumLimit.NOT_LIMIT) {
            return formScore;
        }
        if (evaSumLimit == EvaSumLimit.SUM_LIMIT) {
            maxScore = assessForm.getBigDecimal("scoresystem.maxscore");
            minScore = assessForm.getBigDecimal("scoresystem.minscore");
        } else if (evaSumLimit == EvaSumLimit.APPOINT_SUM_LIMIT) {
            maxScore = assessForm.getBigDecimal("limitmaxscore");
            minScore = assessForm.getBigDecimal("limitminscore");
        } else {
            return formScore;
        }
        if (formScore.compareTo(maxScore) >= 0) {
            return maxScore;
        }
        if (minScore.compareTo(formScore) >= 0) {
            return minScore;
        }
        return formScore;
    }

    private void calcFormResult(Long ruProcId, DynamicObject actEvalObj, DynamicObject assessForm, Map<Long, BigDecimal> nodeWeightMap) {
        DynamicObject[] nodeResults = OBJ_NODE_RES_ENTITY_SERVICE.queryNodeResByProcId(ruProcId);
        BigDecimal atcs = BigDecimal.ZERO;
        for (DynamicObject nodeResult : nodeResults) {
            atcs = atcs.add(nodeResult.getBigDecimal(AssessScoreAbbrEnum.SONT.getCode()).multiply(nodeWeightMap.get(nodeResult.getLong("flowrunode"))).divide(new BigDecimal(100), 6, 4));
        }
        Long scoreSystemIdByForm = assessForm.getLong("scoresystem.id");
        Long perfLevelIdForm = assessForm.getLong("sumperflevel.id");
        atcs = this.getFormScoreInLimit(atcs, assessForm);
        String level = "";
        List taskIdList = FLOW_RUN_SUP_DOMAIN_SERVICE.queryLevelTask(ruProcId);
        if (taskIdList.size() > 0) {
            level = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryLastRecordByTaskId(taskIdList);
        }
        if (StringUtils.isEmpty((String)level)) {
            level = OBJ_SUM_AREA_RECORD_ENTITY_SERVICE.queryLastRecordByProc(ruProcId);
        }
        if (StringUtils.isEmpty((String)level)) {
            level = ASSESS_RULE_DOMAIN_SERVICE.calculateLevel(assessForm, atcs);
        }
        actEvalObj.set(AssessScoreAbbrEnum.ATCS.getCode(), (Object)atcs);
        actEvalObj.set(AssessScoreAbbrEnum.ATCL.getCode(), (Object)level);
        actEvalObj.set(AssessScoreAbbrEnum.SOAT.getCode(), (Object)atcs);
        actEvalObj.set(AssessScoreAbbrEnum.LEVELOAT.getCode(), (Object)level);
        actEvalObj.set("soatsource", (Object)AssessScoreAbbrEnum.ATCS.getCode());
        actEvalObj.set(AssessScoreAbbrEnum.SOAC.getCode(), (Object)atcs);
        actEvalObj.set(AssessScoreAbbrEnum.LOAC.getCode(), (Object)level);
        actEvalObj.set(AssessScoreAbbrEnum.SOP.getCode(), (Object)atcs);
        actEvalObj.set(AssessScoreAbbrEnum.LOP.getCode(), (Object)level);
        actEvalObj.set("sopsource", (Object)AssessScoreAbbrEnum.SOAC.getCode());
        actEvalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)atcs);
        actEvalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
        actEvalObj.set("fsopsource", (Object)AssessScoreAbbrEnum.SOP.getCode());
        actEvalObj.set("fsopscoresystem", (Object)scoreSystemIdByForm);
        actEvalObj.set("floplevel", (Object)perfLevelIdForm);
        actEvalObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        actEvalObj.set("modifytime", (Object)new Date());
        ACT_EVAL_OBJ_ENTITY_SERVICE.saveOne(actEvalObj);
    }

    public void refreshScoreOnImportInd(List<Long> actEvalObjIdList) {
        List ruNodeTaskBoList = FLOW_ASSIST_DOMAIN_SERVICE.getRuNodeAndTask(actEvalObjIdList);
        if (CollectionUtils.isEmpty((Collection)ruNodeTaskBoList)) {
            return;
        }
        this.updateRefreshMark(actEvalObjIdList, true);
        for (RuNodeTaskBo ruNodeTaskBo : ruNodeTaskBoList) {
            THREAD_POOL.execute(() -> {
                try {
                    this.refreshScore(ruNodeTaskBo);
                }
                catch (Exception exception) {
                    LOG.error("refreshScore error: evaObjId[{}], ruProcId[{}]", new Object[]{ruNodeTaskBo.getEvaObj(), ruNodeTaskBo.getRuProc(), exception});
                }
                Long evaObj = ruNodeTaskBo.getEvaObj();
                this.updateRefreshMark(Collections.singletonList(evaObj), false);
            });
        }
    }

    private void updateRefreshMark(List<Long> actEvalObjIdList, boolean isInCalc) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = ACT_EVAL_OBJ_ENTITY_SERVICE.queryByObjIds(actEvalObjIdList)) {
            obj.set("isincalc", (Object)isInCalc);
        }
        ACT_EVAL_OBJ_ENTITY_SERVICE.save(objs);
    }

    private void refreshScore(RuNodeTaskBo ruNodeTaskBo) {
        Long nodeType;
        List ruNodeBoList = ruNodeTaskBo.getNodeBoList();
        ArrayList<Long> evalTaskIdList = new ArrayList<Long>();
        ArrayList<Long> adjustTaskIdList = new ArrayList<Long>();
        for (RuNodeBo ruNodeBo : ruNodeBoList) {
            nodeType = ruNodeBo.getNodeType();
            List ruTaskIdList = ruNodeBo.getRuTaskIdList();
            if (!CollectionUtils.isNotEmpty((Collection)ruTaskIdList)) continue;
            if (NodeTypeConstants.EVALUATE_SCORE.equals(nodeType)) {
                evalTaskIdList.addAll(ruTaskIdList);
                continue;
            }
            if (!NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType)) continue;
            adjustTaskIdList.addAll(ruTaskIdList);
        }
        if (evalTaskIdList.size() > 0) {
            LOG.info("evalTaskIdList id:{}", (Object)((Object)evalTaskIdList).toString());
            ACT_EVAL_OBJ_DETAIL_DOMAIN_SERVICE.updateEvalRecordEvaluation(evalTaskIdList);
        }
        for (int i = 0; i < ruNodeBoList.size(); ++i) {
            RuNodeBo ruNodeBo;
            ruNodeBo = (RuNodeBo)ruNodeBoList.get(i);
            nodeType = ruNodeBo.getNodeType();
            if (FlowRuNodeStatusEnum.FINISHED != ruNodeBo.getNodeStatus() || !NodeTypeConstants.EVALUATE_SCORE.equals(nodeType) && !NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeType)) continue;
            if (i == ruNodeBoList.size() - 1 || NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(((RuNodeBo)ruNodeBoList.get(i + 1)).getNodeType())) {
                this.calcRuProcResult(ruNodeBo.getRuNodeId(), ruNodeTaskBo.getRuProc(), ruNodeTaskBo.getEvaObj());
                continue;
            }
            if (!NodeTypeConstants.EVALUATE_SCORE.equals(nodeType)) continue;
            this.calcRuNodeResult(ruNodeBo.getRuNodeId(), ruNodeTaskBo.getEvaObj());
        }
        if (adjustTaskIdList.size() > 0) {
            LOG.info("adjustTaskIdList id:", (Object)((Object)adjustTaskIdList).toString());
            ACT_EVAL_OBJ_DETAIL_DOMAIN_SERVICE.updateEvalRecordBatchAdjust(adjustTaskIdList);
        }
    }
}

