/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;

public class BaseDataContainer {
    private Table<String, Object, List<DynamicObject>> basedataTable = HashBasedTable.create();
    private Table<String, Object, List<DynamicObject>> basedataIdTable = HashBasedTable.create();
    private ConcurrentHashMap<Object, DynamicObject> existsEntityDyMap;
    private ConcurrentHashMap<String, Map<Object, Object>> validateFailedBillDataFieldVaues;
    private Map<String, List<Long>> permBUMap = Maps.newConcurrentMap();
    private Table<String, String, Set<Long>> dataRulePermBasedataTable = HashBasedTable.create();
    private Table<String, Long, List<Long>> controlledBDPermTable = HashBasedTable.create();
    private ConcurrentHashMap<String, Map<Object, Boolean>> mainOrgPerm;

    public BaseDataContainer() {
        this.existsEntityDyMap = new ConcurrentHashMap(16);
        this.validateFailedBillDataFieldVaues = new ConcurrentHashMap(16);
        this.mainOrgPerm = new ConcurrentHashMap(16);
    }

    public List<DynamicObject> getBaseDataDy(String baseEntityId, Object importValue) {
        return (List)this.basedataTable.get((Object)baseEntityId, importValue);
    }

    public void addBaseDataDy(String baseEntityId, Object importValue, List<DynamicObject> newDynamicObjects) {
        if (newDynamicObjects == null || newDynamicObjects.size() == 0) {
            return;
        }
        this.basedataTable.put((Object)baseEntityId, importValue, newDynamicObjects);
    }

    public List<Long> getPermBU(String entityId) {
        return this.permBUMap.get(entityId);
    }

    public void setPermBU(String entityNumber, List<Long> permBU) {
        this.permBUMap.put(entityNumber, permBU);
    }

    public Set<Long> getDataRulePermBasedata(String parentEntityNum, String baseDataEntityNum) {
        return (Set)this.dataRulePermBasedataTable.get((Object)parentEntityNum, (Object)baseDataEntityNum);
    }

    public void addDataRulePermBasedata(String parentEntityNum, String baseDataEntityNum, Set<Long> dataRulePermBasedata) {
        this.dataRulePermBasedataTable.put((Object)parentEntityNum, (Object)baseDataEntityNum, dataRulePermBasedata);
    }

    public List<Long> getControlledBDPermTable(String entityNumber, Long useOrgId) {
        return (List)this.controlledBDPermTable.get((Object)entityNumber, (Object)useOrgId);
    }

    public Table<String, Long, List<Long>> getAllControlledBDPermTable() {
        return this.controlledBDPermTable;
    }

    public void setControlledBDPermTable(String entityNumber, Long useOrgId, List<Long> controlledBD) {
        this.controlledBDPermTable.put((Object)entityNumber, (Object)useOrgId, controlledBD);
    }

    public List<DynamicObject> getBasedataIdTable(String basedataEntityNum, Object id) {
        return (List)this.basedataIdTable.get((Object)basedataEntityNum, id);
    }

    public void setBasedataIdTable(String basedataEntityNum, Object id, List<DynamicObject> dy) {
        this.basedataIdTable.put((Object)basedataEntityNum, id, dy);
    }

    public Map<Object, DynamicObject> getExistsEntityDyMap() {
        return this.existsEntityDyMap;
    }

    public void addExistsEntityDyMap(Map<Object, DynamicObject> existsEntityDyMap) {
        this.existsEntityDyMap.putAll(existsEntityDyMap);
    }

    public ConcurrentHashMap<String, Map<Object, Object>> getValidateFailedBillDataFieldVaues() {
        return this.validateFailedBillDataFieldVaues;
    }

    public void setValidateFailedBillDataFieldVaues(ConcurrentHashMap<String, Map<Object, Object>> validateFailedBillDataFieldVaues) {
        this.validateFailedBillDataFieldVaues = validateFailedBillDataFieldVaues;
    }

    public Table<String, Object, List<DynamicObject>> getBasedataTable() {
        return this.basedataTable;
    }

    public Table<String, Object, List<DynamicObject>> getBasedataIdTable() {
        return this.basedataIdTable;
    }

    public ConcurrentHashMap<String, Map<Object, Boolean>> getMainOrgPerm() {
        return this.mainOrgPerm;
    }

    public void setMainOrgPerm(ConcurrentHashMap<String, Map<Object, Boolean>> mainOrgPerm) {
        this.mainOrgPerm = mainOrgPerm;
    }
}

