/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;

public class DataFlowSuggester {
    private static Log log = LogFactory.getLog(DataFlowSuggester.class);
    private IndImportStart importStart;
    private List<Long> lastExpenseTimes = new ArrayList<Long>(10);
    private long avgExpenseTimes;
    private int suggestBatchSize;
    private int suggestThreads;
    private int workerMaxThread;
    private int maxBatchSize;
    private ReentrantLock lock = new ReentrantLock();

    public DataFlowSuggester(IndImportStart importStart, int workerMaxThread) {
        this.importStart = importStart;
        this.workerMaxThread = workerMaxThread;
        this.maxBatchSize = DataFlowSuggester.getMaxBatchSize(importStart);
    }

    public void addExpenseTimes(Long expenseTimes) {
        Integer callopStandExpense = (Integer)this.importStart.getImportContext().getExtOption().get("callopStandExpense");
        if (expenseTimes.intValue() > callopStandExpense) {
            this.importStart.getMonitor().addOtherTotalCount("callOp_timeOut", 1);
        }
        if (this.lock.tryLock()) {
            try {
                if (this.lastExpenseTimes.size() >= 10) {
                    this.lastExpenseTimes.remove(0);
                }
                this.lastExpenseTimes.add(expenseTimes);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public int getSuggestBatchSize() {
        if (this.suggestBatchSize < 50) {
            this.suggestBatchSize = 50;
        }
        return this.suggestBatchSize;
    }

    public int getSuggestThreads() {
        if (this.suggestThreads < 1) {
            this.suggestThreads = 1;
        }
        return this.suggestThreads;
    }

    public void runDataFlowSuggest() {
        if (this.lastExpenseTimes.size() == 0) {
            return;
        }
        this.computeAvgExpenseTime();
        Integer callopStandExpense = (Integer)this.importStart.getImportContext().getExtOption().get("callopStandExpense");
        if (this.avgExpenseTimes > (long)callopStandExpense.intValue()) {
            if (this.suggestBatchSize >= 2) {
                this.suggestBatchSize = (int)((double)this.suggestBatchSize * 0.66);
            }
            if (this.suggestThreads >= 2) {
                this.suggestThreads = (int)((double)this.suggestThreads * 0.66);
            }
        } else {
            this.suggestBatchSize *= 2;
            if (this.suggestBatchSize > this.maxBatchSize) {
                this.suggestBatchSize = this.maxBatchSize;
            }
            this.suggestThreads = ++this.suggestThreads;
            if (this.suggestThreads > this.workerMaxThread) {
                this.suggestThreads = this.workerMaxThread;
            }
        }
    }

    public void initDataFlowSuggest() {
        int totalRowCount = this.importStart.getImportContext().getTotalRowCount();
        if (totalRowCount <= 5000) {
            this.suggestThreads = 1;
            this.suggestBatchSize = 50;
        } else if (totalRowCount <= 10000) {
            this.suggestThreads = 2;
            this.suggestBatchSize = 500;
        } else if (totalRowCount <= 100000) {
            this.suggestThreads = 3;
            this.suggestBatchSize = 800;
        } else {
            this.suggestThreads = this.workerMaxThread;
            this.suggestBatchSize = this.maxBatchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAvgExpenseTime() {
        long total = 0L;
        this.lock.lock();
        try {
            for (Long item : this.lastExpenseTimes) {
                total += item.longValue();
            }
            this.avgExpenseTimes = total / (long)this.lastExpenseTimes.size();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getWorkerMaxThread(IndImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int workerMaxThread = MCConfigConstant.getWorkerMaxThread();
        boolean needDbTransaction = DataFlowSuggester.isNeedDbTransaction(importStart.getImportContext());
        log.info("getWorkerMaxThread_isNeedDbTransaction=" + needDbTransaction);
        Map<String, Integer> sheetRowCountMap = importContext.getSheetRowCountMap();
        int totaolRows = sheetRowCountMap.values().stream().mapToInt(c -> c).sum();
        if (totaolRows > 200000) {
            workerMaxThread *= 2;
        }
        importStart.getMonitor().getImportTrace().getOther().put(DataFlowSuggester.class.getSimpleName() + "_workerMaxThread", workerMaxThread);
        return workerMaxThread;
    }

    private static boolean isNeedDbTransaction(ImportContext importContext) {
        return false;
    }

    private static int getMaxBatchSize(IndImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int maxBatchSize = 1000;
        importStart.getMonitor().getImportTrace().getOther().put(DataFlowSuggester.class.getSimpleName() + "_maxBatchSize", maxBatchSize);
        return maxBatchSize;
    }
}

