/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.SheetHandler;
import kd.opmc.epa.business.domain.indicator.imp.constant.ImportCacheKeyType;
import kd.opmc.epa.business.domain.indicator.imp.constant.IndConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportFileUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndReporter;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.xml.sax.SAXException;

public class ExcelImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(ExcelImportFailedSheetHandler.class);
    private final SXSSFWorkbook sxssfWorkbook;
    private final SXSSFWorkbook sxssfWorkbookOfErr;
    private final Map<String, SXSSFSheet> sheetsMap = new HashMap<String, SXSSFSheet>();
    private final Map<String, SXSSFSheet> sheetsOfErrMap = new HashMap<String, SXSSFSheet>();
    private final Map<String, SXSSFRow> nameRowsMap = new HashMap<String, SXSSFRow>();
    private final Map<Integer, CellStyle> stylesMap = new HashMap<Integer, CellStyle>();
    private final Map<Integer, CellStyle> stylesOfErrMap = new HashMap<Integer, CellStyle>();
    private final IndReporter importWorker;
    private final boolean isOnlyErrorReport;
    private int curErrorLineNum = 0;
    private boolean isFirstSheet = true;
    private boolean currentSheetNeedErrorColum = true;

    public ExcelImportFailedSheetHandler(IndReporter reporter) {
        this.importWorker = reporter;
        ImportContext importContext = reporter.getImportStart().getImportContext();
        this.sxssfWorkbook = new SXSSFWorkbook(5000);
        this.sxssfWorkbookOfErr = new SXSSFWorkbook(5000);
        int successedBillCount = importContext.getSuccessedBillCount().get();
        if (importContext.isSerialModel()) {
            int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
            int totalBillCount = importContext.getTotalBillCount();
            this.isOnlyErrorReport = 0 < successedValidateBillCount && successedValidateBillCount < totalBillCount ? false : successedValidateBillCount != totalBillCount || successedBillCount == 0;
        } else {
            this.isOnlyErrorReport = successedBillCount == 0;
        }
        this.initStylesMap(this.sxssfWorkbook, this.stylesMap);
        this.initStylesMap(this.sxssfWorkbookOfErr, this.stylesOfErrMap);
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        if (!this.isOnlyErrorReport) {
            this.initBook(this.sxssfWorkbook, this.sheetsMap, this.stylesMap, parsedRow, true);
        }
        this.initBook(this.sxssfWorkbookOfErr, this.sheetsOfErrMap, this.stylesOfErrMap, parsedRow, false);
    }

    @Override
    public void handleSheet(SheetHandler.ParsedRow parsedRow, SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, boolean isAllData) {
        int fieldNameIndex;
        ImportLog importLog = this.importWorker.getImportStart().getImportContext().getImportLog();
        ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog = importLog.getRowErrors().get(this.getCurrentSheetName());
        this.currentSheetNeedErrorColum = isAllData || errorLog != null && errorLog.size() != 0;
        int currRowNum = parsedRow.getRowNum();
        if (currRowNum == 0) {
            this.hasErrorRow = StringUtils.isEmpty((CharSequence)CommonUtil.getSplitValue(parsedRow.get(0)));
            this.curErrorLineNum = this.isFirstSheet ? 5 : 4;
            this.handleMergeCells(sxssfSheet, this.importWorker.getImportStart().getImportContext().getMergeCellList().get(this.getCurrentSheetName()), this.hasErrorRow, this.currentSheetNeedErrorColum);
            this.handleDataColStyle(workbook, sxssfSheet, stylesMap, this.hasErrorRow);
        }
        int n = fieldNameIndex = this.isFirstSheet ? 5 : 4;
        if (currRowNum == fieldNameIndex) {
            SXSSFRow curRow = this.getRow(sxssfSheet, currRowNum);
            curRow.setHidden(Boolean.valueOf(parsedRow.isHideRow()));
            this.nameRowsMap.put(this.getCurrentSheetName(), curRow);
            if (this.currentSheetNeedErrorColum) {
                SXSSFCell cell = curRow.createCell(0);
                ImportContext importContext = this.importWorker.getImportStart().getImportContext();
                if (importContext.isSerialModel() && importContext.getSuccessedValidateBillCount().get() != importContext.getTotalBillCount()) {
                    cell.setCellValue(ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"ExcelImportFailedSheetHandler_0", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else {
                    cell.setCellValue(ResManager.loadKDString((String)"\u5f15\u5165\u7ed3\u679c", (String)"ExcelImportFailedSheetHandler_1", (String)"opmc-epa-business", (Object[])new Object[0]));
                }
                sxssfSheet.setColumnWidth(0, 12800);
            }
        } else if (currRowNum > fieldNameIndex) {
            int curLine = this.writeErrCell(sxssfSheet, stylesMap, isAllData, currRowNum, errorLog, parsedRow);
            if (curLine < 0) {
                return;
            }
            currRowNum = curLine;
        }
        this.handleCorrectRow(parsedRow, workbook, sxssfSheet, stylesMap, currRowNum);
    }

    private int writeErrCell(SXSSFSheet sheet, Map<Integer, CellStyle> stylesMap, boolean isAllData, int currRowNum, ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog, SheetHandler.ParsedRow parsedRow) {
        AtomicBoolean flag;
        ImportRowErrorLog rowErrLog;
        ImportRowErrorLog importRowErrorLog = rowErrLog = errorLog == null ? null : errorLog.get(currRowNum + 1);
        if (rowErrLog != null) {
            SXSSFCell cell;
            String mergeLogStr;
            if (rowErrLog.getMsg().length() > 4000) {
                mergeLogStr = rowErrLog.getMsg().substring(0, 3996);
                mergeLogStr = mergeLogStr.concat("...");
            } else {
                mergeLogStr = rowErrLog.getMsg();
            }
            SXSSFRow curRow = null;
            if (isAllData) {
                curRow = this.getRow(sheet, currRowNum);
                cell = this.getCell(curRow);
            } else {
                curRow = this.getRow(sheet, ++this.curErrorLineNum);
                cell = this.getCell(curRow);
                currRowNum = this.curErrorLineNum;
            }
            curRow.setHidden(Boolean.valueOf(parsedRow.isHideRow()));
            cell.setCellValue(mergeLogStr);
            cell.setCellStyle(stylesMap.get(-1));
            return currRowNum;
        }
        if (isAllData) {
            AtomicBoolean flag2;
            if (errorLog != null && (flag2 = this.hasEntry(currRowNum, errorLog)).get()) {
                return currRowNum;
            }
            SXSSFRow row = this.getRow(sheet, currRowNum);
            SXSSFCell cell = this.getCell(row);
            cell.setCellValue(ResManager.loadKDString((String)"\u6210\u529f", (String)"ExcelImportFailedSheetHandler_2", (String)"opmc-epa-business", (Object[])new Object[0]));
            cell.setCellStyle(stylesMap.get(-2));
            return currRowNum;
        }
        if (errorLog != null && (flag = this.hasEntry(currRowNum, errorLog)).get()) {
            return ++this.curErrorLineNum;
        }
        return -1;
    }

    private AtomicBoolean hasEntry(int currRowNum, ConcurrentHashMap<Integer, ImportRowErrorLog> errorLog) {
        AtomicBoolean flag = new AtomicBoolean(false);
        int finalCurrRowNum = currRowNum + 1;
        errorLog.values().forEach(log -> {
            if (log.getStartIndex() <= finalCurrRowNum && log.getEndIndex() >= finalCurrRowNum) {
                flag.set(true);
            }
        });
        return flag;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        XSSFSheet sheet = this.sxssfWorkbookOfErr.getXSSFWorkbook().getSheet(this.getCurrentSheetName());
        if (sheet != null) {
            String ref = CommonUtil.tranDecimalToBase26(this.hasErrorRow ? this.getColCount() : this.getColCount() + 1);
            if (!this.isOnlyErrorReport) {
                CTWorksheet ctSheet = this.sxssfWorkbook.getXSSFWorkbook().getSheet(this.getCurrentSheetName()).getCTWorksheet();
                ctSheet.getDimension().setRef("A1:".concat(ref).concat(String.valueOf(this.getRowCount())));
            }
            CTWorksheet ctSheet2 = this.sxssfWorkbookOfErr.getXSSFWorkbook().getSheet(this.getCurrentSheetName()).getCTWorksheet();
            ctSheet2.getDimension().setRef("A1:".concat(ref).concat(String.valueOf(this.getRowCount())));
        }
        String lastsheet = this.getAllSheetNames().get(this.getAllSheetNames().size() - 1);
        if (this.getCurrentSheetName().equals(lastsheet)) {
            if (!this.isOnlyErrorReport) {
                this.ignoreSheet(this.sxssfWorkbook);
            }
            this.ignoreSheet(this.sxssfWorkbookOfErr);
            try {
                if (!this.isOnlyErrorReport) {
                    this.generateFileUrl(this.sxssfWorkbook, true);
                }
                this.generateFileUrl(this.sxssfWorkbookOfErr, false);
                this.writeUrlCache();
            }
            catch (IOException ioException) {
                LOGGER.error("ExcelImportFailedSheetHandler_endDocument() ioException:{}", (Object)ioException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFileUrl(SXSSFWorkbook workbook, boolean isAllData) throws IOException {
        IndImportStart importStart = this.importWorker.getImportStart();
        ImportContext importContext = importStart.getImportContext();
        File temp = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        try (FileOutputStream fos = new FileOutputStream(temp);
             FileInputStream fis = new FileInputStream(temp);){
            workbook.write((OutputStream)fos);
            String firstFileName = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25_", (String)"ExcelImportFailedSheetHandler_3", (String)"opmc-epa-business", (Object[])new Object[0]);
            if (importStart.getImportContext().getSuccessedBillCount().intValue() == importStart.getImportContext().getTotalBillCount()) {
                firstFileName = ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f_", (String)"ExcelImportFailedSheetHandler_4", (String)"opmc-epa-business", (Object[])new Object[0]);
            }
            LocalDate now = LocalDate.now();
            String fileName = firstFileName.concat(importContext.getFileName().split("\\.")[0]).concat("_").concat(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth())).concat(".xlsx");
            fileName = IndConstant.SpecCharPattern.matcher(fileName).replaceAll("");
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)importContext.getAppId(), (String)(importContext.getMainFormId() + UUID.randomUUID().toString()), (String)fileName);
            String uploadUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, path, (InputStream)fis));
            if (isAllData) {
                importContext.setErrorFileForAllData(uploadUrl);
            } else {
                importContext.setErrorFileForErrorData(uploadUrl);
            }
        }
        finally {
            workbook.dispose();
            workbook.close();
            try {
                ImportFileUtil.deleteLocalTempFile(temp.getPath());
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
    }

    private void writeUrlCache() {
        IndImportStart importStart = this.importWorker.getImportStart();
        IHRAppCache cache = HRAppCache.get((String)"epa");
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("errorFileForAllData", importStart.getImportContext().getErrorFileForAllData());
        customData.put("errorFileForErrorData", importStart.getImportContext().getErrorFileForErrorData());
        cache.put(MethodUtil.getTaskCachePath(String.valueOf(importStart.getImportContext().getTaskPkId()), ImportCacheKeyType.IMPORT, "urls"), (Object)customData);
    }

    @Override
    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        if (!this.isOnlyErrorReport) {
            this.handleValidations(cellValidations, this.sheetsMap);
        }
        this.handleValidations(cellValidations, this.sheetsOfErrMap);
    }

    @Override
    public void handleSheetComments(Map<String, CommentsTable> comments) {
        if (!this.isOnlyErrorReport) {
            this.handleSheetComments(this.sxssfWorkbook, this.nameRowsMap, this.isFirstSheet ? 5 : 4);
        }
        this.handleSheetComments(this.sxssfWorkbookOfErr, this.nameRowsMap, this.isFirstSheet ? 5 : 4);
        if (comments != null) {
            comments.clear();
        }
    }

    @Override
    protected int countIndex(int index) {
        if (this.hasErrorRow || !this.currentSheetNeedErrorColum) {
            return index;
        }
        return ++index;
    }
}

