/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.SheetHandler;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.task.BillDataSizeAssessTask;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;

public class ExcelImportSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(ExcelImportSheetHandler.class);
    private String tplType;
    private Map<String, Map<String, DynamicObject>> tplFieldConfig;
    private Map<String, Map<String, Object>> areaConfigMap = new HashMap<String, Map<String, Object>>(6);
    Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName;
    private boolean isMESS;
    private final Map<String, Set<String>> allBaseDataFieldKeys = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> allMulBaseDataFieldKeys = new HashMap<String, Set<String>>();
    private final Map<String, Set<Integer>> entryToColNum = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> entityToColNum = new HashMap<String, Set<Integer>>();
    private IndParser importWorker;
    private String setNullIdentify;
    private String curMainEntityNum;
    private Set<String> curEntityAllBaseDataKeys = new HashSet<String>();
    private Set<String> curEntityAllMulBaseDataKeys = new HashSet<String>();
    private Map<Integer, String> fieldNumRow;
    private int billIndex = 1;
    private int startIndex = 0;
    private int endIndex = 0;
    private int curExcelIndex = 0;
    private JSONObject data;
    private Set<Integer> emptyRowIndex;
    private SheetHandler.ParsedRow lastHeaderRow;

    public ExcelImportSheetHandler() {
    }

    public ExcelImportSheetHandler(IndParser parser) {
        this.importWorker = parser;
        this.tplType = parser.getImportStart().getImportContext().getOpType();
        this.tplFieldConfig = this.importWorker.getImportStart().getImportContext().getTplFieldConfig();
        this.areaConfigMap = this.importWorker.getImportStart().getImportContext().getAreaConfigMap();
        this.entityBdFieldMainPropName = this.importWorker.getImportStart().getImportContext().getEntityBdFieldMainPropName();
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        this.curExcelIndex = row.getRowNum() + 1;
        if (this.importWorker.getImportStart().isStoped()) {
            return;
        }
        boolean isFirstSheet = ((String)this.effectSheetNames.get(0)).equalsIgnoreCase(this.getCurrentSheetName());
        int currRowNum = row.getRowNum() - 1;
        try {
            Map<Integer, String> rowData = row.getData();
            if (currRowNum == 0) {
                this.importWorker.getImportStart().getImportContext().setHasErrorRow(StringUtils.isEmpty((CharSequence)CommonUtil.getSplitValue(rowData.get(0))));
                this.handleEntityRow(row);
            } else if (currRowNum == 3) {
                int offSet;
                this.fieldNumRow = rowData;
                int n = offSet = this.importWorker.getImportStart().getImportContext().isHasErrorRow() ? 1 : 2;
                if (this.isMESS) {
                    HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
                    this.groupByEntity(row, rowDataGroup);
                    rowDataGroup.forEach((entityNum, mapTemp) -> {
                        HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                        mapTemp.forEach((key, value) -> map.put(value, CommonUtil.tranDecimalToBase26(key + offSet)));
                        this.importWorker.getImportStart().getImportContext().setCellIndexOfEntities((String)entityNum, map);
                    });
                } else {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                    rowData.forEach((key, value) -> map.put(value, CommonUtil.tranDecimalToBase26(key + offSet)));
                    this.importWorker.getImportStart().getImportContext().setCellIndexOfEntities(this.curMainEntityNum, map);
                }
            } else if (currRowNum == 4) {
                int offSet;
                int n = offSet = this.importWorker.getImportStart().getImportContext().isHasErrorRow() ? 1 : 2;
                if (this.isMESS) {
                    HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
                    this.groupByEntity(row, rowDataGroup);
                    rowDataGroup.forEach((entityNum, mapTemp) -> {
                        HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                        mapTemp.forEach((key, value) -> map.put(CommonUtil.tranDecimalToBase26(key + offSet), value));
                        this.importWorker.getImportStart().getImportContext().setCellNameIndexOfEntities((String)entityNum, map);
                    });
                } else {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)rowData.size());
                    rowData.forEach((key, value) -> map.put(CommonUtil.tranDecimalToBase26(key + offSet), value));
                    this.importWorker.getImportStart().getImportContext().setCellNameIndexOfEntities(this.curMainEntityNum, map);
                }
            } else if (currRowNum > 4) {
                this.handDataRow(row);
            }
        }
        catch (Throwable exception) {
            LOGGER.error("ExcelImportSheetHandler.handleRow() error:", exception);
            throw exception;
        }
        this.importWorker.getImportStart().getImportContext().addParserCount();
    }

    private void handleEntityRow(SheetHandler.ParsedRow row) {
        Map<Integer, String> entityRowData = row.getData();
        ImportContext importContext = this.importWorker.getImportStart().getImportContext();
        String entityName = importContext.isHasErrorRow() ? row.get(1) : row.get(0);
        this.curMainEntityNum = CommonUtil.getSplitValue(entityName);
        this.getAllBaseDataFieldKeys(this.curMainEntityNum);
        Map<Integer, Set<Integer>> int2Range = this.getIntegerSetMap(entityRowData);
        entityRowData.forEach((key, value) -> {
            String splitValue = CommonUtil.getSplitValue(value);
            Set integers = (Set)int2Range.get(key);
            if (this.entryToColNum.get(splitValue) != null) {
                integers.addAll((Collection)this.entryToColNum.get(splitValue));
            }
            this.entryToColNum.put(splitValue, integers);
        });
        LOGGER.info("ExcelImportSheetHandler_handleEntityRow(),entryToColNum:{}", this.entryToColNum);
    }

    private void handDataRow(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (row.getData().size() == 0) {
            if (this.emptyRowIndex == null) {
                this.emptyRowIndex = Sets.newHashSet();
            }
            this.emptyRowIndex.add(currRowNum);
            if (this.data != null) {
                ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.getCurrentSheetName(), this.billIndex, this.startIndex, this.endIndex);
                this.pushBillData(importBillData);
                ++this.billIndex;
            }
            return;
        }
        if (this.importWorker.getImportStart().getImportContext().isHasErrorRow()) {
            row.getData().remove(0);
        }
        Set<Integer> fieldRange = row.getData().keySet();
        Set<Integer> colIndexOfEntity = this.entryToColNum.get(this.curMainEntityNum);
        if (currRowNum == 5) {
            LOGGER.info("ExcelImportSheetHandler.handDataRow(),curMainEntityNum:{},entryToColNum:{}", (Object)this.curMainEntityNum, this.entryToColNum);
        }
        if (colIndexOfEntity == null) {
            return;
        }
        HashMap rowDataGroup = Maps.newHashMapWithExpectedSize((int)16);
        if (this.isMESS) {
            this.groupByEntity(row, rowDataGroup);
        }
        boolean isNotSameOne = fieldRange.stream().anyMatch(colIndexOfEntity::contains);
        if (this.lastHeaderRow != null && isNotSameOne && currRowNum > 5) {
            AtomicBoolean flag = new AtomicBoolean(true);
            if (this.lastHeaderRow.getData().equals(row.getData())) {
                flag.set(false);
            } else {
                colIndexOfEntity.forEach(num -> {
                    String value1 = this.lastHeaderRow.get((Integer)num);
                    String value2 = row.get((Integer)num);
                    if (value1 != null && !value1.equals(value2) || value2 != null && !value2.equals(value1)) {
                        flag.set(false);
                    }
                });
            }
            if (flag.get()) {
                isNotSameOne = false;
            }
        }
        if (isNotSameOne) {
            this.lastHeaderRow = row;
            this.buildNewBillData(row, rowDataGroup);
        } else {
            ++this.endIndex;
            if (this.isMESS) {
                rowDataGroup.forEach(this::addNewEntryBatchByIsMESS);
            } else if (this.data != null) {
                this.addNewEntryBatch(this.curMainEntityNum, row.getData(), this.data.getJSONObject(this.curMainEntityNum));
            }
        }
    }

    private void groupByEntity(SheetHandler.ParsedRow row, Map<String, Map<Integer, String>> rowDataGroup) {
        Map<Integer, String> rowData = row.getData();
        rowData.forEach((key1, value) -> {
            Optional<Map.Entry> optional = this.entityToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(key1)).findFirst();
            if (optional.isPresent()) {
                Map orDefault = rowDataGroup.getOrDefault(optional.get().getKey(), new HashMap());
                orDefault.put(key1, value);
                rowDataGroup.put((String)optional.get().getKey(), orDefault);
            }
        });
    }

    private void buildNewBillData(SheetHandler.ParsedRow row, Map<String, Map<Integer, String>> rowDataGroup) {
        if (this.data != null) {
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.getCurrentSheetName(), this.billIndex, this.startIndex, this.endIndex);
            this.pushBillData(importBillData);
            ++this.billIndex;
        }
        if (this.isMESS) {
            this.data = new JSONObject();
            rowDataGroup.forEach((key, value) -> {
                if (key.equals(this.curMainEntityNum)) {
                    this.data.putAll((Map)this.rowConvertJson((String)key, (Map<Integer, String>)value));
                } else {
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add((Object)this.rowConvertJson((String)key, (Map<Integer, String>)value).getJSONObject(key));
                    this.data.put(key, (Object)jsonArray);
                }
            });
        } else {
            this.data = this.rowConvertJson(this.curMainEntityNum, row.getData());
        }
        this.endIndex = this.startIndex = row.getRowNum() + 1;
    }

    private JSONObject rowConvertJson(String curEntityId, Map<Integer, String> rowData) {
        JSONObject dataMap = new JSONObject(rowData.size());
        JSONObject entityLevelMap = new JSONObject(rowData.size());
        this.curEntityAllBaseDataKeys = this.allBaseDataFieldKeys.get(curEntityId);
        this.curEntityAllMulBaseDataKeys = this.allMulBaseDataFieldKeys.get(curEntityId);
        for (Map.Entry<Integer, String> row : rowData.entrySet()) {
            Integer index = row.getKey();
            if (this.importWorker.getImportStart().getImportContext().isHasErrorRow() && index.longValue() == 0L) continue;
            Optional<Map.Entry> optional = this.entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(index)).findFirst();
            String entityKey = optional.isPresent() ? (String)optional.get().getKey() : "";
            boolean isMainEntity = entityKey.equalsIgnoreCase(curEntityId);
            String fieldKey = this.fieldNumRow.get(index);
            if (StringUtils.isBlank((CharSequence)fieldKey)) continue;
            Object fieldLevelMap = entityLevelMap.computeIfAbsent((Object)entityKey, key -> {
                if (isMainEntity) {
                    return null;
                }
                return new JSONArray();
            });
            if (null != fieldLevelMap) {
                if (fieldLevelMap instanceof JSONArray) {
                    Object tempMap = ((JSONArray)fieldLevelMap).size() > 0 ? ((JSONArray)fieldLevelMap).get(0) : new JSONObject();
                    this.buildDataMap(curEntityId, row, fieldKey, tempMap);
                    ((JSONArray)fieldLevelMap).clear();
                    ((JSONArray)fieldLevelMap).add(tempMap);
                    continue;
                }
                this.buildDataMap(curEntityId, row, fieldKey, fieldLevelMap);
                continue;
            }
            this.buildDataMap(curEntityId, row, fieldKey, entityLevelMap);
        }
        dataMap.put(curEntityId, (Object)entityLevelMap);
        return dataMap;
    }

    private void buildDataMap(String curEntityId, Map.Entry<Integer, String> row, String fieldKey, Object dataMapList) {
        String rowValue = row.getValue().equals(this.setNullIdentify) ? null : row.getValue();
        JSONObject dataMap = new JSONObject();
        if (dataMapList == null) {
            return;
        }
        if (dataMapList instanceof JSONObject) {
            dataMap = (JSONObject)dataMapList;
            dataMap.putIfAbsent((Object)"$excelIndex", (Object)this.curExcelIndex);
        }
        if (fieldKey.contains(".")) {
            this.putMulLevelDataMap(curEntityId, fieldKey, rowValue, dataMap);
        } else {
            dataMap.put(fieldKey, (Object)rowValue);
        }
    }

    private void putMulLevelDataMap(String curEntityId, String fieldKey, String rowValue, JSONObject dataMap) {
        String[] split = fieldKey.split("\\.");
        String splitFirst = split[0];
        String splitSecond = split[1];
        if (this.curEntityAllMulBaseDataKeys.contains(splitFirst)) {
            if (rowValue == null) {
                dataMap.put(splitFirst, null);
            } else {
                JSONArray map = new JSONArray();
                Arrays.stream(rowValue.split(",")).forEach(array -> {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, array);
                    map.add((Object)temp);
                });
                JSONArray jobjs = (JSONArray)dataMap.get((Object)splitFirst);
                if (jobjs == null) {
                    dataMap.put(splitFirst, (Object)map);
                } else {
                    JSONObject temp = new JSONObject();
                    temp.put(splitSecond, (Object)rowValue);
                    jobjs.add((Object)temp);
                }
            }
        } else {
            JSONObject map = dataMap.containsKey((Object)splitFirst) ? dataMap.getJSONObject(splitFirst) : new JSONObject();
            map.put(splitSecond, (Object)rowValue);
            dataMap.put(split[0], (Object)map);
        }
    }

    private void putBaseDataMap(String rowValue, String fieldKey, JSONObject dataMap, Map<String, Map<String, Object>> entityFieldProName) {
        if (rowValue == null) {
            dataMap.put(fieldKey, null);
        } else {
            Map<String, Object> fieldProName = entityFieldProName.get(ImportUtil.getLevelOneKey(fieldKey));
            String realName = (String)fieldProName.get("name");
            String realNumber = (String)fieldProName.get("number");
            String[] split = rowValue.split("##");
            JSONObject tempJson = new JSONObject();
            tempJson.put(realNumber, (Object)split[0]);
            tempJson.put(realName, (Object)(split.length > 1 ? split[1] : ""));
            if (rowValue.contains("##")) {
                tempJson.put("$bdSplit", (Object)"##");
            }
            dataMap.put(fieldKey, (Object)tempJson);
        }
    }

    private void addNewEntryBatchByIsMESS(String curEntityNum, Map<Integer, String> rowData) {
        Set<Integer> fieldRange = rowData.keySet();
        Set<Integer> integers = this.entryToColNum.get(curEntityNum);
        Object dataObject = this.data.get((Object)curEntityNum);
        if (fieldRange.stream().noneMatch(integers::contains)) {
            if (dataObject instanceof JSONArray) {
                int size = ((JSONArray)dataObject).size() - 1;
                JSONObject jsonObject = ((JSONArray)dataObject).getJSONObject(size);
                this.addNewEntryBatch(curEntityNum, rowData, jsonObject);
                ((JSONArray)dataObject).remove(size);
                ((JSONArray)dataObject).add((Object)jsonObject);
                this.data.put(curEntityNum, dataObject);
            } else {
                this.addNewEntryBatch(curEntityNum, rowData, (JSONObject)dataObject);
            }
        } else if (dataObject instanceof JSONArray) {
            ((JSONArray)dataObject).add((Object)this.rowConvertJson(curEntityNum, rowData).getJSONObject(curEntityNum));
            this.data.put(curEntityNum, dataObject);
        }
    }

    private void addNewEntryBatch(String curEntityId, Map<Integer, String> rowData, JSONObject entityLevelMap) {
        this.curEntityAllBaseDataKeys = this.allBaseDataFieldKeys.get(curEntityId);
        this.curEntityAllMulBaseDataKeys = this.allMulBaseDataFieldKeys.get(curEntityId);
        JSONObject entryMap = new JSONObject();
        this.entryToColNum.keySet().stream().filter(field -> !field.equals(curEntityId)).forEach(entityKey -> entryMap.put(entityKey, (Object)new JSONObject()));
        for (Map.Entry<Integer, String> ob : rowData.entrySet()) {
            Integer index = ob.getKey();
            String fieldKey = this.fieldNumRow.get(index);
            Optional<Map.Entry> findFirst = this.entryToColNum.entrySet().stream().filter(key -> ((Set)key.getValue()).contains(index)).findFirst();
            if (!findFirst.isPresent()) {
                LOGGER.info("ExcelImportSheetHandler.addNewEntryBatch(),entryToColNum:{},index:{},fieldKey:{}", new Object[]{this.entryToColNum, index, fieldKey});
                continue;
            }
            String entityKey2 = (String)findFirst.get().getKey();
            JSONObject fieldLevelMap = entryMap.getJSONObject(entityKey2);
            this.buildDataMap(curEntityId, ob, fieldKey, fieldLevelMap);
            entryMap.put(entityKey2, (Object)fieldLevelMap);
        }
        for (Map.Entry<Integer, String> entity : entryMap.entrySet()) {
            Object fieldLevelMap = entityLevelMap.get((Object)entity.getKey());
            if (fieldLevelMap == null && !((String)((Object)entity.getKey())).equalsIgnoreCase(curEntityId)) {
                fieldLevelMap = entityLevelMap.computeIfAbsent((Object)entity.getKey(), val -> new JSONArray());
            }
            if (!(fieldLevelMap instanceof JSONArray)) continue;
            ((JSONArray)fieldLevelMap).add((Object)entity.getValue());
        }
        this.data.put(curEntityId, (Object)entityLevelMap);
    }

    @Override
    public void endDocument() {
        if (this.data != null) {
            ImportBillData importBillData = new ImportBillData(this.curMainEntityNum, this.data, this.getCurrentSheetName(), this.billIndex, this.startIndex, this.endIndex);
            this.pushBillData(importBillData);
            ++this.billIndex;
        }
        if (this.emptyRowIndex == null) {
            this.emptyRowIndex = Sets.newHashSet();
        }
        this.importWorker.getImportStart().getImportContext().getImportLog().addEmptyRowIndex(this.getCurrentSheetName(), this.emptyRowIndex);
        this.emptyRowIndex = Sets.newHashSet();
        this.curMainEntityNum = null;
        this.startIndex = 0;
        this.entryToColNum.clear();
        this.entityToColNum.clear();
    }

    private void pushBillData(ImportBillData billData) {
        int retryCount = 100;
        this.importWorker.putToOutQueue(billData, retryCount);
        int count = ImportUtil.statisticsBillCount(billData);
        this.importWorker.getImportStart().getImportContext().addTotalBillCount(count);
        this.collectBillDataToAssess(billData);
        this.data = null;
    }

    private void collectBillDataToAssess(ImportBillData billData) {
        List importBillData;
        IndParser parser = this.importWorker;
        ImportContext importContext = parser.getImportStart().getImportContext();
        if (BillDataSizeAssessTask.canTriggerBillDataSizeAssess(importContext) && (importBillData = parser.getSheetDataSamplingMap().computeIfAbsent(billData.getSheetName(), ob -> new ArrayList(10))).size() < 10) {
            importBillData.add(billData);
            if (importBillData.size() == 10) {
                parser.getImportStart().getPool().submit((Callable)new BillDataSizeAssessTask(this.importWorker, importBillData));
            }
        }
    }

    private void getAllBaseDataFieldKeys(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            LOGGER.warn("ExcelImportSheetHandler_getAllBaseDataFieldKeys(),entityId is null");
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        HashSet<String> allKeys = new HashSet<String>();
        HashSet<String> allMulKeys = new HashSet<String>();
        CommonUtil.getAllBDFieldKeys(entityType.getProperties(), allKeys, allMulKeys);
        this.allBaseDataFieldKeys.put(entityId, allKeys);
        this.allMulBaseDataFieldKeys.put(entityId, allMulKeys);
    }
}

