/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.ExportWriterBuilder;
import kd.opmc.epa.business.domain.indicator.imp.GenImportTplHeaderWriter;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportDataWriterFormat;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportHeaderWriterFormat;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportSheetStyle;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ExcelStyleUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ExcelTemplateGenerate {
    private static final Log log = LogFactory.getLog(ExcelTemplateGenerate.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static Pattern SpecCharPattern = Pattern.compile("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]");

    public static void genAreaCusName(Map<String, Object> param) {
        Long confId = (Long)param.get("confid");
        String entityName = (String)param.get("confEntity");
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper(entityName);
        DynamicObject conf = HELPER.queryOne((Object)confId);
        String customName = conf.getString("areacustname");
        param.put("areacustname", customName);
    }

    public static String genTemplate(List<Map<String, Object>> param) throws Exception {
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        wb.setCompressTempFiles(true);
        ExportSheetStyle styles = ExcelStyleUtil.getPreViewExportSheetStyle(wb, null);
        for (Map<String, Object> stringObjectMap : param) {
            Long confId = (Long)stringObjectMap.get("confid");
            String entityName = (String)stringObjectMap.get("entityName");
            Integer numAccuracy = (Integer)stringObjectMap.get("numaccuracy");
            HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_normalconf");
            DynamicObject conf = HELPER.queryOne((Object)confId);
            String customName = conf.getString("areacustname");
            ExportWriterBuilder builder = new ExportWriterBuilder(numAccuracy);
            List<ExportHeaderWriterFormat> headerWriterFormats = builder.build(conf, entityName);
            ExcelTemplateGenerate.writerExcel(headerWriterFormats, wb, styles, customName);
        }
        return ExcelTemplateGenerate.saveAndUploadFile(wb);
    }

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    private static SXSSFWorkbook writerExcel(List<ExportHeaderWriterFormat> headerWriterFormats, SXSSFWorkbook wb, ExportSheetStyle styles, String sheetName) {
        boolean existMergeCol = false;
        String tmpltype = "IMPT";
        String entitytype = "SE";
        if ("SE".equals(entitytype) || "MESS".equals(entitytype)) {
            int headerTotalOffset = 0;
            String name = sheetName;
            name = CommonUtil.getLegalSheetName(name, tmpltype);
            SXSSFSheet sheet = wb.createSheet(name);
            SXSSFSheet dropdownSheet = wb.createSheet(name + "DDM");
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                if (!styles.isExistMergeCol(format.getEnityName())) continue;
                existMergeCol = true;
                break;
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                ExportDataWriterFormat dataWriterFormat = new ExportDataWriterFormat();
                dataWriterFormat.setEnityName(format.getEnityName());
                dataWriterFormat.setMainEntity(format.isMainEntity());
                dataWriterFormat.setEntryentity(format.isEntryentity());
                if (existMergeCol) {
                    format.setDropDownStartIndex(format.getDropDownStartIndex() + 1);
                }
                headerTotalOffset = GenImportTplHeaderWriter.writeHeader(wb, sheet, dropdownSheet, styles, format, headerTotalOffset, dataWriterFormat, existMergeCol);
            }
            wb.setSheetHidden(wb.getSheetIndex((Sheet)dropdownSheet), true);
            CTWorksheet ctSheet = wb.getXSSFWorkbook().getSheet(sheet.getSheetName()).getCTWorksheet();
            ctSheet.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel(headerTotalOffset) + sheet.getPhysicalNumberOfRows());
        }
        return wb;
    }

    /*
     * Exception decompiling
     */
    private static String saveAndUploadFile(SXSSFWorkbook book) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

