/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportHeaderWriterFormat;
import kd.opmc.epa.common.constants.AssessTableConfConstants;

public class ExportWriterBuilder {
    private static final Log log = LogFactory.getLog(ExportWriterBuilder.class);
    private static final String NUMBER = "number";
    private Integer numAccuracy = 2;
    private static final String FLEX_PROP_GROUPS = "flexpropgroups";
    private String kdName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_0", (String)"opmc-epa-business", (Object[])new Object[0]);
    private String kdCode = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)"opmc-epa-business", (Object[])new Object[0]);
    private String kdId = ResManager.loadKDString((String)"\u5185\u7801", (String)"ExportWriterBuilder_2", (String)"opmc-epa-business", (Object[])new Object[0]);
    private Map<String, String> defaultFieldNameMap = this.getDefaultFieldNameMap();

    public ExportWriterBuilder() {
    }

    public ExportWriterBuilder(Integer numAccuracy) {
        this.numAccuracy = numAccuracy;
    }

    public List<ExportHeaderWriterFormat> build(DynamicObject conf, String entityName) {
        String entitytype = "SE";
        String mainEntityName = entityName;
        HashMap fieldSetMapping = new HashMap(16);
        HashMap entityHasFieldimportdesc = Maps.newHashMapWithExpectedSize((int)4);
        boolean isForImport = true;
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        MainEntityType mianEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityName);
        entityTypes.add(mianEntityType);
        Set notLoadFiled = Arrays.stream(AssessTableConfConstants.GEN_IGNORE_FIELD).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        LinkedHashMap<String, DynamicObject> fieldSet = new LinkedHashMap<String, DynamicObject>(16);
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (notLoadFiled.contains(fieldKey)) continue;
            String custName = fieldInfo.getString("fieldcustname");
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            areaField.set("name", (Object)custName);
            fieldSet.put(fieldKey, areaField);
        }
        boolean isAllowEval = conf.getBoolean("reversepoints");
        String adjustType = conf.getString("adjusttype");
        MainEntityType EntityType2 = EntityMetadataCache.getDataEntityType((String)"epa_areafieldreg");
        if (isAllowEval && !"1".equals(adjustType)) {
            DynamicObject minEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
            minEvalScoreField.set(NUMBER, (Object)"minevalscore");
            minEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650", (String)"ExportWriterBuilder_3", (String)"opmc-epa-business", (Object[])new Object[0]));
            minEvalScoreField.set("ismustinput", (Object)Boolean.TRUE);
            fieldSet.put("minevalscore", minEvalScoreField);
            DynamicObject maxEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
            maxEvalScoreField.set(NUMBER, (Object)"maxevalscore");
            maxEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650", (String)"ExportWriterBuilder_4", (String)"opmc-epa-business", (Object[])new Object[0]));
            maxEvalScoreField.set("ismustinput", (Object)Boolean.TRUE);
            fieldSet.put("maxevalscore", maxEvalScoreField);
        }
        DynamicObject maxEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
        maxEvalScoreField.set(NUMBER, (Object)"iseditable");
        maxEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u5141\u8bb8\u4fee\u6539", (String)"ExportWriterBuilder_5", (String)"opmc-epa-business", (Object[])new Object[0]));
        maxEvalScoreField.set("ismustinput", (Object)Boolean.FALSE);
        fieldSet.put("iseditable", maxEvalScoreField);
        fieldSetMapping.put(mainEntityName, fieldSet);
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        ArrayList<ExportHeaderWriterFormat> formatlist = new ArrayList<ExportHeaderWriterFormat>(10);
        for (MainEntityType entityType : entityTypes) {
            String enitytName = entityType.getName();
            ExportHeaderWriterFormat writer = new ExportHeaderWriterFormat(enitytName, entityType.getDisplayName().toString(), 0);
            writer.setBelongEntityName(enitytName);
            if (enitytName.equals(mainEntityName)) {
                writer.setMainEntity(true);
                writer.setRowStartIndex(0);
            } else if ("MESS".equals(entitytype)) {
                writer.setRowStartIndex(1);
            }
            writer.setHasFieldimportdesc(entityHasFieldimportdesc.containsKey(enitytName));
            if (fieldSet == null || fieldSet.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u4e2a\u5b9e\u4f53\u90fd\u5fc5\u987b\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u5f15\u5165/\u5f15\u51fa\u5b57\u6bb5\u3002", (String)"ExportWriterBuilder_6", (String)"opmc-epa-business", (Object[])new Object[0]));
            }
            this.parse((DynamicObjectType)entityType, fieldSet, writer, multiLangEnabledLang, isForImport);
            formatlist.add(writer.ready(((Map)fieldSetMapping.getOrDefault(enitytName, new HashMap())).keySet()));
        }
        return formatlist;
    }

    private int getFlexPropGroups(String formId) {
        int groups = 16;
        DynamicObject billParameter = ParameterReader.getBillParameter((String)formId);
        if (null != billParameter && ((groups = billParameter.getInt(FLEX_PROP_GROUPS)) < 1 || groups > 50)) {
            return 16;
        }
        return groups;
    }

    private boolean isSysParamExportId() {
        Map map = ParameterReader.loadPublicParameterFromCache();
        if (CollectionUtils.isEmpty((Map)map)) {
            return false;
        }
        if (map.containsKey("importtrmplatehasid")) {
            return (Boolean)map.get("importtrmplatehasid");
        }
        return false;
    }

    private String getF7bdSheetName(String sheetName, String sheetNumber, Set<String> f7BDSheetNameSet) {
        if (f7BDSheetNameSet.isEmpty()) {
            f7BDSheetNameSet.add(sheetName);
            return sheetName;
        }
        if (f7BDSheetNameSet.contains(sheetName)) {
            f7BDSheetNameSet.add(sheetName + sheetNumber);
            return sheetName + sheetNumber;
        }
        f7BDSheetNameSet.add(sheetName);
        return sheetName;
    }

    private int parse(DynamicObjectType entityType, Map<String, DynamicObject> fieldSet, ExportHeaderWriterFormat writer, List<EnabledLang> enableLangs, boolean isForImport) {
        int col = writer.getStartColNumber();
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, IDataEntityProperty> propertyMap = properties.stream().collect(Collectors.toMap(x -> x.getName(), y -> y));
        for (Map.Entry<String, DynamicObject> entrySet : fieldSet.entrySet()) {
            String number = entrySet.getKey();
            DynamicObject field = entrySet.getValue();
            IDataEntityProperty prop = propertyMap.get(number);
            if (prop == null) continue;
            boolean isID = "id".equalsIgnoreCase(prop.getName());
            String propName = prop.getName();
            if (isID && !(entityType instanceof MainEntityType)) {
                propName = prop.getParent().getName() + "." + propName;
            }
            if (prop instanceof LinkEntryProp || prop instanceof BasedataProp || !(prop instanceof IFieldHandle) || (!isID || !isForImport) && !((IFieldHandle)prop).isImportable() && !((IFieldHandle)prop).isExportable()) continue;
            String currLang = RequestContext.getOrCreate().getLang().name();
            LinkedList<String> props = new LinkedList<String>();
            LinkedList<String> dataKeyProps = new LinkedList<String>();
            boolean isBasedata = prop instanceof IBasedataField;
            boolean isMultiLang = false;
            boolean isLargeText = prop instanceof LargeTextProp;
            HashMap<String, Object> property = new HashMap<String, Object>(16);
            property.put("Prop", prop);
            property.put("propName", propName);
            property.put("DisplayName", field.getString("name"));
            property.put("MustInput", field.getBoolean("ismustinput"));
            this.parseProp(prop, isID, isBasedata, isMultiLang, isLargeText, property);
            this.parseMultiProp(prop, currLang, props, dataKeyProps, isMultiLang, isLargeText, property);
            writer.getFields().add(propName);
            writer.getProperties().put(propName, property);
        }
        return col;
    }

    private void parseProp(IDataEntityProperty prop, boolean isID, boolean isBasedata, boolean isMultiLang, boolean isLargeText, Map<String, Object> property) {
        if (isID) {
            property.put("InputType", "id");
            property.put("InputDesc", ResManager.loadKDString((String)"\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027", (String)"ExportWriterBuilder_7", (String)"opmc-epa-business", (Object[])new Object[0]));
        } else if (isLargeText) {
            property.put("InputType", "largetext");
        } else if (isMultiLang) {
            property.put("InputType", "multilang");
        } else if (prop instanceof MuliLangTextProp) {
            property.put("InputType", "varchar");
            property.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_8", (String)"opmc-epa-business", (Object[])new Object[0]));
        } else if (prop instanceof TextProp || prop instanceof VarcharProp) {
            property.put("InputType", "varchar");
            property.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_8", (String)"opmc-epa-business", (Object[])new Object[0]));
        } else if (!(prop instanceof AdminDivisionProp)) {
            if (prop instanceof DecimalProp) {
                property.put("InputType", "decimal");
                HashMap<String, Integer> decimalformat = new HashMap<String, Integer>();
                decimalformat.put("precision", this.numAccuracy);
                property.put("DecimalFormat", decimalformat);
                property.put("InputDesc", ResManager.loadKDString((String)"\u6570\u5b57", (String)"ExportWriterBuilder_9", (String)"opmc-epa-business", (Object[])new Object[0]));
            } else if (!isBasedata) {
                if (prop instanceof TimeProp) {
                    property.put("InputType", "time");
                    property.put("InputDesc", ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a12:00:00", (String)"ExportWriterBuilder_10", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (prop instanceof DateProp) {
                    property.put("InputType", "date");
                    property.put("InputDesc", ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"ExportWriterBuilder_11", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (prop instanceof DateTimeProp) {
                    property.put("InputType", "datetime");
                    property.put("InputDesc", ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a2018-05-01 12:00:00", (String)"ExportWriterBuilder_12", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (prop instanceof BooleanProp) {
                    property.put("InputType", "boolean");
                    ArrayList<String> predata = new ArrayList<String>(2);
                    predata.add(ResManager.loadKDString((String)"\u662f", (String)"ExportWriterBuilder_13", (String)"opmc-epa-business", (Object[])new Object[0]));
                    predata.add(ResManager.loadKDString((String)"\u5426", (String)"ExportWriterBuilder_14", (String)"opmc-epa-business", (Object[])new Object[0]));
                    property.put("DropdownValues", predata);
                    property.put("InputDesc", ResManager.loadKDString((String)"\u9009\u9879\uff0c\u662f/\u5426", (String)"ExportWriterBuilder_15", (String)"opmc-epa-business", (Object[])new Object[0]));
                } else if (prop instanceof ComboProp) {
                    this.parseComboProp(prop, property);
                }
            }
        }
    }

    private void parseMultiProp(IDataEntityProperty prop, String currLang, List<String> props, List<String> dataKeyProps, boolean isMultiLang, boolean isLargeText, Map<String, Object> property) {
        if (isMultiLang) {
            property.put("DataKey", currLang);
        } else if (isLargeText) {
            property.put("DataKey", "largetext");
        } else if (prop instanceof FlexProp) {
            property.put("DataKey", "value");
        } else if (prop instanceof IBasedataField) {
            ArrayList<String> mulDataKey = null;
            if (prop instanceof MulBasedataProp) {
                mulDataKey = new ArrayList<String>(props.size());
                for (String p : props) {
                    mulDataKey.add("fbasedataid." + p);
                }
            }
            property.put("DataKey", mulDataKey == null ? dataKeyProps : mulDataKey);
        }
    }

    private int getCol(ExportHeaderWriterFormat writer, List<EnabledLang> enableLangs, int col, IDataEntityProperty prop, String propName, String currLang, List<String> props, List<String> propDisplayNames, boolean isBasedata, boolean isMultiLang, boolean isLargeText) {
        if (isBasedata || isMultiLang || isLargeText) {
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<String> display = new ArrayList<String>();
            ArrayList<String> desc = new ArrayList<String>();
            if (isMultiLang) {
                String comment = ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_8", (String)"opmc-epa-business", (Object[])new Object[0]);
                for (EnabledLang lang : enableLangs) {
                    if (lang.number.equals(currLang)) {
                        items.add(0, propName + "." + lang.number);
                        display.add(0, this.getDisplayName(prop) + "(" + lang.name + ")");
                        desc.add(0, comment);
                        continue;
                    }
                    items.add(propName + "." + lang.number);
                    display.add(this.getDisplayName(prop) + "(" + lang.name + ")");
                    desc.add(comment);
                }
            } else if (isLargeText) {
                for (String p : props) {
                    items.add(p);
                }
                for (int i = 0; i < propDisplayNames.size(); ++i) {
                    display.add(propDisplayNames.get(i));
                }
            }
            writer.getFlexColumn().put(propName, items);
            writer.getFlexColumnDisplay().put(propName, display);
            writer.getFlexColumnDesc().put(propName, desc);
            col += items.size();
        } else {
            ++col;
        }
        return col;
    }

    private void parseComboProp(IDataEntityProperty prop, Map<String, Object> property) {
        try {
            ArrayList itemList = new ArrayList(((ComboProp)prop).getComboItems());
            Iterator iterator = itemList.iterator();
            while (iterator.hasNext()) {
                ValueMapItem next = (ValueMapItem)iterator.next();
                if (next.isItemVisible()) continue;
                iterator.remove();
            }
            ArrayList<String> items = new ArrayList<String>(itemList.size());
            String[] itemDesc = new String[itemList.size()];
            for (int index = 0; index < itemList.size(); ++index) {
                String name = ((ValueMapItem)itemList.get(index)).getName().toString();
                items.add(name);
                itemDesc[index] = name;
            }
            property.put("DropdownValues", items);
            property.put("InputType", "dropdownList");
            if (prop instanceof MulComboProp) {
                property.put("PropType", "MulComboProp");
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < itemDesc.length; ++i) {
                    if (i != itemDesc.length - 1) {
                        stringBuilder.append(itemDesc[i]).append("\u3001");
                        continue;
                    }
                    stringBuilder.append(itemDesc[i]);
                }
                String tips = ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a{0}\uff0c\u591a\u4e2a\u9009\u9879\u4ee5\u2018,\u2019\u5206\u9694", (String)"ExportWriterBuilder_18", (String)"opmc-epa-business", (Object[])new Object[]{stringBuilder.toString()});
                property.put("InputDesc", tips);
            }
        }
        catch (Throwable e) {
            log.error(e);
            throw new KDBizException("get combo item list ".concat(prop.getDisplayName().getLocaleValue()).concat("'s failed'\uff1akey=").concat(prop.getName()));
        }
    }

    private String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        if ("id".equals(prop.getName())) {
            return this.kdId;
        }
        LocaleString displayName = prop.getDisplayName();
        if (StringUtils.isBlank((Object)displayName)) {
            return prop.getName();
        }
        return displayName.toString();
    }

    private Map<String, String> getDefaultFieldNameMap() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", this.kdId);
        map.put("name", this.kdName);
        map.put(NUMBER, this.kdCode);
        return map;
    }
}

