/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.ExcelHelper;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportDataWriterFormat;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportHeaderWriterFormat;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportSheetStyle;
import kd.opmc.epa.business.domain.indicator.imp.util.ExcelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class GenImportTplHeaderWriter {
    private static final String RESULT = "result";
    private static final String EXTEND = "extend";
    private static Log log = LogFactory.getLog(GenImportTplHeaderWriter.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String COLWIDTH_KEY = "ColWidth";

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportHeaderWriterFormat format, int preOffset, ExportDataWriterFormat dataWriterFormat, boolean existMergeCol) {
        boolean isMainEntity;
        String entityName = format.getEnityName();
        String belongEntityName = format.getBelongEntityName();
        int rowIndex = format.getRowStartIndex();
        int headerTotalOffset = preOffset;
        AtomicInteger currentEntityColumnCount = new AtomicInteger(0);
        int column = format.getStartColNumber() + headerTotalOffset;
        SXSSFRow templateCodeRow = null;
        boolean bl = isMainEntity = format.isMainEntity() && !format.isEntryentity();
        if (isMainEntity) {
            templateCodeRow = ExcelUtil.getRow(sheet, rowIndex++);
        }
        SXSSFRow entityRow = ExcelUtil.getRow(sheet, rowIndex++);
        SXSSFRow commentRow = ExcelUtil.getRow(sheet, rowIndex++);
        SXSSFRow fieldDescRow = ExcelUtil.getRow(sheet, rowIndex++);
        SXSSFRow nameRow = ExcelUtil.getRow(sheet, rowIndex++);
        SXSSFRow titleRow = ExcelUtil.getRow(sheet, rowIndex++);
        String instruction = ResManager.loadKDString((String)"\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"GenImportTplHeaderWriter_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        if (isMainEntity) {
            ExcelUtil.createCell(wb, templateCodeRow, column, styles.getTplCodeRowTextStyle()).setCellValue(sheet.getSheetName());
            String name = ResManager.loadKDString((String)"\u65b0\u589e", (String)"GenImportTplHeaderWriter_1", (String)"opmc-epa-business", (Object[])new Object[0]);
            ExcelUtil.createCell(wb, templateCodeRow, format.getStartColNumber() + 1, styles.getTplCodeRowTextStyle()).setCellValue(name);
        }
        SXSSFCell commentCell = null;
        if (!format.isEntryentity()) {
            if (StringUtils.isEmpty((CharSequence)instruction)) {
                commentRow.setHidden(Boolean.valueOf(true));
                ExcelUtil.createCell(wb, commentRow, column, styles.getTextHighLightStyle()).setCellValue(ResManager.loadKDString((String)"\u6a21\u677f\u586b\u5199\u8bf4\u660e\u884c\uff0c\u8bf7\u52ff\u5220\u9664\u3002", (String)"GenImportTplHeaderWriter_2", (String)"opmc-epa-business", (Object[])new Object[0]));
            } else {
                ArrayList<String> maxLineStr = new ArrayList<String>(1);
                commentCell = GenImportTplHeaderWriter.writeComment(wb, sheet, commentRow, format, instruction, styles, headerTotalOffset, maxLineStr);
            }
        }
        if (!format.isHasFieldimportdesc() && !format.isEntryentity()) {
            fieldDescRow.setHidden(Boolean.valueOf(true));
            ExcelUtil.createCell(wb, fieldDescRow, column, styles.getTextHighLightStyle()).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u586b\u5199\u8bf4\u660e\u884c\uff0c\u8bf7\u52ff\u5220\u9664\u3002", (String)"GenImportTplHeaderWriter_3", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        if (styles.getEntityRow() == null || styles.getNameRow() == null) {
            styles.reference(entityRow, nameRow);
        }
        String entityRowText = format.getDisplayName() + " # " + entityName;
        SXSSFCell entityRowCell = ExcelUtil.createCell(wb, entityRow, column, styles.getTextStyle());
        entityRowCell.setCellValue(entityRowText);
        String caption = "";
        int titleStartCol = format.getStartColNumber() + headerTotalOffset;
        for (int i = 0; i < format.getFields().size(); ++i) {
            List dropdownValues;
            column = format.getStartColNumber() + headerTotalOffset;
            String fieldName = format.getFields().get(i);
            Map<String, Object> property = format.getProperties().get(fieldName);
            boolean mustInput = false;
            Object inputType = null;
            if (property == null) continue;
            mustInput = Boolean.TRUE.equals(property.get("MustInput"));
            inputType = property.get("InputType");
            if ("id".equals(inputType)) {
                fieldName = fieldName.replace('.', '_');
                sheet.setDefaultColumnStyle(column, styles.getTextStyle());
            } else if ("dropdownList".equals(inputType)) {
                dropdownValues = (List)property.get("DropdownValues");
                if (CollectionUtils.isNotEmpty((Collection)dropdownValues) && !"MulComboProp".equals(property.get("PropType"))) {
                    GenImportTplHeaderWriter.createDropDownSheet(sheet, dropdownSheet, format, headerTotalOffset, dropdownValues, dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d", format.getDropDownStartIndex());
                }
            } else if ("boolean".equals(inputType)) {
                dropdownValues = (List)property.get("DropdownValues");
                if (CollectionUtils.isNotEmpty((Collection)dropdownValues)) {
                    GenImportTplHeaderWriter.createDropDownSheet(sheet, dropdownSheet, format, headerTotalOffset, dropdownValues, dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d", format.getDropDownStartIndex());
                }
            } else if ("date".equals(inputType)) {
                sheet.setDefaultColumnStyle(column, styles.getDateStyle());
            } else if ("datetime".equals(inputType)) {
                sheet.setDefaultColumnStyle(column, styles.getDatetimeStyle());
            } else if ("decimal".equals(inputType)) {
                sheet.setDefaultColumnStyle(column, styles.getDecimalStyle(wb, (Map)property.get("DecimalFormat")));
            } else {
                if (ExcelUtil.multipleColumnsField(inputType).booleanValue()) {
                    headerTotalOffset = GenImportTplHeaderWriter.dealMultipleColumnsField(format, fieldName, headerTotalOffset, column, property, styles, wb, sheet, dataWriterFormat, titleRow, fieldDescRow, nameRow, dropdownSheet, currentEntityColumnCount);
                    continue;
                }
                sheet.setDefaultColumnStyle(column, styles.getTextStyle());
            }
            caption = (mustInput ? "*" : "") + ExcelUtil.getFinalFieldDisplayName(property);
            String fieldimportdesc = (String)property.get("fieldimportdesc");
            if (StringUtils.isNotBlank((CharSequence)fieldimportdesc)) {
                ExcelUtil.createCell(wb, fieldDescRow, column, styles.getFieldDescRowTextStyle()).setCellValue(fieldimportdesc);
            }
            ExcelUtil.createCell(wb, nameRow, column, styles.getTextStyle()).setCellValue(fieldName);
            HashMap<String, Object> field = new HashMap<String, Object>(Maps.newHashMapWithExpectedSize((int)3));
            field.put("PropType", property.get("PropType"));
            field.put("InputType", inputType);
            field.put("ColumnSeq", column);
            field.put("Prop", property.get("Prop"));
            field.put("imptattr", property.get("imptattr"));
            dataWriterFormat.getFields().put(fieldName, field);
            SXSSFCell cell = ExcelUtil.createCell(wb, titleRow, column, mustInput ? styles.getTitleMustInputStyle() : styles.getHeadTextStyle(entityName, fieldName));
            cell.setCellValue(caption);
            Object colWidth = property.get(COLWIDTH_KEY);
            int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
            sheet.setColumnWidth(column, ExcelUtil.calcColumnWidth(caption, designatedColWidth));
            if (property.containsKey("InputDesc")) {
                String tip = (String)property.getOrDefault("InputDesc", "");
                GenImportTplHeaderWriter.bindCellTip(sheet, cell, column, titleRow.getRowNum(), tip);
            }
            ++headerTotalOffset;
            currentEntityColumnCount.getAndIncrement();
        }
        if (currentEntityColumnCount.get() >= 2) {
            log.info("entityName=" + entityName + ",headerTotalOffset=" + headerTotalOffset + ",preOffset=" + preOffset + ",belongEntityName=" + belongEntityName);
            CellRangeAddress cellAddresses = new CellRangeAddress(entityRow.getRowNum(), entityRow.getRowNum(), entityRowCell.getColumnIndex(), entityRowCell.getColumnIndex() + 3);
            sheet.addMergedRegion(cellAddresses);
            if (commentCell != null) {
                CellRangeAddress cellAddresses2 = new CellRangeAddress(commentRow.getRowNum(), commentRow.getRowNum(), commentCell.getColumnIndex(), commentCell.getColumnIndex() + 3);
                sheet.addMergedRegion(cellAddresses2);
            }
        }
        int titleEndCol = format.getStartColNumber() + headerTotalOffset - 1;
        for (ExportHeaderWriterFormat wr : format.getNext()) {
            ExportDataWriterFormat dataWriterFormatnext = new ExportDataWriterFormat();
            dataWriterFormatnext.setEnityName(wr.getEnityName());
            dataWriterFormatnext.setMainEntity(wr.isMainEntity());
            dataWriterFormatnext.setEntryentity(wr.isEntryentity());
            wr.setDropDownStartIndex(format.getDropDownStartIndex());
            int entryOffset = GenImportTplHeaderWriter.writeHeader(wb, sheet, dropdownSheet, styles, wr, preOffset, dataWriterFormatnext, existMergeCol);
            headerTotalOffset = headerTotalOffset + entryOffset - preOffset;
            dataWriterFormat.getNext().add(dataWriterFormatnext);
        }
        return headerTotalOffset;
    }

    private static int dealMultipleColumnsField(ExportHeaderWriterFormat format, String fieldName, int headerTotalOffset, int column, Map<String, Object> property, ExportSheetStyle styles, SXSSFWorkbook wb, SXSSFSheet sheet, ExportDataWriterFormat dataWriterFormat, SXSSFRow titleRow, SXSSFRow fieldDescRow, SXSSFRow nameRow, SXSSFSheet dropdownSheet, AtomicInteger currentEntityColumnCount) {
        Object inputType = property.get("InputType");
        boolean mustInput = Boolean.TRUE.equals(property.get("MustInput"));
        String mainEntityName = format.getBelongEntityName();
        boolean needMerge = styles.isExistMergeCol(mainEntityName);
        List<String> splitCols = format.getFlexColumn().get(fieldName);
        List<String> splitColDisplayNames = format.getFlexColumnDisplay().get(fieldName);
        List<String> splitColDesc = format.getFlexColumnDesc().get(fieldName);
        int splitStartColumn = format.getStartColNumber() + headerTotalOffset;
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                Object colWidth;
                column = format.getStartColNumber() + headerTotalOffset;
                String itemKey = splitCols.get(j);
                String fieldimportdesc = (String)property.get("fieldimportdesc");
                if (StringUtils.isNotEmpty((CharSequence)fieldimportdesc)) {
                    ExcelUtil.createCell(wb, fieldDescRow, column, styles.getFieldDescRowTextStyle()).setCellValue(fieldimportdesc);
                }
                String displayName = ExcelUtil.getFinalSplitFieldDisplayName(itemKey, j, property, true, splitColDisplayNames);
                String caption = (j == 0 && mustInput ? "*" : "") + displayName;
                sheet.setDefaultColumnStyle(column, styles.getTextStyle());
                ExcelUtil.createCell(wb, nameRow, column, styles.getTextStyle()).setCellValue(itemKey);
                HashMap<String, Object> field = new HashMap<String, Object>(Maps.newHashMapWithExpectedSize((int)3));
                field.put("PropType", property.get("PropType"));
                field.put("InputType", inputType);
                field.put("ColumnSeq", column);
                field.put("Prop", property.get("Prop"));
                field.put("imptattr", property.get("imptattr"));
                dataWriterFormat.getFields().put(itemKey, field);
                SXSSFCell cell = ExcelUtil.createCell(wb, titleRow, column, styles.getHeadTextStyle(mainEntityName, fieldName));
                cell.setCellValue(caption);
                if (j < splitColDesc.size()) {
                    GenImportTplHeaderWriter.bindCellTip(sheet, cell, column, titleRow.getRowNum(), splitColDesc.get(j));
                }
                int designatedColWidth = (colWidth = property.get(COLWIDTH_KEY)) instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(column, ExcelUtil.calcColumnWidth(caption, designatedColWidth));
                Map dropdownValues = (Map)property.get("DropdownValues");
                if (!"MulBasedataProp".equals(property.get("PropType")) && dropdownValues != null && dropdownValues.size() > 0) {
                    List vals = null;
                    String[] split = itemKey.split("\\.");
                    vals = split.length == 1 ? (List)dropdownValues.get("number") : (List)dropdownValues.get(split[1]);
                    GenImportTplHeaderWriter.createDropDownSheet(sheet, dropdownSheet, format, headerTotalOffset, vals, dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d", format.getDropDownStartIndex());
                }
                ++headerTotalOffset;
                currentEntityColumnCount.getAndIncrement();
            }
        }
        return headerTotalOffset;
    }

    private static void createDropDownSheet(SXSSFSheet sheet, SXSSFSheet dropSheet, ExportHeaderWriterFormat format, int offset, List<String> inputValuesList, String formatString, int startRow) {
        if (CollectionUtils.isEmpty(inputValuesList)) {
            return;
        }
        int currCol = format.getStartColNumber() + offset;
        for (int k = 0; k < inputValuesList.size(); ++k) {
            ExcelUtil.getRow(dropSheet, k).createCell(currCol).setCellValue(inputValuesList.get(k));
        }
        String currColLabel = GenImportTplHeaderWriter.getColumnLabel(currCol + 1);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        format.getRowStartIndex();
        CellRangeAddressList addressList = new CellRangeAddressList(startRow, 10000, currCol, currCol);
        String strFormula = String.format(formatString, currColLabel, 1, currColLabel, inputValuesList.size());
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (StringUtils.isBlank((CharSequence)tip)) {
            return;
        }
        SXSSFDrawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
        comment.setString((RichTextString)new XSSFRichTextString(tip));
        cell.setCellComment(comment);
    }

    private static SXSSFCell writeComment(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow commentRow, ExportHeaderWriterFormat format, String instruction, ExportSheetStyle styles, int offset, List<String> maxLineStr) {
        if (format.getStartColNumber() + offset == 0) {
            StringBuilder tips = GenImportTplHeaderWriter.buildTips(instruction, commentRow, maxLineStr);
            CellStyle textHighLightStyle = styles.getTextHighLightStyle();
            textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
            textHighLightStyle.setWrapText(true);
            SXSSFCell cell = ExcelUtil.createCell(wb, commentRow, 0, textHighLightStyle);
            cell.setCellValue(tips.toString());
            return cell;
        }
        return null;
    }

    public static StringBuilder buildTips(String instruction, SXSSFRow commentRow, List<String> maxLineStr) {
        String[] split;
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        for (String line : split = instruction.split("\n")) {
            tips.add(line);
        }
        int radit = GenImportTplHeaderWriter.addTips(strb, tips);
        Optional maxLengthStr = tips.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return 1;
            }
            return -1;
        });
        maxLineStr.add(maxLengthStr.orElse(""));
        commentRow.setHeightInPoints((float)radit * commentRow.getSheet().getDefaultRowHeightInPoints());
        return strb;
    }

    public static int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append("\r\n");
        }
        strb.delete(strb.length() - "\r\n".length(), strb.length());
        return tips.size();
    }

    public static String getColumnLabel(int columnNo) {
        if (columnNo < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    @Deprecated
    public static int writeData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, JSONObject data, int rowIndex, ExportHeaderWriterFormat format, boolean existAttachments, String attachment, boolean fillParent) {
        SXSSFRow entityRow = styles.getEntityRow();
        SXSSFRow nameRow = styles.getNameRow();
        if (rowIndex < 4) {
            rowIndex = 4;
        }
        SXSSFRow row = ExcelUtil.getRow(sheet, rowIndex);
        int flexRowCount = 0;
        int flexColCount = 0;
        String lastFieldName = null;
        int startCol = format.getStartColNumber();
        int last = GenImportTplHeaderWriter.getLastCellNum(sheet, entityRow, startCol + 1, nameRow.getLastCellNum());
        while (startCol < last && nameRow.getCell(startCol) != null) {
            String dataKey;
            String fullName;
            String fieldName = fullName = nameRow.getCell(startCol).getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)fullName) && (fieldName = fullName.split("\\.")[0]).endsWith("_id")) {
                fieldName = fieldName.substring(0, fieldName.length() - 3) + ".id";
            }
            if (fieldName.equals(lastFieldName)) {
                ++flexColCount;
            } else {
                lastFieldName = fieldName;
                flexColCount = 0;
            }
            Map<String, Object> property = format.getProperties().get(fieldName);
            Object dataKeyObj = property.get("DataKey");
            Object inputType = property.get("InputType");
            Object dataObj = "id".equals(inputType) ? data.get((Object)"id") : data.get((Object)fieldName);
            String val = "";
            if (dataObj == null) {
                val = "";
            } else if (dataObj instanceof Boolean) {
                val = Boolean.TRUE.equals(dataObj) ? ResManager.loadKDString((String)"\u662f", (String)"GenImportTplHeaderWriter_4", (String)"opmc-epa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"GenImportTplHeaderWriter_5", (String)"opmc-epa-business", (Object[])new Object[0]);
            } else if (dataObj instanceof BigDecimal) {
                val = ((BigDecimal)dataObj).toPlainString();
            } else if (StringUtils.isBlank((Object)dataKeyObj)) {
                val = dataObj.toString();
                if (inputType instanceof JSONArray) {
                    JSONArray inputArrType = (JSONArray)inputType;
                    ArrayList<String> valDesc = new ArrayList<String>();
                    List<String> valSplit = Arrays.asList(val.split(","));
                    String propType = (String)property.get("PropType");
                    for (int i = 0; i < inputArrType.size(); ++i) {
                        Object item = inputArrType.getString(i).split(" # ", -1);
                        if (((String[])item).length <= 1 || !("MulComboProp".equals(propType) ? valSplit.contains(item[1]) : item[1].equals(val))) continue;
                        valDesc.add(item[0]);
                    }
                    if (!valDesc.isEmpty()) {
                        val = String.join((CharSequence)",", valDesc);
                    }
                }
            } else if (dataObj instanceof Map) {
                dataKey = "";
                if (dataKeyObj instanceof String) {
                    dataKey = (String)dataKeyObj;
                } else if (dataKeyObj instanceof JSONArray && ((JSONArray)dataKeyObj).size() > 0) {
                    dataKey = (String)((JSONArray)dataKeyObj).get(flexColCount);
                }
                if (dataKey.indexOf(".") >= 0) {
                    String[] dkeys = dataKey.split("\\.");
                    Object tempVal = ((Map)dataObj).get(dkeys[0]);
                    for (int i = 1; i < dkeys.length && tempVal instanceof Map; ++i) {
                        tempVal = ((Map)tempVal).get(dkeys[i]);
                    }
                    val = (String)tempVal;
                } else {
                    Object dataVal = ((Map)dataObj).get(dataKey);
                    if ("flex".equals(inputType)) {
                        HashMap flexData = (HashMap)dataObj;
                        int flexStartCol = startCol;
                        for (Map.Entry entry : flexData.entrySet()) {
                            ExcelUtil.createCell(wb, row, flexStartCol, styles.getTextStyle()).setCellValue((String)entry.getKey());
                            ++flexStartCol;
                            Object flexValue = entry.getValue();
                            if (flexValue instanceof Map) {
                                Map flexMap = (Map)flexValue;
                                ExcelUtil.createCell(wb, row, flexStartCol, styles.getTextStyle()).setCellValue(flexMap.get("number") == null ? "" : flexMap.get("number").toString());
                                ExcelUtil.createCell(wb, row, ++flexStartCol, styles.getTextStyle()).setCellValue(flexMap.get("name") == null ? "" : flexMap.get("name").toString());
                                ++flexStartCol;
                                continue;
                            }
                            ExcelUtil.createCell(wb, row, ++flexStartCol, styles.getTextStyle()).setCellValue((String)entry.getKey());
                            ++flexStartCol;
                        }
                        startCol += 24;
                        continue;
                    }
                    if ("multilang".equals(inputType)) {
                        dataVal = ((Map)dataObj).get(fullName.split("\\.")[1]);
                    }
                    val = dataVal == null ? "" : "" + dataVal;
                }
            } else if (dataObj instanceof List && dataObj != null && !((List)dataObj).isEmpty()) {
                dataKey = "";
                if (dataKeyObj instanceof String) {
                    dataKey = (String)dataKeyObj;
                } else if (dataKeyObj instanceof JSONArray && ((JSONArray)dataKeyObj).size() > 1) {
                    dataKey = fullName.endsWith(".name") ? ((JSONArray)dataKeyObj).getString(1) : ((JSONArray)dataKeyObj).getString(0);
                }
                List listData = (List)dataObj;
                String[] subKeys = dataKey.split("\\.");
                StringBuilder buf = new StringBuilder(StringUtils.isEmpty((CharSequence)val) ? "" : val);
                for (Object item : listData) {
                    buf.append(',');
                    buf.append(item instanceof Map ? GenImportTplHeaderWriter.get((Map)item, subKeys) : item);
                }
                val = buf.toString();
                if (val.startsWith(",")) {
                    val = val.substring(1);
                }
            }
            if ("time".equals(inputType)) {
                ExcelUtil.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(GenImportTplHeaderWriter.formatTimeStr((Integer)dataObj));
            } else if ("date".equals(inputType)) {
                ExcelUtil.createCell(wb, row, startCol, styles.getDateStyle()).setCellValue((String)dataObj);
            } else if ("datetime".equals(inputType)) {
                ExcelUtil.createCell(wb, row, startCol, styles.getDatetimeStyle()).setCellValue((String)dataObj);
            } else if ("decimal".equals(inputType)) {
                log.info("--------dataObj:" + JSON.toJSONString((Object)dataObj));
                BigDecimal decimal = null;
                JSONObject dataMap = null;
                if (dataObj instanceof Map) {
                    dataMap = (JSONObject)JSONObject.toJSON((Object)dataObj);
                    decimal = new BigDecimal(dataMap.getOrDefault((Object)RESULT, (Object)0).toString());
                } else if (StringUtils.isNotBlank((Object)dataObj)) {
                    decimal = new BigDecimal(dataObj.toString());
                }
                if (decimal != null && GenImportTplHeaderWriter.isBigDecimal(decimal.toPlainString())) {
                    ExcelUtil.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(decimal.toPlainString());
                } else if (decimal != null) {
                    ExcelUtil.createCell(wb, row, startCol, styles.getDecimalStyle(wb, (Map<String, Object>)dataMap)).setCellValue(decimal.doubleValue());
                }
            } else {
                ExcelUtil.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(val);
            }
            ++startCol;
        }
        if (existAttachments && StringUtils.isNotBlank((CharSequence)attachment)) {
            SXSSFCell cell = ExcelUtil.createCell(wb, row, nameRow.getLastCellNum() + 1, styles.getTextStyle());
            String zip_attach_url = attachment.concat(ResManager.loadKDString((String)"_\u9644\u4ef6/pk-", (String)"GenImportTplHeaderWriter_6", (String)"opmc-epa-business", (Object[])new Object[0])).concat(data.getString("id"));
            cell.setCellValue(zip_attach_url);
            XSSFHyperlink link = (XSSFHyperlink)wb.getCreationHelper().createHyperlink(HyperlinkType.FILE);
            link.setAddress(zip_attach_url);
            cell.setHyperlink((Hyperlink)link);
            GenImportTplHeaderWriter.bindCellTip(sheet, cell, nameRow.getLastCellNum() + 1, rowIndex, ResManager.loadKDString((String)"\u9884\u89c8\u65f6\u8bf7\u5c06\u9644\u4ef6\u538b\u7f29\u5305\u89e3\u538b\u4e3a\u5f53\u524d\u76ee\u5f55\u4e0b\u7684\u540c\u540d\u6587\u4ef6\u5939", (String)"GenImportTplHeaderWriter_7", (String)"opmc-epa-business", (Object[])new Object[0]));
            cell.setCellStyle(styles.getHlinkStyle());
        }
        int maxOffset = 0;
        for (ExportHeaderWriterFormat wr : format.getNext()) {
            String entityName = entityRow.getCell(wr.getStartColNumber()).getStringCellValue();
            if (entityName != null) {
                entityName = entityName.split(" # ")[1];
            }
            if (!data.containsKey((Object)entityName)) continue;
            JSONArray subData = data.getJSONArray(entityName);
            int offset = 0;
            for (int i = 0; i < subData.size(); ++i) {
                int subOffset = GenImportTplHeaderWriter.writeData(wb, sheet, styles, subData.getJSONObject(i), rowIndex + offset, wr, false, null, fillParent);
                if (subOffset == 0) {
                    ++offset;
                    continue;
                }
                offset += subOffset;
            }
            if (maxOffset >= offset) continue;
            maxOffset = offset;
        }
        int rowCount = Math.max(flexRowCount, maxOffset);
        if (fillParent) {
            for (int i = 1; i < rowCount; ++i) {
                GenImportTplHeaderWriter.fillRow(wb, sheet, styles, format, nameRow, row, ExcelUtil.getRow(sheet, rowIndex + i));
            }
        }
        return rowCount;
    }

    public static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static void fillRow(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportHeaderWriterFormat format, SXSSFRow nameRow, SXSSFRow row, SXSSFRow nextRow) {
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int startCol = format.getStartColNumber();
        int last = GenImportTplHeaderWriter.getLastCellNum(sheet, styles.getEntityRow(), startCol + 1, nameRow.getLastCellNum());
        while (startCol < last) {
            SXSSFCell oldCell = row.getCell(startCol);
            if (oldCell == null) continue;
            SXSSFCell newCell = ExcelUtil.createCell(wb, nextRow, startCol, oldCell.getCellStyle());
            if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.STRING)) {
                newCell.setCellValue(oldCell.getStringCellValue());
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.NUMERIC)) {
                if (DateUtil.isCellDateFormatted((Cell)oldCell)) {
                    Date dt = DateUtil.getJavaDate((double)oldCell.getNumericCellValue());
                    newCell.setCellValue(sFormat.format(dt));
                } else {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                }
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.BOOLEAN)) {
                newCell.setCellValue(oldCell.getBooleanCellValue());
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.FORMULA)) {
                newCell.setCellValue(oldCell.getCellFormula());
            }
            ++startCol;
        }
    }

    public static Object get(Map<String, Object> map, String[] keys) {
        Map tempMap = map;
        for (int i = 0; i < keys.length - 1; ++i) {
            tempMap = (Map)tempMap.get(keys[i]);
        }
        return tempMap.get(keys[keys.length - 1]);
    }

    public static int getLastCellNum(SXSSFSheet sheet, SXSSFRow entityRow, int col, short last) {
        while (col < last) {
            String nextEntityName;
            SXSSFCell cell = entityRow.getCell(col);
            String string = nextEntityName = cell == null ? null : cell.getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)nextEntityName)) {
                return col;
            }
            ++col;
        }
        return last;
    }

    public static boolean isBigDecimal(String decimalStr) {
        int i = decimalStr.lastIndexOf(46);
        int j = decimalStr.length();
        if (i >= 0) {
            --j;
            while (j > i && decimalStr.charAt(j) == '0') {
                --j;
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }
}

