/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.opmc.epa.business.domain.indicator.imp.DataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.ValidateDataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.constant.ImportCacheKeyType;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportFileUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndDataValidateManager;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndMonitor;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndProgresser;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndReporter;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTempStoreDispatcher;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTerminator;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTimeRemainingAnalyser;

public class IndImportStart {
    private static Log log = LogFactory.getLog(IndImportStart.class);
    public Object syncLock = new Object();
    private ImportContext importContext;
    private ThreadPool pool;
    private Map<String, IndImportWorker> workers;
    private ImportQueue<ImportBillData> paserQueue = new ImportQueue("paserQueue", new LinkedBlockingQueue(3000), this);
    private ImportQueue<ImportBillData> tempStoreQueue = new ImportQueue("tempStoreQueue", new LinkedBlockingQueue(3000), this);
    private ImportQueue<ImportBillData> waitInStoreQueue = new ImportQueue("waitInStoreQueue", new LinkedBlockingQueue(3000), this);
    private volatile boolean isStoped = false;
    private volatile boolean isMainThreadInterrupt = false;

    public IndImportStart(ImportContext importContext) {
        this.pool = ThreadPools.newCachedThreadPool((String)(IndImportStart.class.getSimpleName() + RequestContext.get().getTraceId()), (int)6, (int)15);
        this.importContext = importContext;
        this.workers = Maps.newHashMapWithExpectedSize((int)10);
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public Map<String, IndImportWorker> getWorkers() {
        return this.workers;
    }

    public boolean isMainThreadInterrupt() {
        return this.isMainThreadInterrupt;
    }

    public void setMainThreadInterrupt(boolean mainThreadInterrupt) {
        this.isMainThreadInterrupt = mainThreadInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        log.info("ImportStart_start.");
        this.initImportStatus();
        IndProgresser progresser = new IndProgresser(this);
        int validateWorkerMaxThread = ValidateDataFlowSuggester.getWorkerMaxThread(this);
        ImportQueue<ImportBillData> validaOutQueue = this.importContext.isSerialModel() || this.importContext.isNeedRelationInStoreForMEMS() ? this.getTempStoreQueue() : this.getWaitInStoreQueue();
        IndDataValidateManager dataValidateManager = new IndDataValidateManager(this, validaOutQueue, validateWorkerMaxThread);
        int opWorkerMaxThread = DataFlowSuggester.getWorkerMaxThread(this);
        IndSaveOpDispatcher saveOpDispatcher = new IndSaveOpDispatcher(this, opWorkerMaxThread);
        saveOpDispatcher.getEntityBlankDynamicObjectSemaphore().acquire();
        IndTimeRemainingAnalyser timeRemainingAnalyser = new IndTimeRemainingAnalyser(this);
        this.workers.put(progresser.getName(), progresser);
        this.workers.put(dataValidateManager.getName(), dataValidateManager);
        this.workers.put(saveOpDispatcher.getName(), saveOpDispatcher);
        this.workers.put(timeRemainingAnalyser.getName(), timeRemainingAnalyser);
        this.pool.submit((Callable)this.getMonitor());
        this.pool.submit((Callable)progresser);
        this.pool.submit((Callable)this.workers.get(IndParser.class.getSimpleName()));
        this.pool.submit((Callable)dataValidateManager);
        this.pool.submit((Callable)saveOpDispatcher);
        this.pool.submit((Callable)timeRemainingAnalyser);
        if (this.importContext.isSerialModel() || this.importContext.isNeedRelationInStoreForMEMS()) {
            IndTempStoreDispatcher storeDispatcher = new IndTempStoreDispatcher(this);
            this.pool.submit((Callable)storeDispatcher);
            this.workers.put(storeDispatcher.getName(), storeDispatcher);
        }
        log.info("ImportStart_started.");
        Object object = this.syncLock;
        synchronized (object) {
            this.syncLock.wait();
        }
        if (this.importContext.isSerialModel() && this.importContext.getSuccessedValidateBillCount().get() < this.importContext.getTotalBillCount()) {
            this.end(true);
        } else if (this.importContext.getSuccessedBillCount().get() < this.importContext.getTotalBillCount()) {
            this.end(true);
        } else {
            this.end(false);
        }
    }

    public void end(boolean needReport) {
        if (needReport) {
            IndReporter reporter = new IndReporter(this);
            this.workers.put(reporter.getName(), reporter);
            this.pool.submit((Callable)new IndReporter(this));
        } else {
            try {
                ImportFileUtil.deleteLocalTempFile(this.importContext.getFileLocalPath());
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.isStoped = true;
        this.pool.close();
        log.info("ImportStart_normally_finished!");
    }

    private void initImportStatus() throws Exception {
        IHRAppCache cache = HRAppCache.get((String)"epa");
        cache.put(MethodUtil.getTaskCachePath(String.valueOf(this.importContext.getTaskPkId()), ImportCacheKeyType.IMPORT, "status"), (Object)"run");
        IndTerminator terminator = new IndTerminator(this);
        this.pool.submit((Callable)terminator);
        this.workers.put(terminator.getName(), terminator);
    }

    public void writeRowErrorLog(ImportRowErrorLog errorLog) {
        this.getImportContext().getImportLog().writeRowLog(errorLog);
    }

    public synchronized void writeErrorLog(Throwable throwable) {
        try {
            boolean userHasTerminator = this.importContext.isUserHasTerminator();
            if (userHasTerminator) {
                return;
            }
            List<String> errorLogs = this.getImportContext().getImportLog().getErrorLogs();
            if (errorLogs.size() > 5) {
                return;
            }
            String errorLog = CommonUtil.formatException(throwable);
            this.getImportContext().getImportLog().getErrorLogs().add(errorLog);
        }
        catch (Throwable e) {
            log.error("ImportStart_writeErrorLog.", e);
        }
    }

    public IndMonitor getMonitor() {
        return (IndMonitor)this.workers.get(IndMonitor.class.getSimpleName());
    }

    public ImportQueue<ImportBillData> getPaserQueue() {
        return this.paserQueue;
    }

    public void setPaserQueue(ImportQueue<ImportBillData> paserQueue) {
        this.paserQueue = paserQueue;
    }

    public ImportQueue<ImportBillData> getTempStoreQueue() {
        return this.tempStoreQueue;
    }

    public void setTempStoreQueue(ImportQueue<ImportBillData> tempStoreQueue) {
        this.tempStoreQueue = tempStoreQueue;
    }

    public ImportQueue<ImportBillData> getWaitInStoreQueue() {
        return this.waitInStoreQueue;
    }

    public void setWaitInStoreQueue(ImportQueue<ImportBillData> waitInStoreQueue) {
        this.waitInStoreQueue = waitInStoreQueue;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    public void setStoped(boolean stoped) {
        this.isStoped = stoped;
    }
}

