/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.opmc.epa.business.domain.indicator.imp.TaskService;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.Result;
import kd.opmc.epa.business.domain.indicator.imp.task.BigExcelImportTask;

public class IndImportTaskDispatcher {
    private static final Log log = LogFactory.getLog(IndImportTaskDispatcher.class);
    private static volatile IndImportTaskDispatcher instance;
    protected AtomicInteger childThreadMonitor;
    protected Semaphore childThreadSemaphore;
    private static ThreadPool pool;

    private IndImportTaskDispatcher() {
        pool = ThreadPools.newCachedThreadPool((String)(IndImportTaskDispatcher.class.getSimpleName() + RequestContext.get().getTraceId()), (int)0, (int)MCConfigConstant.getTaskDispatcherMaxThread());
        this.childThreadMonitor = new AtomicInteger(0);
        this.childThreadSemaphore = new Semaphore(MCConfigConstant.getTaskDispatcherMaxThread());
        log.info("MCConfigConstant:" + JSONObject.toJSONString(MCConfigConstant.getAllConfigInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndImportTaskDispatcher getInstance() {
        if (instance != null) return instance;
        Class<IndImportTaskDispatcher> clazz = IndImportTaskDispatcher.class;
        synchronized (IndImportTaskDispatcher.class) {
            if (instance != null) return instance;
            instance = new IndImportTaskDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Semaphore getChildThreadSemaphore() {
        return this.childThreadSemaphore;
    }

    public Result receivedNewTask(Map<String, Object> params) {
        Result result = new Result();
        long taskPKId = TaskService.createTask(params);
        result.setSuccess(true);
        result.setData(taskPKId);
        params.put("taskPkId", taskPKId);
        params.put("isRecoveryTask", false);
        BigExcelImportTask task = new BigExcelImportTask(params, this, this.childThreadMonitor);
        boolean ret = this.submitWithTimeOut(task);
        if (!ret) {
            result.setSuccess(false);
            result.setCode("900");
        }
        return result;
    }

    protected boolean submitWithTimeOut(Callable<Object> task) {
        try {
            if (this.childThreadSemaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                pool.submit(task);
                return true;
            }
            throw new KDException(new ErrorCode("900", "waiteHasFreePoolThread_timeout."), new Object[0]);
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }
}

