/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DecimalProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.constant.IndConstant;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SheetHandler
extends DefaultHandler {
    private static final Log LOGGER = LogFactory.getLog(SheetHandler.class);
    private static final int DATE_FORMAT_INDEX28 = 28;
    private static final int DATE_FORMAT_INDEX31 = 31;
    private static final Pattern UpperCacePattern = Pattern.compile("[A-Z]");
    private static final Pattern IntPattern = Pattern.compile("[0-9]");
    private static final Pattern NotPrintCharPattern = Pattern.compile("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]");
    protected final int ERR_ROW_MAX_SIZE = 4000;
    protected final int MAX_COL_COUNT = 16383;
    private final DataFormatter formatter = new DataFormatter();
    private final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected List<String> effectSheetNames = new LinkedList<String>();
    protected List<String> allSheetNames = new LinkedList<String>();
    protected ParsedRow currentRow;
    protected boolean hasErrorRow = false;
    private SharedStringsTable sst;
    private StylesTable stylesTable;
    private short formatIndex;
    private String formatString;
    private String lastContents;
    private XSSFDataType nextDataType = XSSFDataType.NUMBER;
    private Integer index;
    private ParsedRow rowHolder;
    private ParsedCol colHolder;
    private Set<CellValidation> dataValidations = new HashSet<CellValidation>();
    private Map<String, CommentsTable> sheetComments;
    private CellValidation currentValidation;
    private int rowCount;
    private int colCount;
    private String currentSheetName;
    private int lastRowIndex = 0;
    private boolean interrupt = false;
    private Map<String, List<String>> sheetNames2MergeCells = new HashMap<String, List<String>>();
    private Set<Integer> rowGetSet = new HashSet<Integer>(16);

    protected SheetHandler() {
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public int getColCount() {
        return this.colCount;
    }

    public Map<String, List<String>> getMergeCellList() {
        return this.sheetNames2MergeCells;
    }

    protected boolean isSkipEmptyRow() {
        return true;
    }

    public void addSheetComments(String sheetName, CommentsTable comments) {
        if (this.sheetComments == null) {
            this.sheetComments = new HashMap<String, CommentsTable>();
        }
        this.sheetComments.put(sheetName, comments);
    }

    public Map<String, CommentsTable> getSheetComments() {
        return this.sheetComments;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("dimension".equals(name)) {
            String refdata = attributes.getValue("ref");
            String rowCountStr = refdata.substring(refdata.indexOf(":") + 1).toUpperCase();
            int sheetCountRow = Integer.parseInt(UpperCacePattern.matcher(rowCountStr).replaceAll(""));
            this.rowGetSet = new HashSet<Integer>(sheetCountRow);
            LOGGER.info("rowGetSet_start_int_new_sheet,sheetName=" + this.currentSheetName);
            this.rowCount += sheetCountRow;
            this.colCount = CommonUtil.excelNum2Digit(IntPattern.matcher(rowCountStr).replaceAll(""));
        }
        if (name.equals("row")) {
            int curRowIndex = Integer.parseInt(attributes.getValue("r")) - 1;
            for (int gap = curRowIndex - this.lastRowIndex; gap > 1 && !this.isSkipEmptyRow(); --gap) {
                ParsedRow parsedRow = new ParsedRow();
                parsedRow.setRowNum(this.lastRowIndex + gap - 1);
                this.handleRow(parsedRow);
            }
            boolean hideRow = "1".equals(attributes.getValue("hidden"));
            this.getRowHolder().setHideRow(hideRow);
            this.getRowHolder().setRowNum(curRowIndex);
            this.lastRowIndex = curRowIndex;
        } else if ("col".equalsIgnoreCase(name)) {
            String width = attributes.getValue("width");
            String colNumMinStr = attributes.getValue("min");
            String colNumMaxStr = attributes.getValue("max");
            if (NumberUtils.isParsable((String)width) && NumberUtils.isParsable((String)colNumMinStr) && NumberUtils.isParsable((String)colNumMaxStr)) {
                int colNumMin = Integer.parseInt(colNumMinStr);
                int colNumMax = Integer.parseInt(colNumMaxStr);
                for (int i = colNumMin; i <= colNumMax; ++i) {
                    HashMap<String, String> colProperty = new HashMap<String, String>();
                    colProperty.put("colWidth", width);
                    colProperty.put("style", attributes.getValue("style"));
                    this.getColHolder().getColProperty().put(i, colProperty);
                }
            }
        } else if (name.equals("c")) {
            String cellType;
            String coordinate = attributes.getValue("r");
            CellReference cellReference = new CellReference(coordinate);
            this.index = cellReference.getCol();
            this.nextDataType = XSSFDataType.NUMBER;
            this.formatIndex = (short)-1;
            this.formatString = null;
            String cellStyleStr = attributes.getValue("s");
            if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                this.getRowHolder().addCellStyles(this.index, styleIndex);
                this.formatIndex = style.getDataFormat();
                this.formatString = style.getDataFormatString();
                if (this.formatString == null) {
                    this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                }
            }
            if ("b".equals(cellType = attributes.getValue("t"))) {
                this.nextDataType = XSSFDataType.BOOL;
            } else if ("e".equals(cellType)) {
                this.nextDataType = XSSFDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = XSSFDataType.INLINESTR;
            } else if ("s".equals(cellType)) {
                this.nextDataType = XSSFDataType.SSTINDEX;
            } else if ("str".equals(cellType)) {
                this.nextDataType = XSSFDataType.FORMULA;
            }
        } else if (!"x14:dataValidation".equalsIgnoreCase(name) && "mergeCell".equalsIgnoreCase(name)) {
            List orDefault = this.getMergeCellList().getOrDefault(this.currentSheetName, new ArrayList());
            orDefault.add(attributes.getValue("ref"));
            this.getMergeCellList().put(this.currentSheetName, orDefault);
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("xm:f".equalsIgnoreCase(name)) {
            if (this.currentValidation != null) {
                this.currentValidation.setValidation(this.lastContents);
            }
        } else if ("x14:dataValidation".equalsIgnoreCase(name)) {
            if (this.currentValidation != null) {
                this.currentValidation.setRange(this.lastContents);
                this.dataValidations.add(this.currentValidation);
                this.currentValidation = null;
            }
        } else if (name.equals("c")) {
            switch (this.nextDataType) {
                case BOOL: {
                    char first = this.lastContents.charAt(0);
                    this.lastContents = first == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    this.lastContents = "\"ERROR:" + this.lastContents + '\"';
                    break;
                }
                case FORMULA: {
                    break;
                }
                case INLINESTR: {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.lastContents);
                    this.lastContents = rtsi.toString();
                    break;
                }
                case SSTINDEX: {
                    String sstIndex = this.lastContents;
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        RichTextString richTextString = this.sst.getItemAt(idx);
                        String string = richTextString.getString();
                        this.lastContents = string == null ? "" : string;
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.error("Failed to parse SST index '" + sstIndex + "': " + ex.toString());
                    }
                    break;
                }
                case NUMBER: {
                    boolean isADateFormat;
                    if (!StringUtils.isNotBlank((CharSequence)this.lastContents)) break;
                    double n = Double.parseDouble(this.lastContents);
                    try {
                        isADateFormat = DateUtil.isADateFormat((int)this.formatIndex, (String)this.formatString);
                    }
                    catch (Throwable e) {
                        LOGGER.info("this.formatIndex" + this.formatIndex + "-this.formatString:" + this.formatString);
                        LOGGER.error(e);
                        throw e;
                    }
                    if (isADateFormat || 31 == this.formatIndex || 28 == this.formatIndex) {
                        Date date = DateUtil.getJavaDate((double)n);
                        this.lastContents = this.datetimeFormat.format(date);
                        if (!StringUtils.equals((CharSequence)"yyyy\\-mm\\-dd", (CharSequence)this.formatString)) break;
                        this.lastContents = new SimpleDateFormat("yyyy-MM-dd").format(date);
                        break;
                    }
                    if (this.formatIndex >= 0 && StringUtils.isNotBlank((CharSequence)this.formatString)) {
                        boolean isNegative;
                        this.lastContents = IndConstant.SpecCharPattern.matcher(this.formatter.formatRawCellContents(n, (int)this.formatIndex, this.formatString)).replaceAll("");
                        if (this.lastContents != null && this.lastContents.endsWith("%")) {
                            this.lastContents = DecimalProp.percentToDoubleString((String)this.lastContents);
                        }
                        boolean bl = isNegative = n < 0.0;
                        if (this.lastContents != null) {
                            n = Double.parseDouble(this.lastContents);
                        }
                        if (isNegative && n >= 0.0) {
                            n = -n;
                        }
                    }
                    this.lastContents = new BigDecimal(Double.toString(n)).stripTrailingZeros().toPlainString();
                    break;
                }
                default: {
                    this.lastContents = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            this.lastContents = NotPrintCharPattern.matcher(this.lastContents).replaceAll("").trim();
            if (this.lastContents.isEmpty()) {
                return;
            }
            this.getRowHolder().getData().put(this.index, this.lastContents);
        } else if (name.equals("row")) {
            this.handleRow(this.getRowHolder());
            this.setRowHolder(new ParsedRow());
        }
    }

    public abstract void handleRow(ParsedRow var1);

    public void handleDataValidation(Set<CellValidation> dataValidations) {
    }

    public void handleSheetComments(Map<String, CommentsTable> sheetComments) {
    }

    protected void handleSheetComments(SXSSFWorkbook workBook, Map<String, SXSSFRow> nameRowsMap, int rowNum) {
        Map<String, CommentsTable> comments = this.getSheetComments();
        if (comments != null && !comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = workBook.getSheet(sheetName);
                SXSSFRow row = nameRowsMap.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing sxssfDrawing = sheet.createDrawingPatriarch();
                CommentsTable commentsTable = entry.getValue();
                Iterator cellAddresses = commentsTable.getCellAddresses();
                while (cellAddresses.hasNext()) {
                    XSSFComment comment;
                    CellAddress addr = (CellAddress)cellAddresses.next();
                    SXSSFCell cell = row.getCell(this.countIndex(addr.getColumn()));
                    if (cell == null || (comment = commentsTable.findCellComment(addr)).getRow() != rowNum) continue;
                    Comment temp = sxssfDrawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)this.countIndex(comment.getColumn())), rowNum, (short)this.countIndex(comment.getColumn()) + 2, rowNum + 2));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
        }
    }

    protected Map<Integer, Set<Integer>> getIntegerSetMap(Map<Integer, String> rowData) {
        HashMap<Integer, Set<Integer>> int2Range = new HashMap<Integer, Set<Integer>>(rowData.size());
        Object[] integers = rowData.keySet().toArray(new Integer[0]);
        Arrays.sort(integers);
        for (int index = 0; index < integers.length; ++index) {
            int end = index + 1 < integers.length ? ((Integer)integers[index + 1]).intValue() : this.getColCount();
            HashSet<Integer> range = new HashSet<Integer>(rowData.size());
            for (int count = ((Integer)integers[index]).intValue(); count < end; ++count) {
                range.add(count);
            }
            int2Range.put((Integer)integers[index], range);
        }
        return int2Range;
    }

    protected void initBook(SXSSFWorkbook workbook, Map<String, SXSSFSheet> sheetsMap, Map<Integer, CellStyle> stylesMap, ParsedRow parsedRow, boolean isAllData) {
        SXSSFSheet sxssfSheet = sheetsMap.get(this.getCurrentSheetName());
        if (sxssfSheet == null) {
            sxssfSheet = workbook.createSheet(this.getCurrentSheetName());
            sheetsMap.put(this.getCurrentSheetName(), sxssfSheet);
        }
        this.currentRow = parsedRow;
        int currRowNum = this.currentRow.getRowNum();
        if (this.effectSheetNames.contains(this.getCurrentSheetName())) {
            if (parsedRow.getData() != null && parsedRow.getData().size() != 0) {
                this.handleSheet(parsedRow, workbook, sxssfSheet, stylesMap, isAllData);
            }
        } else if (this.getCurrentSheetName().endsWith("DDM")) {
            this.handleIgnoreSheet(sxssfSheet, currRowNum);
        } else {
            this.handleNormallySheet(workbook, sxssfSheet, currRowNum, stylesMap, parsedRow.getStyles());
        }
    }

    protected void handleIgnoreSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(entry.getKey().intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue(entry.getValue());
        }
    }

    protected void handleNormallySheet(SXSSFWorkbook workbook, SXSSFSheet sheet, int currRowNum, Map<Integer, CellStyle> stylesMap, Map<Integer, Integer> cellStyles) {
        this.handleNormallyColStyle(workbook, sheet, stylesMap);
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(entry.getKey().intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue(entry.getValue());
            Integer styleIndex = cellStyles.get(entry.getKey());
            cell.setCellStyle(this.getCellStyleByStyleIndex(workbook, stylesMap, styleIndex));
        }
    }

    protected SXSSFRow getRow(SXSSFSheet sheet, int rowNum) {
        SXSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            if (this.rowGetSet.contains(rowNum)) {
                LOGGER.error("SheetHandler.getRow_hasRepeat,rowNum=" + rowNum + ",sheetName=" + this.currentSheetName);
            }
            row = sheet.createRow(rowNum);
            this.rowGetSet.add(rowNum);
        }
        return row;
    }

    public void handleSheet(ParsedRow parsedRow, SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, boolean isAllData) {
    }

    protected void handleCorrectRow(ParsedRow parsedRow, SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, int currRowNum) {
        Map<Integer, Integer> cellStyles = parsedRow.getStyles();
        for (Map.Entry<Integer, String> entry : parsedRow.getData().entrySet()) {
            Integer columnNum = entry.getKey();
            if (columnNum >= 16383) continue;
            this.putRowData(workbook, sxssfSheet, stylesMap, currRowNum, entry, cellStyles);
        }
    }

    private void putRowData(SXSSFWorkbook workbook, SXSSFSheet sheet, Map<Integer, CellStyle> stylesMap, int currRowNum, Map.Entry<Integer, String> entry, Map<Integer, Integer> cellStyles) {
        int cellIndex = this.countIndex(entry.getKey());
        if (this.hasErrorRow && cellIndex == 0) {
            return;
        }
        SXSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellValue(entry.getValue());
        Integer styleIndex = cellStyles.get(entry.getKey());
        sxssfCell.setCellStyle(this.getCellStyleByStyleIndex(workbook, stylesMap, styleIndex));
    }

    protected CellStyle getCellStyleByStyleIndex(SXSSFWorkbook workbook, Map<Integer, CellStyle> stylesMap, Integer styleIndex) {
        CellStyle cellStyle = stylesMap.get(styleIndex);
        if (cellStyle == null && styleIndex != null && this.getStylesTable() != null && this.getStylesTable().getStyleAt(styleIndex.intValue()) != null) {
            cellStyle = workbook.createCellStyle();
            cellStyle.cloneStyleFrom((CellStyle)this.getStylesTable().getStyleAt(styleIndex.intValue()));
            stylesMap.put(styleIndex, cellStyle);
        }
        return cellStyle;
    }

    protected void handleDataColStyle(SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap, Boolean hasErrorRow) {
        int offset = 0;
        if (hasErrorRow.booleanValue()) {
            --offset;
        }
        int finalOffset = offset;
        this.getColHolder().getColProperty().forEach((key, value) -> {
            if (value.get("style") != null) {
                sxssfSheet.setDefaultColumnStyle(key + finalOffset, this.getCellStyleByStyleIndex(workbook, stylesMap, Integer.parseInt((String)value.get("style"))));
            }
            if (value.get("colWidth") != null && NumberUtils.isParsable((String)String.valueOf(value.get("colWidth")))) {
                double colWidth = Double.parseDouble(String.valueOf(value.get("colWidth")));
                sxssfSheet.setColumnWidth(key + finalOffset, (int)(colWidth * 8.0 * 32.0));
            }
        });
    }

    protected void handleNormallyColStyle(SXSSFWorkbook workbook, SXSSFSheet sxssfSheet, Map<Integer, CellStyle> stylesMap) {
        this.getColHolder().getColProperty().forEach((key, value) -> {
            int colIndex = key - 1;
            if (value.get("style") != null) {
                sxssfSheet.setDefaultColumnStyle(colIndex, this.getCellStyleByStyleIndex(workbook, stylesMap, Integer.parseInt((String)value.get("style"))));
            }
            if (value.get("colWidth") != null && NumberUtils.isParsable((String)String.valueOf(value.get("colWidth")))) {
                double colWidth = Double.parseDouble(String.valueOf(value.get("colWidth")));
                sxssfSheet.setColumnWidth(colIndex, (int)(colWidth * 8.0 * 32.0));
            }
        });
    }

    protected int countIndex(int index) {
        if (this.hasErrorRow) {
            return index;
        }
        return ++index;
    }

    protected void handleValidations(Set<CellValidation> cellValidations, Map<String, SXSSFSheet> sheets) {
        for (CellValidation validation : cellValidations) {
            String[] rangeStrs;
            SXSSFSheet sheet = sheets.get(validation.getSheetName());
            DataValidationHelper helper = sheet.getDataValidationHelper();
            String refValidation = validation.getValidation();
            if (refValidation == null || (rangeStrs = validation.getRange().toUpperCase().split(" ")).length <= 0) continue;
            for (String rg : rangeStrs) {
                List<Integer> ranges = this.splitRange(rg.split(":"));
                int rangeSize = ranges.size();
                CellRangeAddressList addressList = null;
                if (ranges.contains(-1)) continue;
                if (rangeSize == 2) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(1) - 1, ranges.get(0).intValue(), Math.min(16383, ranges.get(0)));
                } else if (rangeSize == 4) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(3) - 1, ranges.get(0).intValue(), Math.min(16383, ranges.get(2)));
                }
                if (addressList == null) continue;
                DataValidation dataValidation = helper.createValidation(helper.createFormulaListConstraint(validation.getValidation()), addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                sheet.addValidationData(dataValidation);
            }
        }
    }

    protected void handleMergeCells(SXSSFSheet sxssfSheet, List<String> mergeCellList, Boolean isHasErrorCol, boolean currentSheetNeedErrorColum) {
        if (mergeCellList == null || mergeCellList.size() == 0) {
            return;
        }
        for (String mergeCell : mergeCellList) {
            CellRangeAddress cellAddresses = CellRangeAddress.valueOf((String)mergeCell);
            if (!isHasErrorCol.booleanValue() && currentSheetNeedErrorColum) {
                cellAddresses.setFirstColumn(cellAddresses.getFirstColumn() + 1);
                cellAddresses.setLastColumn(cellAddresses.getLastColumn() + 1);
            }
            sxssfSheet.addMergedRegion(cellAddresses);
        }
    }

    private List<Integer> splitRange(String[] subRanges) {
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        try {
            for (String subRange : subRanges) {
                char c;
                int k;
                int j = 0;
                int len = subRange.length();
                for (k = 1; k < len && (c = subRange.charAt(k)) >= 'A' && c <= 'Z'; ++k) {
                }
                ranges.add(this.CharsToNumber(subRange.substring(j, k)));
                ranges.add(Integer.parseInt(subRange.substring(k)));
            }
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
        return ranges;
    }

    private int CharsToNumber(String letter) {
        if (letter == null || letter.isEmpty()) {
            return -1;
        }
        String upperLetter = letter.toUpperCase();
        if (!upperLetter.matches("[A-Z]+")) {
            return -1;
        }
        long num = 0L;
        long base = 1L;
        for (int i = upperLetter.length() - 1; i >= 0; --i) {
            char ch = upperLetter.charAt(i);
            if ((num += (long)(ch - 65 + this.countIndex(0)) * (base *= 26L)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)num;
    }

    protected SXSSFCell getCell(SXSSFRow row) {
        return row.getCell(0) != null ? row.getCell(0) : row.createCell(0);
    }

    protected void ignoreSheet(SXSSFWorkbook workbook) {
        HashSet ddlSheetIndex = new HashSet();
        workbook.forEach(sheet -> {
            if (sheet.getSheetName().endsWith("DDM")) {
                ddlSheetIndex.add(workbook.getSheetIndex(sheet.getSheetName()));
            }
        });
        ddlSheetIndex.forEach(index -> workbook.setSheetHidden(index.intValue(), true));
        ddlSheetIndex.clear();
    }

    protected void initStylesMap(SXSSFWorkbook sxssfWorkbook, Map<Integer, CellStyle> stylesMap) {
        CellStyle redCellStyle = sxssfWorkbook.createCellStyle();
        Font redFont = sxssfWorkbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        redCellStyle.setFont(redFont);
        stylesMap.put(-1, redCellStyle);
        CellStyle greenCellStyle = sxssfWorkbook.createCellStyle();
        Font font = sxssfWorkbook.createFont();
        font.setColor(IndexedColors.GREEN.getIndex());
        greenCellStyle.setFont(font);
        stylesMap.put(-2, greenCellStyle);
    }

    @Override
    public void endDocument() throws SAXException {
        this.handleDataValidation(this.dataValidations);
        this.dataValidations.clear();
        this.handleSheetComments(this.sheetComments);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    @SdkInternal
    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    @SdkInternal
    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    @SdkInternal
    public SharedStringsTable getSharedStringsTable() {
        return this.sst;
    }

    public void setSharedStringsTable(SharedStringsTable sst) {
        this.sst = sst;
    }

    @SdkInternal
    public ParsedRow getRowHolder() {
        return this.rowHolder;
    }

    @SdkInternal
    public void setRowHolder(ParsedRow holder) {
        this.rowHolder = holder;
    }

    @SdkInternal
    public ParsedCol getColHolder() {
        return this.colHolder;
    }

    @SdkInternal
    public void setColHolder(ParsedCol colHolder) {
        this.colHolder = colHolder;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public List<String> getEffectSheetNames() {
        return this.effectSheetNames;
    }

    public void setEffectSheetNames(List<String> effectSheetNames) {
        this.effectSheetNames = effectSheetNames;
    }

    public List<String> getAllSheetNames() {
        return this.allSheetNames;
    }

    public void setAllSheetNames(List<String> allSheetNames) {
        this.allSheetNames = allSheetNames;
    }

    public String getCurrentSheetName() {
        return this.currentSheetName;
    }

    public void setCurrentSheetName(String sheetName) {
        this.currentSheetName = sheetName;
        this.rowHolder = new ParsedRow();
        this.colHolder = new ParsedCol();
    }

    public static class CellValidation {
        private final String sheetName;
        private String range;
        private String validation;

        public CellValidation(String sheetName) {
            this.sheetName = sheetName;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getValidation() {
            return this.validation;
        }

        public void setValidation(String validation) {
            this.validation = validation;
        }

        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + (this.getRange() == null ? 0 : this.getRange().hashCode());
            hashcode = 31 * hashcode + (this.getValidation() == null ? 0 : this.getValidation().hashCode());
            return hashcode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CellValidation)) {
                return false;
            }
            CellValidation other = (CellValidation)obj;
            return (this.getRange() != null ? this.getRange().equals(other.getRange()) : other.getRange() == null) && (this.getValidation() != null ? this.getValidation().equals(other.getValidation()) : other.getValidation() == null);
        }
    }

    public static class ParsedCol {
        Map<Integer, Map<String, Object>> colProperty = new HashMap<Integer, Map<String, Object>>();

        public Map<Integer, Map<String, Object>> getColProperty() {
            return this.colProperty;
        }
    }

    public static class ParsedRow {
        Map<Integer, String> data = new HashMap<Integer, String>();
        private int rowNum;
        private boolean hideRow = false;
        private Map<Integer, Integer> cellStyles = new HashMap<Integer, Integer>();

        public Map<Integer, Integer> getStyles() {
            return this.cellStyles;
        }

        public void addCellStyles(Integer index, Integer styleIndex) {
            this.cellStyles.put(index, styleIndex);
        }

        public int getRowNum() {
            return this.rowNum;
        }

        public void setRowNum(int rowNum) {
            this.rowNum = rowNum;
        }

        public Map<Integer, String> getData() {
            return this.data;
        }

        public boolean isEmpty() {
            if (!this.data.isEmpty()) {
                for (String v : this.data.values()) {
                    if (!StringUtils.isNotBlank((CharSequence)v)) continue;
                    return false;
                }
            }
            return true;
        }

        public String get(Integer i) {
            return this.data.get(i);
        }

        public boolean isHideRow() {
            return this.hideRow;
        }

        public void setHideRow(boolean hideRow) {
            this.hideRow = hideRow;
        }
    }

    public static enum XSSFDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

