/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;

public class ValidateDataFlowSuggester {
    private static Log log = LogFactory.getLog(ValidateDataFlowSuggester.class);
    private IndImportStart importStart;
    private ImportQueue<ImportBillData> outQueue;
    private int suggestThreads;
    private int workerMaxThread;

    public ValidateDataFlowSuggester(IndImportStart importStart, int workerMaxThread, ImportQueue<ImportBillData> outQueue) {
        this.importStart = importStart;
        this.outQueue = outQueue;
        this.suggestThreads = MCConfigConstant.getWorkerMaxThread();
        this.workerMaxThread = workerMaxThread;
    }

    public int getSuggestThreads() {
        if (this.suggestThreads < 1) {
            this.suggestThreads = 1;
        }
        return this.suggestThreads;
    }

    public void runDataFlowSuggest() {
        if (this.outQueue.getQueue().size() >= 3000) {
            if (this.suggestThreads >= 2) {
                this.suggestThreads = (int)((double)this.suggestThreads * 0.5);
            }
        } else {
            this.suggestThreads = ++this.suggestThreads;
            if (this.suggestThreads > this.workerMaxThread) {
                this.suggestThreads = this.workerMaxThread;
            }
        }
    }

    public static int getWorkerMaxThread(IndImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int workerMaxThread = MCConfigConstant.getWorkerMaxThread();
        importStart.getMonitor().getImportTrace().getOther().put(ValidateDataFlowSuggester.class.getSimpleName() + "_workerMaxThread", workerMaxThread);
        return workerMaxThread;
    }
}

