/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.algo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.task.BillDataSizeAssessTask;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTempStoreDispatcher;

public class AlgoManager {
    private static final Log LOGGER = LogFactory.getLog(AlgoManager.class);
    private final int defaultColumsCount = 2;
    private volatile boolean canNotDealRelateField = false;
    public static final String COL_DATA = "data";
    public static final String COL_SEQ = "seq";
    private Map<String, DataSet> dataSetMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, DataSetBuilder> builderMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Integer> fillExtentColumsMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Integer> seqMap = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, String> extentColumsMap;
    private String hasExtentSheetName;
    private IndImportStart importStart;

    public Map<String, DataSet> getDataSetMap() {
        return this.dataSetMap;
    }

    public Map<String, DataSetBuilder> getBuilderMap() {
        return this.builderMap;
    }

    public void setDataSetMap(Map<String, DataSet> dataSetMap) {
        this.dataSetMap = dataSetMap;
    }

    public AlgoManager(IndImportStart importStart) {
        this.importStart = importStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(List<ImportBillData> datas) {
        DataSetBuilder dataSetBuilder;
        long start = System.currentTimeMillis();
        ImportContext importContext = this.importStart.getImportContext();
        ImportBillData billData = datas.get(0);
        String entityId = importContext.getSheetEntityMap().get(billData.getSheetName());
        Integer needFillColumCount = this.fillExtentColumsMap.get(billData.getSheetName());
        DataSetBuilder dataSetBuilder2 = dataSetBuilder = this.builderMap.get(billData.getSheetName());
        synchronized (dataSetBuilder2) {
            Integer seq = this.seqMap.get(billData.getSheetName());
            for (ImportBillData data : datas) {
                int i;
                if (this.importStart.isStoped()) break;
                String str = JSONObject.toJSONString((Object)data);
                if (needFillColumCount == null) {
                    needFillColumCount = 0;
                }
                int count = needFillColumCount + 2;
                String[] split = new String[]{};
                Object[] objects = new Object[count];
                Integer n = seq;
                Integer n2 = seq = Integer.valueOf(seq + 1);
                objects[0] = n;
                objects[1] = str;
                int offset = 2;
                LOGGER.info("save_count=" + count + ",split.length=" + split.length);
                for (i = 0; i < split.length; ++i) {
                    String val = "";
                    String[] splitAttr = StringUtils.split((String)split[i], (String)".");
                    if (splitAttr.length == 2) {
                        JSONObject colVal = data.getData().getJSONObject(entityId).getJSONObject(splitAttr[0]);
                        val = (String)colVal.get((Object)splitAttr[1]);
                    } else {
                        Object obj = data.getData().getJSONObject(entityId).get((Object)split[i]);
                        if (obj instanceof JSONObject) {
                            JSONObject jobj = (JSONObject)obj;
                            String fval = jobj.getString(RequestContext.get().getLang().toString());
                            if (StringUtils.isNotEmpty((CharSequence)fval)) {
                                val = fval;
                            } else {
                                if (!this.canNotDealRelateField) {
                                    this.canNotDealRelateField = true;
                                    LOGGER.error("canNotDealRelateField_occured.entityId=" + entityId + ",field=" + split[i] + ",obj=" + jobj.toJSONString());
                                    this.importStart.getMonitor().getImportTrace().getOther().put("canNotDealRelateField", true);
                                }
                                val = String.valueOf(obj);
                            }
                        } else {
                            val = String.valueOf(obj);
                        }
                    }
                    objects[offset] = val;
                    ++offset;
                }
                for (i = 0; i < needFillColumCount; ++i) {
                    objects[offset] = false;
                    ++offset;
                }
                dataSetBuilder.append(objects);
            }
            this.seqMap.put(billData.getSheetName(), seq);
        }
        this.importStart.getMonitor().addExpenseStatistics("put_dataSet_" + billData.getSheetName(), (Long)(System.currentTimeMillis() - start), false);
        this.importStart.getMonitor().addMEMSTotalCount("dataSet_" + billData.getSheetName() + "_count", datas.size());
    }

    public void putToOutQueue(String sheetName, IndImportWorker worker) {
        DataSet dataSet = this.dataSetMap.get(sheetName);
        Iterator iterator = dataSet.iterator();
        while (iterator.hasNext() && !this.importStart.isStoped()) {
            Row next = (Row)iterator.next();
            String json = (String)next.get(COL_DATA);
            ImportBillData billData = (ImportBillData)JSONObject.parseObject((String)json, ImportBillData.class);
            int retryCount = 100;
            worker.putToOutQueue(billData, retryCount);
        }
        if (sheetName.equals(this.hasExtentSheetName)) {
            IndTempStoreDispatcher.hasExtentColum = false;
            this.hasExtentSheetName = null;
        }
    }

    public void buildDataSet() {
        for (Map.Entry<String, DataSetBuilder> next : this.builderMap.entrySet()) {
            DataSet dataSet = next.getValue().build();
            this.dataSetMap.put(next.getKey(), dataSet);
        }
    }

    public void createDataSetBuilder(List<ImportBillData> tempBilldatas) {
        ImportContext importContext = this.importStart.getImportContext();
        String sheetName = tempBilldatas.get(0).getSheetName();
        DataSetBuilder dataSetBuilder = this.builderMap.get(sheetName);
        if (dataSetBuilder == null) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
            long freeMemorySize = (heapMemoryUsage.getMax() - heapMemoryUsage.getUsed()) / 1024L / 1024L;
            long availableSize = freeMemorySize - 3024L;
            Map<String, Integer> resul = null;
            if (BillDataSizeAssessTask.canTriggerBillDataSizeAssess(importContext)) {
                resul = this.getAssessSheetDataSize(sheetName, 0);
            }
            int totalSize = 0;
            if (resul != null) {
                totalSize = resul.get("totalSize");
            }
            if (resul != null && !IndTempStoreDispatcher.hasExtentColum && (long)totalSize > availableSize) {
                this.importStart.getMonitor().getImportTrace().getMems().put("needAlgoExtentColum", true);
                this.hasExtentSheetName = sheetName;
                IndTempStoreDispatcher.hasExtentColum = true;
                int totalCount = resul.get("totalCount");
                int perSize = resul.get("perSize");
                long differSize = ((long)totalSize - availableSize) * 1024L * 1024L;
                int diffCount = (int)(differSize / (long)perSize);
                int relateColumCount = 0;
                int global_max_cells = AlgoConfiguration.MM_LIMIT_GLOBALMAXCELLS.getInt();
                int needFillCellCount = global_max_cells - totalCount * (2 + relateColumCount);
                int needFillColumCount = (int)Math.ceil((double)(needFillCellCount + diffCount) / (double)totalCount);
                Map<String, Object> map = this.createColums(sheetName, needFillColumCount);
                String[] fileds = (String[])map.get("fileds");
                DataType[] types = (DataType[])map.get("types");
                RowMeta meta = new RowMeta(fileds, types);
                DataSetBuilder builder = Algo.create((String)"import_".concat(UUID.randomUUID().toString())).createDataSetBuilder(meta);
                this.builderMap.put(sheetName, builder);
                this.fillExtentColumsMap.put(sheetName, needFillColumCount);
                this.importStart.getMonitor().getImportTrace().getOther().put("fillExtentColums", this.fillExtentColumsMap);
            } else {
                Map<String, Object> map = this.createColums(sheetName, 0);
                String[] fileds = (String[])map.get("fileds");
                DataType[] types = (DataType[])map.get("types");
                RowMeta meta = new RowMeta(fileds, types);
                DataSetBuilder builder = Algo.create((String)"import_".concat(UUID.randomUUID().toString())).createDataSetBuilder(meta);
                this.builderMap.put(sheetName, builder);
            }
        }
    }

    private Map<String, Object> createColums(String sheetName, int placeholdersColumCount) {
        int i;
        this.seqMap.put(sheetName, 0);
        ImportContext importContext = this.importStart.getImportContext();
        int count = placeholdersColumCount + 2;
        String[] split = new String[]{};
        String[] fileds = new String[count];
        DataType[] types = new DataType[count];
        fileds[0] = COL_SEQ;
        types[0] = DataType.LongType;
        fileds[1] = COL_DATA;
        types[1] = DataType.StringType;
        int offset = 2;
        LOGGER.info("createColums_count=" + count + ",split.length=" + split.length);
        for (i = 0; i < split.length; ++i) {
            fileds[offset] = split[i];
            types[offset] = DataType.StringType;
            ++offset;
        }
        for (i = 0; i < placeholdersColumCount; ++i) {
            fileds[offset] = "@" + i;
            types[offset] = DataType.BooleanType;
            ++offset;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("fileds", fileds);
        map.put("types", types);
        map.put("relateColumCount", types);
        return map;
    }

    private Map<String, Integer> getAssessSheetDataSize(String sheetName, int repeat) {
        ImportContext importContext = this.importStart.getImportContext();
        Map<String, Integer> result = importContext.getSheetDataSizeMap().get(sheetName);
        if (result != null) {
            return result;
        }
        if (repeat > 5) {
            return null;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        return this.getAssessSheetDataSize(sheetName, ++repeat);
    }
}

