/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="Excel\u6a21\u677f\u8868\u5934\u5b57\u6bb5\u5217\u5b9a\u4e49")
public class ExportHeaderWriterFormat {
    private String enityName;
    private String belongEntityName;
    private String displayName;
    private int startColNumber;
    private int rowStartIndex;
    private int dropDownStartIndex = 6;
    private boolean hasFieldimportdesc;
    private boolean isMainEntity;
    private boolean isEntryentity;
    private List<String> fields = new LinkedList<String>();
    private Map<String, Map<String, Object>> properties = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, List<String>> flexColumn = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, List<String>> flexColumnDisplay = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, List<String>> flexColumnDesc = Maps.newHashMapWithExpectedSize((int)16);
    private List<ExportHeaderWriterFormat> next = new ArrayList<ExportHeaderWriterFormat>(2);
    private static int tempParseOffset;

    @SdkInternal
    public ExportHeaderWriterFormat() {
    }

    @SdkInternal
    public ExportHeaderWriterFormat(String enityName, String displayName, int col) {
        this.enityName = enityName;
        this.displayName = displayName;
        this.startColNumber = col;
    }

    public int getRowStartIndex() {
        return this.rowStartIndex;
    }

    public int getDropDownStartIndex() {
        return this.dropDownStartIndex;
    }

    public void setDropDownStartIndex(int dropDownStartIndex) {
        this.dropDownStartIndex = dropDownStartIndex;
    }

    public void setRowStartIndex(int rowStartIndex) {
        this.rowStartIndex = rowStartIndex;
    }

    public int getStartColNumber() {
        return this.startColNumber;
    }

    public void setStartColNumber(int startColNumber) {
        this.startColNumber = startColNumber;
    }

    public String getEnityName() {
        return this.enityName;
    }

    public void setEnityName(String enityName) {
        this.enityName = enityName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isHasFieldimportdesc() {
        return this.hasFieldimportdesc;
    }

    public void setHasFieldimportdesc(boolean hasFieldimportdesc) {
        this.hasFieldimportdesc = hasFieldimportdesc;
    }

    public boolean isMainEntity() {
        return this.isMainEntity;
    }

    public void setMainEntity(boolean mainEntity) {
        this.isMainEntity = mainEntity;
    }

    public boolean isEntryentity() {
        return this.isEntryentity;
    }

    public void setEntryentity(boolean entryentity) {
        this.isEntryentity = entryentity;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Map<String, Map<String, Object>> getProperties() {
        return this.properties;
    }

    public List<ExportHeaderWriterFormat> getNext() {
        return this.next;
    }

    public Map<String, List<String>> getFlexColumn() {
        return this.flexColumn;
    }

    public void setFlexColumn(Map<String, List<String>> flexColumn) {
        this.flexColumn = flexColumn;
    }

    public Map<String, List<String>> getFlexColumnDisplay() {
        return this.flexColumnDisplay;
    }

    public void setFlexColumnDisplay(Map<String, List<String>> flexColumnDisplay) {
        this.flexColumnDisplay = flexColumnDisplay;
    }

    public Map<String, List<String>> getFlexColumnDesc() {
        return this.flexColumnDesc;
    }

    public void setFlexColumnDesc(Map<String, List<String>> flexColumnDesc) {
        this.flexColumnDesc = flexColumnDesc;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setProperties(Map<String, Map<String, Object>> properties) {
        this.properties = properties;
    }

    public void setNext(List<ExportHeaderWriterFormat> next) {
        this.next = next;
    }

    public String getBelongEntityName() {
        return this.belongEntityName;
    }

    public void setBelongEntityName(String belongEntityName) {
        this.belongEntityName = belongEntityName;
    }

    public static int getTempParseOffset() {
        return tempParseOffset;
    }

    public static void setTempParseOffset(int tempParseOffset) {
        ExportHeaderWriterFormat.tempParseOffset = tempParseOffset;
    }

    @SdkInternal
    public synchronized ExportHeaderWriterFormat ready(Set<String> fieldset) {
        tempParseOffset = 0;
        return this.build(fieldset);
    }

    private synchronized ExportHeaderWriterFormat build(Set<String> fieldset) {
        this.startColNumber = tempParseOffset;
        tempParseOffset += this.fields.size() + this.countSplitColumn();
        if (fieldset != null && !fieldset.isEmpty()) {
            this.fields.sort((s1, s2) -> {
                if (s1 != null && s1.endsWith(".id")) {
                    return -1;
                }
                if (s2 != null && s2.endsWith(".id")) {
                    return 1;
                }
                for (String str : fieldset) {
                    if (str == null) continue;
                    if (str.equals(s1)) {
                        return -1;
                    }
                    if (!str.equals(s2)) continue;
                    return 1;
                }
                return 0;
            });
        }
        Iterator<ExportHeaderWriterFormat> iter = this.next.iterator();
        while (iter.hasNext()) {
            ExportHeaderWriterFormat w = iter.next();
            if (w.fields.size() == 0) {
                iter.remove();
                continue;
            }
            w.build(fieldset);
        }
        return this;
    }

    private int countSplitColumn() {
        int split = 0;
        int repeat = 0;
        for (Map.Entry<String, List<String>> splitCols : this.flexColumn.entrySet()) {
            if (this.fields.contains(splitCols.getKey())) {
                ++repeat;
            }
            split += splitCols.getValue().size();
        }
        return split > 0 ? split - repeat : 0;
    }
}

