/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.entity;

import com.google.common.collect.Table;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.service.ServiceFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportSheetStyle {
    public static final String DEFAULT = "default";
    private static boolean openOldStyle = false;
    private Table<String, String, CellStyle> customHeadCellStyles;
    private Table<String, String, CellStyle> customContentCellStyles;
    private CellStyle globalHeadCellStyle;
    private CellStyle globalContentCellStyle;
    private Table<String, String, String> customFieldMerges;
    private SXSSFRow entityRow;
    private SXSSFRow nameRow;
    private Map<Integer, String> entities;
    private Map<Integer, String> fieldnames;
    private SXSSFWorkbook wb;
    private Map<String, CellStyle> decimalStyles = new HashMap<String, CellStyle>();
    private Map<String, CellStyle> textStyles = new HashMap<String, CellStyle>();
    private Map<String, DecimalFormat> decimalFormats = new HashMap<String, DecimalFormat>();
    private Font redFont;
    private boolean autoLine = true;

    public Map<Integer, String> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<Integer, String> entities) {
        this.entities = entities;
    }

    public Map<Integer, String> getFieldnames() {
        return this.fieldnames;
    }

    public void setFieldnames(Map<Integer, String> fieldnames) {
        this.fieldnames = fieldnames;
    }

    public ExportSheetStyle(SXSSFWorkbook wb, String entityId) {
        this.wb = wb;
        this.redFont = wb.createFont();
        this.redFont.setColor(IndexedColors.RED.getIndex());
        if (entityId != null) {
            IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
            this.autoLine = exportService.getSettingOfAutoLine(entityId);
        }
    }

    public ExportSheetStyle(SXSSFWorkbook wb) {
        this(wb, null);
    }

    public void reference(SXSSFRow entityRow, SXSSFRow nameRow) {
        this.setEntityRow(entityRow);
        this.setNameRow(nameRow);
    }

    public ExportSheetStyle(SXSSFWorkbook wb, CellStyle globalHeadCellStyle, CellStyle globalContentCellStyle) {
        this(wb, null);
        if (!openOldStyle) {
            this.globalHeadCellStyle = globalHeadCellStyle;
            this.globalContentCellStyle = globalContentCellStyle;
        }
    }

    public ExportSheetStyle(SXSSFWorkbook wb, Table<String, String, CellStyle> customHeadCellStyles, Table<String, String, CellStyle> customContentCellStyles) {
        this(wb, null);
        if (!openOldStyle) {
            this.customHeadCellStyles = customHeadCellStyles;
            this.customContentCellStyles = customContentCellStyles;
        }
    }

    public CellStyle getTplCodeRowTextStyle() {
        String style = "TplCodeRowTextStyle";
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setWrapText(false);
            Font font = this.wb.createFont();
            font.setColor(IndexedColors.BLUE.getIndex());
            cs.setFont(font);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getFieldDescRowTextStyle() {
        String style = "FieldDescRowTextStyle";
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setWrapText(this.autoLine);
            Font font = this.wb.createFont();
            font.setColor(IndexedColors.GREY_50_PERCENT.getIndex());
            font.setItalic(true);
            cs.setFont(font);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private CellStyle getHeadCellStyle(String entityId, String fieldName) {
        CellStyle cellStyle = null;
        if (ObjectUtils.isNotEmpty(this.customHeadCellStyles)) {
            cellStyle = (CellStyle)this.customHeadCellStyles.get((Object)entityId, (Object)fieldName);
        }
        if (cellStyle == null && ObjectUtils.isNotEmpty((Object)this.globalHeadCellStyle)) {
            cellStyle = this.globalHeadCellStyle;
        }
        return cellStyle;
    }

    private CellStyle getContentCellStyle(String entityId, String fieldName) {
        CellStyle cellStyle = null;
        if (ObjectUtils.isNotEmpty(this.customContentCellStyles)) {
            cellStyle = (CellStyle)this.customContentCellStyles.get((Object)entityId, (Object)fieldName);
        }
        if (cellStyle == null && ObjectUtils.isNotEmpty((Object)this.globalContentCellStyle)) {
            cellStyle = this.globalContentCellStyle;
        }
        return cellStyle;
    }

    public CellStyle getHeadTextStyle(String entityId, String fieldName) {
        CellStyle textStyle = this.getTextStyle(DEFAULT);
        CellStyle cellStyle = this.getHeadCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
        }
        return cellStyle;
    }

    public CellStyle getContentTextStyle(String entityId, String fieldName) {
        CellStyle textStyle = this.getTextStyle(DEFAULT);
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
        }
        return cellStyle;
    }

    public CellStyle getHeadTextStyle(String align) {
        CellStyle textStyle = this.getTextStyle(align);
        CellStyle cellStyle = this.globalHeadCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
            cellStyle.setAlignment(textStyle.getAlignment());
        }
        return cellStyle;
    }

    public CellStyle getContentTextStyle() {
        CellStyle textStyle = this.getTextStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setWrapText(textStyle.getWrapText());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
        }
        return cellStyle;
    }

    public CellStyle getTextStyle() {
        return this.getTextStyle(DEFAULT);
    }

    public CellStyle getTextStyle(String align) {
        String style = "TEXT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            this.textStyles.put(style, cs);
        }
        cs.setWrapText(this.autoLine);
        return cs;
    }

    public CellStyle getHeadDateStyle(String entityId, String fieldName) {
        CellStyle cellStyle = this.getHeadCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDateStyle(DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDateStyle(DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDateStyle(String entityId, String fieldName) {
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDateStyle(DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDateStyle(DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDateStyle() {
        CellStyle textStyle = this.getDateStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(this.getDateStyle().getDataFormat());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
        }
        return cellStyle;
    }

    public CellStyle getDateStyle() {
        return this.getDateStyle(DEFAULT);
    }

    public CellStyle getDateStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.textStyles.get(style = "DATE_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-mm-dd"));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getHeadDatetimeStyle(String entityId, String fieldName) {
        CellStyle cellStyle = this.getHeadCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDatetimeStyle(DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDatetimeStyle(DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDatetimeStyle(String entityId, String fieldName) {
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDatetimeStyle(DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDatetimeStyle(DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDatetimeStyle() {
        CellStyle textStyle = this.getDatetimeStyle();
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
        }
        return cellStyle;
    }

    public CellStyle getDatetimeStyle() {
        return this.getDatetimeStyle(DEFAULT);
    }

    public CellStyle getDatetimeStyle(String align) {
        String style;
        CellStyle cs;
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "left";
        }
        if ((cs = this.textStyles.get(style = "DATETIME_" + align)) == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-mm-dd H:mm:ss"));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getHlinkStyle() {
        return this.getHlinkStyle(DEFAULT);
    }

    public CellStyle getHlinkStyle(String align) {
        String style = "HLINK_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            Font hlink_font = this.wb.createFont();
            hlink_font.setUnderline((byte)1);
            hlink_font.setColor(IndexedColors.BLUE.getIndex());
            cs.setFont(hlink_font);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getExportTitleStyle() {
        CellStyle titleStyle = this.getTitleStyle(DEFAULT);
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBorderLeft(BorderStyle.THIN);
        return titleStyle;
    }

    public CellStyle getTitleStyle() {
        return this.getTitleStyle(DEFAULT);
    }

    public CellStyle getTitleStyle(String align) {
        String style = "TITLE_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setAlignment(this.getAlignment(align));
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getNameStyle() {
        return this.getTitleStyle();
    }

    public CellStyle getNameStyle(String align) {
        String style = "NAME_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public Font getRedFont() {
        return this.redFont;
    }

    public CellStyle getTitleMustInputStyle() {
        return this.getTitleMustInputStyle(DEFAULT);
    }

    public CellStyle getTitleMustInputStyle(String align) {
        String style = "TITLEMUSTINPUT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setFont(this.redFont);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getTextHighLightStyle() {
        return this.getTextHighLightStyle(DEFAULT);
    }

    public CellStyle getTextHighLightStyle(String align) {
        String style = "TEXTHIGHLIGHT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setFont(this.redFont);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getErrorColStyle() {
        String style = "ERROR_COLUMN";
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setFont(this.redFont);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public CellStyle getSuccessColStyle() {
        String style = "SUCCESS_COLUMN";
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            Font font = this.wb.createFont();
            font.setColor(IndexedColors.GREEN.getIndex());
            cs.setFont(font);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    public SXSSFRow getEntityRow() {
        return this.entityRow;
    }

    public void setEntityRow(SXSSFRow entityRow) {
        this.entityRow = entityRow;
        this.entities = new LinkedHashMap<Integer, String>();
        for (Cell cell : entityRow) {
            if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) continue;
            this.entities.put(cell.getColumnIndex(), cell.getStringCellValue());
        }
    }

    public SXSSFRow getNameRow() {
        return this.nameRow;
    }

    public void setNameRow(SXSSFRow nameRow) {
        this.nameRow = nameRow;
        this.fieldnames = new LinkedHashMap<Integer, String>();
        for (Cell cell : nameRow) {
            if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) continue;
            this.fieldnames.put(cell.getColumnIndex(), cell.getStringCellValue());
        }
    }

    public CellStyle getHeadDecimalStyle(String entityId, String fieldName, SXSSFWorkbook wb, Map<String, Object> dataMap) {
        CellStyle cellStyle = this.getHeadCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDecimalStyle(wb, dataMap, DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDecimalStyle(wb, dataMap, DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDecimalStyle(String entityId, String fieldName, SXSSFWorkbook wb, Map<String, Object> dataMap) {
        CellStyle cellStyle = this.getContentCellStyle(entityId, fieldName);
        if (cellStyle == null) {
            cellStyle = this.getDecimalStyle(wb, dataMap, DEFAULT);
        } else {
            cellStyle.setDataFormat(this.getDecimalStyle(wb, dataMap, DEFAULT).getDataFormat());
        }
        return cellStyle;
    }

    public CellStyle getContentDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap) {
        CellStyle textStyle = this.getDecimalStyle(wb, dataMap);
        CellStyle cellStyle = this.globalContentCellStyle;
        if (cellStyle == null) {
            cellStyle = textStyle;
        } else {
            cellStyle.setDataFormat(textStyle.getDataFormat());
            cellStyle.setVerticalAlignment(textStyle.getVerticalAlignment());
        }
        return cellStyle;
    }

    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap) {
        return this.getDecimalStyle(wb, dataMap, DEFAULT);
    }

    public CellStyle getDecimalStyle(SXSSFWorkbook wb, Map<String, Object> dataMap, String align) {
        if (StringUtils.isBlank((CharSequence)align) || DEFAULT.equalsIgnoreCase(align)) {
            align = "right";
        }
        CellStyle style = null;
        if (dataMap == null) {
            style = this.decimalStyles.get(" " + align);
            if (style == null) {
                style = wb.createCellStyle();
                style.setDataFormat((short)0);
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.decimalStyles.put(" " + align, style);
            }
        } else if (dataMap.containsKey("sign") || dataMap.containsKey("precision")) {
            String sign = Boolean.TRUE.equals(dataMap.get("showSign")) ? (String)dataMap.get("sign") : "";
            int precision = (Integer)dataMap.get("precision");
            style = this.decimalStyles.get(sign + " " + precision + " " + align);
            if (style == null) {
                String format = sign.length() == 1 ? "_(<ccy> #,##0.00_);_(<ccy> -#,##0.00_)".replace("<ccy>", "") : "#,##0.00";
                format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                style = wb.createCellStyle();
                style.setDataFormat(wb.createDataFormat().getFormat(format));
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setAlignment(this.getAlignment(align));
                this.decimalStyles.put(sign + " " + precision + " " + align, style);
                this.decimalFormats.putIfAbsent(format, new DecimalFormat(format));
            }
        }
        return style;
    }

    public Table<String, String, String> getCustomFieldMerges() {
        return this.customFieldMerges;
    }

    public void setCustomFieldMerges(Table<String, String, String> customFieldMerges) {
        this.customFieldMerges = customFieldMerges;
    }

    public boolean isExistMergeCol(String entityName) {
        if (ObjectUtils.isEmpty(this.customFieldMerges)) {
            return false;
        }
        return ObjectUtils.isNotEmpty((Object)this.customFieldMerges.containsColumn((Object)entityName));
    }

    public Map<String, DecimalFormat> getDecimalFormats() {
        return this.decimalFormats;
    }

    public void setGlobalHeadCellStyle(CellStyle globalHeadCellStyle) {
        this.globalHeadCellStyle = globalHeadCellStyle;
    }

    public CellStyle getGlobalContentCellStyle() {
        return this.globalContentCellStyle;
    }

    public void setGlobalContentCellStyle(CellStyle globalContentCellStyle) {
        this.globalContentCellStyle = globalContentCellStyle;
    }

    public CellStyle getGlobalHeadCellStyle() {
        return this.globalHeadCellStyle;
    }

    public static void setOpenOldStyle(boolean openOldStyle) {
        ExportSheetStyle.openOldStyle = openOldStyle;
    }
}

