/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Locale;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FieldStyle
implements Serializable {
    private static final long serialVersionUID = 2486921874601315092L;
    @JsonProperty(value="color")
    private String color = "#212121ff";
    @JsonProperty(value="background-color")
    private String backgroundColor;
    @JsonProperty(value="font-family")
    private String fontFamily;
    @JsonProperty(value="font-weight")
    private String fontWeight;
    @JsonProperty(value="font-style")
    private String fontStyle;
    @JsonProperty(value="font-size")
    private String fontSize;
    @JsonProperty(value="text-align")
    private String textAlign;

    @SimplePropertyAttribute
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @SimplePropertyAttribute
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @SimplePropertyAttribute
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @SimplePropertyAttribute
    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    @SimplePropertyAttribute
    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    @SimplePropertyAttribute
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    @SimplePropertyAttribute
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public CellStyle getCellStyle(XSSFWorkbook _wb) {
        XSSFCellStyle cellStyle = _wb.createCellStyle();
        cellStyle.setAlignment(this.getAlignment());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if (StringUtils.isNotBlank((CharSequence)this.backgroundColor)) {
            XSSFColor backgroundColor = new XSSFColor();
            backgroundColor.setARGBHex(this.getArgbColor(this.backgroundColor));
            cellStyle.setFillForegroundColor(backgroundColor);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        }
        XSSFColor xssfColor = new XSSFColor();
        XSSFFont font = _wb.createFont();
        if (StringUtils.isNotBlank((CharSequence)this.color)) {
            xssfColor.setARGBHex(this.getArgbColor(this.color));
            font.setColor(xssfColor);
        }
        font.setBold(this.getBold());
        font.setItalic(this.getItalic());
        font.setFontName(this.fontFamily);
        font.setFontHeight(this.replacePxToPt());
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private String getArgbColor(String color) {
        String tempColor = color.replace("#", "").toUpperCase(Locale.ROOT);
        return tempColor.substring(6, 8) + tempColor.substring(0, 6);
    }

    private double replacePxToPt() {
        if (StringUtils.isNotBlank((CharSequence)this.fontSize)) {
            return Double.parseDouble(this.fontSize.replace("pt", ""));
        }
        return 11.0;
    }

    private HorizontalAlignment getAlignment() {
        try {
            return HorizontalAlignment.valueOf((String)this.textAlign.toUpperCase());
        }
        catch (Throwable throwable) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private boolean getBold() {
        return "bolder".equals(this.fontWeight);
    }

    private boolean getItalic() {
        return "italic".equals(this.fontStyle);
    }
}

