/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.entity;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;

public class ImportQueue<T> {
    private static Log log = LogFactory.getLog(ImportQueue.class);
    private String name;
    private LinkedBlockingQueue<T> queue;
    private IndImportStart importStart;

    public ImportQueue(String name, LinkedBlockingQueue<T> queue, IndImportStart importStart) {
        this.name = name;
        this.queue = queue;
        this.importStart = importStart;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkedBlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setQueue(LinkedBlockingQueue<T> queue) {
        this.queue = queue;
    }

    public boolean putOnceWithTimeOut(ImportBillData data) {
        try {
            boolean result = this.queue.offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.importStart.getMonitor().addQueueStatistics(this.name, 0, -1);
            } else {
                this.importStart.getMonitor().addQueueStatistics(this.name, 1, this.queue.size());
            }
            return result;
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }

    public boolean putOnce(ImportBillData data) {
        try {
            boolean result = this.queue.offer(data);
            if (!result) {
                this.importStart.getMonitor().addQueueStatistics(this.name, 0, -1);
            } else {
                this.importStart.getMonitor().addQueueStatistics(this.name, 1, this.queue.size());
            }
            return result;
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }
}

