/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.extpoint.impl;

import java.io.File;
import java.io.IOException;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.api.HRImExptTaskServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.ExcelImportFailedSheetHandler;
import kd.opmc.epa.business.domain.indicator.imp.ExcelReader;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.extpoint.IIndReporterService;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportFileUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndReporter;

public class IndReporterServiceImpl
implements IIndReporterService {
    private static final Log LOGGER = LogFactory.getLog(IndReporterServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handlerReport(IndImportStart importStart, IndReporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        ImportContext importContext = importStart.getImportContext();
        MethodUtil.syncRequestTraceId(importContext.getRc());
        LOGGER.info("Reporter_started.");
        try {
            File file = new File(importContext.getFileLocalPath());
            if (!file.exists()) {
                String localPatch = ImportFileUtil.downloadFile(importContext.getFilePath());
                importContext.setFileLocalPath(localPatch);
                file = new File(localPatch);
            }
            new ExcelReader(importStart).readByWayType(file, new ExcelImportFailedSheetHandler(reporter), "fail", true);
            LOGGER.info("Reporter_end.");
        }
        catch (Throwable exception) {
            LOGGER.error("Reporter-call() error:", exception);
            importStart.writeErrorLog(exception);
        }
        finally {
            importStart.getMonitor().addExpenseStatistics(reporter.getName(), (Long)(System.currentTimeMillis() - start), true);
            this.updateFileUrl(importStart);
            ImportFileUtil.deleteLocalTempFile(importStart.getImportContext().getFileLocalPath());
        }
        return true;
    }

    private void updateFileUrl(IndImportStart importStart) {
        try {
            ImportContext importContext = importStart.getImportContext();
            String errorFileForAllData = importContext.getErrorFileForAllData();
            String errorFileForErrorData = importContext.getErrorFileForErrorData();
            String systemErrLog = SerializationUtils.toJsonString(importContext.getImportLog().getErrorLogs());
            Long taskPkId = importContext.getTaskPkId();
            HRImExptTaskServiceHelper.updateFileUrl((Long)taskPkId, (String)errorFileForAllData, (String)errorFileForErrorData, (String)systemErrLog);
        }
        catch (Throwable e) {
            LOGGER.error("saveTaskInfo_exception.", e);
            importStart.writeErrorLog(e);
        }
    }
}

