/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import org.apache.commons.lang3.StringUtils;

public class DataValidateServiceHelper {
    private static final Log LOG = LogFactory.getLog(DataValidateServiceHelper.class);

    public static String getPermissionStatus(String importType) {
        switch (importType) {
            case "update": {
                return "4715a0df000000ac";
            }
            case "delete": {
                return "4715e1f1000000ac";
            }
        }
        return "47156aff000000ac";
    }

    public static BOSExpression getDataRuleScript(String permissionStatus, String entityFormId, String appId) {
        return new BOSExpression((String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"PermissionService", (String)"getDataRuleScript", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId, permissionStatus, Maps.newHashMap()}));
    }

    public static QFilter getDataRuleForBdProp(String entityFormId, String appId, String propKey, String permItemId) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId, propKey, permItemId, null});
    }

    public static QFilter getBaseDataQFilter(String baseDataEntityNumber, Long useOrgId) {
        return (QFilter)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IBaseDataService", (String)"getBaseDataFilter", (Object[])new Object[]{baseDataEntityNumber, useOrgId});
    }

    public static Set<String> getFieldControlRules(String appId, String entityFormId) {
        FieldControlRules fieldControlRules = (FieldControlRules)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"PermissionService", (String)"getFieldControlRules", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityFormId});
        if (fieldControlRules != null && fieldControlRules.getFieldControlRuleDtos().size() > 0) {
            List fieldControlRuleDtos = fieldControlRules.getFieldControlRuleDtos();
            HashSet nonFieldPermSet = Sets.newHashSetWithExpectedSize((int)fieldControlRuleDtos.size());
            fieldControlRuleDtos.forEach(fieldControlRuleDto -> {
                FieldControlRule fieldControlRule = fieldControlRuleDto.getFieldControlRule();
                nonFieldPermSet.addAll(fieldControlRule.getCanNotReadFields());
                nonFieldPermSet.addAll(fieldControlRule.getCanNotWriteFields());
            });
            return nonFieldPermSet;
        }
        return null;
    }

    public static void writeRowErrorLog(int type, ImportLog importLog, String sheetName, int startIndex, int endIndex, int errorIndex, Object ... params) {
        LOG.info("=====sheetName:{},  startIndex:{},  endIndex:{}, errorIndex:{},type:{}", new Object[]{sheetName, startIndex, endIndex, errorIndex, type});
        LOG.info("=====params:{}", params);
        String errorInfo = "";
        switch (type) {
            case 0: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u5fc5\u5f55\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6570\u636e\uff0c\u8bf7\u7ef4\u62a4\u6570\u636e\u540e\u4e0a\u4f20\u3002", (String)"DataValidateServiceHelper_0", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 1: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\uff0c%2$s\u3002", (String)"DataValidateServiceHelper_1", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 2: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u90ae\u7bb1\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"DataValidateServiceHelper_2", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 3: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"DataValidateServiceHelper_3", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 4: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u65e0\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7684\u5f15\u5165\u6743\u9650\uff0c\u5982\u9700\u7ee7\u7eed\u5f15\u5165\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_4", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 5: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u672a\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_5", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 6: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_6", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 7: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u65e0\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u7684\u5f15\u5165\u6743\u9650\uff0c\u5982\u9700\u7ee7\u7eed\u5f15\u5165\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_7", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 8: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_8", (String)"opmc-epa-business", (Object[])new Object[0]);
                break;
            }
            case 9: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_9", (String)"opmc-epa-business", (Object[])new Object[0]);
                break;
            }
            case 10: {
                errorInfo = ResManager.loadKDString((String)"\u65e0\u8be5\u884c\u6570\u636e\u7684\u5220\u9664\u6743\u9650\uff0c\u5982\u9700\u7ee7\u7eed\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_10", (String)"opmc-epa-business", (Object[])new Object[0]);
                break;
            }
            case 11: {
                errorInfo = ResManager.loadKDString((String)"\u65e0\u8be5\u884c\u6570\u636e\u7684\u5f15\u5165\u6743\u9650\uff0c\u5982\u9700\u7ee7\u7eed\u5f15\u5165\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"DataValidateServiceHelper_11", (String)"opmc-epa-business", (Object[])new Object[0]);
                break;
            }
            case 12: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u5f00\u59cb\u65e5\u671f\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_12", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 13: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u7ed3\u675f\u65e5\u671f\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_13", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 14: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7b2c%2$s\u5217\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_14", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 15: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u5f00\u59cb\u65f6\u95f4\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_15", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 16: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u5df2\u586b\u5199\u7ed3\u675f\u65f6\u95f4\uff0c\u5219\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_16", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 17: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b2c%2$s\u5217\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_17", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 18: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_18", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 19: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_19", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 20: {
                errorInfo = ResManager.loadKDString((String)"\u8be5\u884c\u5206\u5f55\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_20", (String)"opmc-epa-business", (Object[])new Object[0]);
                break;
            }
            case 21: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u7684\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u8fc7\u9650\u5b9a\u8303\u56f4%4$s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_21", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 22: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u201c%3$s\u201d\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_22", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 23: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u4ec5\u5f53\u66f4\u65b0\u5206\u5f55\u6570\u636e\u624d\u9700\u586b\u5199%1$s\u5217\u201c%2$s\u201d\u5b57\u6bb5\u3002", (String)"DataValidateServiceHelper_23", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
            case 24: {
                errorInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u5b57\u6bb5\u201c%2$s\u201d\u7ef4\u62a4\u7684\u6570\u636e\u6ca1\u6709\u5f15\u5165\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DataValidateServiceHelper_24", (String)"opmc-epa-business", (Object[])new Object[0]), params);
                break;
            }
        }
        LOG.warn("============errorInfo========={}================", (Object)errorInfo);
        if (params == null) {
            return;
        }
        importLog.writeRowLog(sheetName, startIndex, endIndex, errorIndex, errorInfo);
    }

    public static QFilter getDataRule(String entityNumber, String permItemId, Map<String, Object> customParam) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), DataValidateServiceHelper.getBizAppId(entityNumber), entityNumber, permItemId, customParam});
    }

    public static QFilter getPermMainBUQFilter(String entityNumber) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (StringUtils.isBlank((CharSequence)entityType.getMainOrg())) {
            return null;
        }
        String appId = DataValidateServiceHelper.getBizAppId(entityNumber);
        String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)entityNumber);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityNumber, (String)"47150e89000000ac");
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return new QFilter(entityType.getMainOrg(), "in", (Object)result.getHasPermOrgs());
    }

    public static String getBizAppId(String entityNumber) {
        QFilter[] filterArray;
        DynamicObject formDynamic;
        String bizAppIdStr = "";
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        PermissionDimension permissionDimension = entityMetadata.getRootEntity().getPermissionDimension();
        if (Objects.nonNull(permissionDimension) && HRStringUtils.isNotEmpty((String)permissionDimension.getPublishApps())) {
            String appString = permissionDimension.getPublishApps().replace("[", "").replace("]", "").replace("\"", "");
            bizAppIdStr = appString.split(",")[0];
        }
        if (HRStringUtils.isEmpty((String)bizAppIdStr) && Objects.nonNull(formDynamic = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])(filterArray = new QFilter[]{new QFilter("number", "=", (Object)entityNumber)})))) {
            String formId = formDynamic.getString("id");
            bizAppIdStr = formDynamic.getString("bizappid");
            if (HRStringUtils.isEmpty((String)bizAppIdStr)) {
                bizAppIdStr = DataValidateServiceHelper.getAppIdByFormId(formId);
            }
        }
        return bizAppIdStr;
    }

    private static String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])filters);
        String bizAppId = unitRelForm.getString("bizapp");
        return bizAppId;
    }
}

