/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.entity.FieldStyle;
import org.apache.commons.lang3.StringUtils;

public class FieldStyleServiceHelper {
    public static final String KEY_SYSTEM_PARAM = "hies_diaesysparam";
    public static final String KEY_TEM_CONF = "hies_diaetplconf";

    public static JSONObject getGlobalFieldStyle() {
        return FieldStyleServiceHelper.getDefaultStyle();
    }

    public static JSONObject getCustomFieldStyle(String templateNumber) {
        String returnStyle = "";
        Long templateId = 0L;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FieldStyleServiceHelper_getCustomFieldStyle()", (String)KEY_TEM_CONF, (String)"id,fieldstyle", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)templateNumber)}, null);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            returnStyle = next.getString("fieldstyle");
            templateId = next.getLong("id");
        }
        if (StringUtils.isBlank((CharSequence)returnStyle)) {
            return FieldStyleServiceHelper.convertGlobalStyleToCustom(FieldStyleServiceHelper.getGlobalFieldStyle(), templateId);
        }
        return JSONObject.parseObject((String)returnStyle);
    }

    public static JSONObject getDefaultStyle() {
        JSONObject fieldStyleMap = new JSONObject();
        FieldStyle headerFieldStyle = new FieldStyle();
        headerFieldStyle.setFontSize("11pt");
        headerFieldStyle.setFontFamily("Calibri");
        headerFieldStyle.setBackgroundColor("#c0c0c0ff");
        fieldStyleMap.put("header", (Object)headerFieldStyle);
        FieldStyle contentFieldStyle = new FieldStyle();
        contentFieldStyle.setFontSize("11pt");
        contentFieldStyle.setFontFamily(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"FieldStyleServiceHelper_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        fieldStyleMap.put("content", (Object)contentFieldStyle);
        return fieldStyleMap;
    }

    public static JSONObject convertGlobalStyleToCustom(JSONObject globalFieldStyle, Long templateId) {
        HashMap<String, Map> returnStyle = new HashMap<String, Map>(16);
        String sql = "select fchildentityid,ffieldnumber from t_hies_diaetplfieldconf where fid = ? and fisimport = '1'";
        DataSet dataSet = DB.queryDataSet((String)"FieldStyleServiceHelper_convertGlobalStyleToCustom()", (DBRoute)new DBRoute("hmp"), (String)sql, (Object[])new Object[]{templateId});
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String entityNum = next.getString(0);
            Map map = returnStyle.getOrDefault(entityNum, new HashMap());
            map.put(next.getString(1), globalFieldStyle);
            returnStyle.put(entityNum, map);
        }
        return JSONObject.parseObject((String)JSONObject.toJSONString(returnStyle));
    }

    public static JSONObject getCustomFieldMerge(String templateNumber) {
        String returnMerge = "";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FieldStyleServiceHelper_getCustomFieldMerge", (String)KEY_TEM_CONF, (String)"fieldmerge", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)templateNumber)}, null);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            returnMerge = next.getString("fieldmerge");
        }
        return JSONObject.parseObject((String)returnMerge);
    }
}

