/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.OrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;

public class ImportServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ImportServiceHelper.class);

    public static Map<Object, DynamicObject> analysisComposeDataNewOrUpdate(List<ImportBillData> billDataList, Map<String, Map<String, DynamicObject>> tplFieldConfig, Map<String, List<String>> uniqueKeyFieldsMap, Set<ImportBillData> noAdaptBilldatas, Set<ImportBillData> dbRepeatBilldatas, boolean serialModel, IndImportStart importStart) {
        HashMap existsDysMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)6);
        for (int i = 0; i < billDataList.size(); ++i) {
            ImportBillData billData = billDataList.get(i);
            billData.getData().put("$groupId", (Object)UUID.randomUUID().toString());
            for (Map.Entry next : billData.getData().entrySet()) {
                if (((String)next.getKey()).equalsIgnoreCase("$groupId")) continue;
                ArrayList<ImportBillData> listdata = (ArrayList<ImportBillData>)groupMap.get(next.getKey());
                if (CollectionUtils.isEmpty((Collection)listdata)) {
                    listdata = new ArrayList<ImportBillData>(billDataList.size());
                    groupMap.put(next.getKey(), listdata);
                }
                List<ImportBillData> childBillDatas = ImportServiceHelper.splitImportBillData(billData, (String)next.getKey());
                listdata.addAll(childBillDatas);
            }
        }
        HashMap groupIdMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        for (Map.Entry next : groupMap.entrySet()) {
            Map<Object, DynamicObject> longDynamicObjectMap = ImportServiceHelper.analysisSimpleDataNewOrUpdate((List)next.getValue(), tplFieldConfig, uniqueKeyFieldsMap, noAdaptBilldatas, dbRepeatBilldatas, serialModel, importStart);
            for (ImportBillData bd : (List)next.getValue()) {
                LinkedList<ImportBillData> dblist = (LinkedList<ImportBillData>)groupIdMap.get(bd.getData().get((Object)"$groupId"));
                if (dblist == null) {
                    dblist = new LinkedList<ImportBillData>();
                    groupIdMap.put((String)bd.getData().get((Object)"$groupId"), dblist);
                }
                dblist.add(bd);
            }
            existsDysMap.putAll(longDynamicObjectMap);
        }
        billDataList.forEach(data -> {
            List childList = (List)groupIdMap.get(data.getData().get((Object)"$groupId"));
            childList.forEach(item -> {
                if (item.getMainEntityId().equalsIgnoreCase(data.getMainEntityId())) {
                    data.setOpType(item.getOpType());
                    data.setPkId(item.getPkId());
                    data.getData().getJSONObject(data.getMainEntityId()).put("id", item.getPkId());
                } else {
                    JSONArray jsonArray = data.getData().getJSONArray(item.getMainEntityId());
                    Iterator iterator1 = jsonArray.stream().iterator();
                    while (iterator1.hasNext()) {
                        JSONObject next = (JSONObject)iterator1.next();
                        if (item.getData().getString("$itemId").equals(next.getString("$itemId"))) {
                            next.put("$opType", (Object)item.getOpType());
                            next.put("id", item.getPkId());
                        }
                        next.remove((Object)"$itemId");
                    }
                }
            });
            data.getData().remove((Object)"$groupId");
        });
        return existsDysMap;
    }

    public static Map<Object, DynamicObject> analysisSimpleDataNewOrUpdate(List<ImportBillData> billDataList, Map<String, Map<String, DynamicObject>> tplFieldConfig, Map<String, List<String>> uniqueKeyFieldsMap, Set<ImportBillData> noAdaptBilldatas, Set<ImportBillData> dbRepeatBilldatas, boolean serialModel, IndImportStart importStart) {
        if (billDataList == null || billDataList.size() == 0) {
            return null;
        }
        boolean isDeleteOpType = "delete".equals(billDataList.get(0).getOpType());
        HashMap existsDysMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        Map<String, List<ImportBillData>> sheetGroupDataList = billDataList.stream().collect(Collectors.groupingBy(ImportBillData::getMainEntityId));
        sheetGroupDataList.forEach((entityId, sheetDataList) -> {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            List entryList = mainEntityType.getAllEntities().entrySet().stream().filter(entry -> entry.getValue() instanceof EntryType).map(Map.Entry::getKey).collect(Collectors.toList());
            HashMap uniqueValMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
            ArrayList uniqueKeyBuilder = Lists.newArrayListWithExpectedSize((int)billDataList.size());
            ArrayList qFilterList = Lists.newArrayListWithCapacity((int)sheetDataList.size());
            sheetDataList.forEach(rowData -> {
                QFilter tempQFilter = null;
                JSONObject rowDataJson = rowData.getData().getJSONObject(entityId);
                StringBuilder uniqueValBuilder = new StringBuilder();
                List uniqueKeyFields = (List)uniqueKeyFieldsMap.get(entityId);
                for (String key : uniqueKeyBuilder) {
                    Object objectValue = mainEntityType.getProperty(key) instanceof MuliLangTextProp ? ImportServiceHelper.getObjectValue(rowDataJson, key.concat(".").concat(Lang.get().toString())) : ImportServiceHelper.getObjectValue(rowDataJson, key);
                    if (tempQFilter == null) {
                        tempQFilter = new QFilter(key, "=", objectValue);
                    } else {
                        tempQFilter.and(new QFilter(key, "=", objectValue));
                    }
                    uniqueValBuilder.append(objectValue);
                }
                qFilterList.add(tempQFilter);
                if (!uniqueValMap.containsKey(uniqueValBuilder.toString())) {
                    uniqueValMap.put(uniqueValBuilder.toString(), rowData);
                }
            });
            List<DynamicObject[]> listDys = ImportServiceHelper.smartLoadDynamicObjectArray(entityId, qFilterList);
            HashSet existsUniqueVal = Sets.newHashSetWithExpectedSize((int)1000);
            uniqueValMap.forEach((key, value) -> {
                if (!existsUniqueVal.contains(key)) {
                    if (isDeleteOpType) {
                        value.setOpType("delete");
                    } else {
                        value.setOpType("new");
                    }
                    noAdaptBilldatas.add((ImportBillData)value);
                }
            });
        });
        return existsDysMap;
    }

    private static void checkEntryIdExists(IndImportStart importStart, String entityId, List<String> entryList, DynamicObject dy, ImportBillData importBillData) {
        entryList.stream().filter(entryNum -> importBillData.getData().getJSONObject(entityId).containsKey(entryNum)).forEach(entryNum2 -> {
            DynamicObjectCollection entryCollection = dy.getDynamicObjectCollection(entryNum2);
            JSONArray jsonArray = importBillData.getData().getJSONObject(entityId).getJSONArray(entryNum2);
            if (jsonArray != null) {
                jsonArray.forEach(jsonOb -> {
                    try {
                        Long aLong = ((JSONObject)jsonOb).getLong(entryNum2 + "_id");
                        if (aLong == null && importBillData.getOpType().equals("updateandnew")) {
                            return;
                        }
                        if (entryCollection.size() == 0 || entryCollection.stream().noneMatch(dyTemp -> dyTemp.getLong("id") == aLong.longValue())) {
                            DataValidateServiceHelper.writeRowErrorLog(20, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), ((JSONObject)jsonOb).getIntValue("$excelIndex"), ((JSONObject)jsonOb).getIntValue("$excelIndex"), ((JSONObject)jsonOb).getIntValue("$excelIndex"), new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.info("ImportServiceHelper.checkEntryIdExists(),error:{}", (Object)exception.getMessage());
                        DataValidateServiceHelper.writeRowErrorLog(20, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), ((JSONObject)jsonOb).getIntValue("$excelIndex"), ((JSONObject)jsonOb).getIntValue("$excelIndex"), ((JSONObject)jsonOb).getIntValue("$excelIndex"), new Object[0]);
                    }
                });
            }
        });
    }

    private static List<ImportBillData> splitImportBillData(ImportBillData data, String entityId) {
        Object groupId = data.getData().get((Object)"$groupId");
        LinkedList<ImportBillData> list = new LinkedList<ImportBillData>();
        Object sourceobj = data.getData().get((Object)entityId);
        if (sourceobj instanceof JSONObject) {
            ImportBillData newbill = ImportServiceHelper.createNewImportBillData(data, entityId);
            JSONObject newobj = new JSONObject();
            newobj.put(entityId, sourceobj);
            newobj.put("$groupId", groupId);
            newbill.setData(newobj);
            list.add(newbill);
        } else if (sourceobj instanceof JSONArray) {
            JSONArray sour = (JSONArray)sourceobj;
            for (Object so : sour) {
                JSONObject next = (JSONObject)so;
                next.put("$itemId", (Object)UUID.randomUUID().toString());
                ImportBillData newbill = ImportServiceHelper.createNewImportBillData(data, entityId);
                JSONObject newobj = new JSONObject();
                newobj.put(entityId, (Object)next);
                newobj.put("$groupId", groupId);
                newobj.put("$itemId", next.get((Object)"$itemId"));
                newbill.setData(newobj);
                list.add(newbill);
            }
        }
        return list;
    }

    private static ImportBillData createNewImportBillData(ImportBillData data, String entityId) {
        ImportBillData newbill = new ImportBillData();
        newbill.setOpType(null);
        newbill.setBillIndex(data.getBillIndex());
        newbill.setEndIndex(data.getEndIndex());
        newbill.setMainEntityId(entityId);
        newbill.setSheetName(data.getSheetName());
        newbill.setStartIndex(data.getStartIndex());
        return newbill;
    }

    public static Object getObjectValue(JSONObject rowDataJson, String key) {
        String[] split;
        Object value = key.contains(".") ? (rowDataJson.getJSONObject((split = key.split("\\."))[0]) == null ? "" : rowDataJson.getJSONObject(split[0]).get((Object)split[1])) : rowDataJson.get((Object)key);
        return value;
    }

    public static List<QFilter> getDefaultQFilter(String basedataEntityId, boolean isAllowDisableData) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (ImportServiceHelper.hasHis(basedataEntityId)) {
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        if (ImportServiceHelper.hasEnable(basedataEntityId) && !isAllowDisableData) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (ImportServiceHelper.hasInitstatus(basedataEntityId)) {
            qFilters.add(new QFilter("initstatus", "=", (Object)"2"));
        }
        return qFilters;
    }

    private static boolean hasInitstatus(String basedataEntityId) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)basedataEntityId);
        return mainType.getProperties().stream().filter(field -> StringUtils.isNotBlank((CharSequence)field.getAlias())).map(IMetadata::getName).anyMatch(pro -> pro.equals("initstatus"));
    }

    private static boolean hasEnable(String basedataEntityId) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)basedataEntityId);
        return mainType.getProperties().stream().filter(field -> StringUtils.isNotBlank((CharSequence)field.getAlias())).map(IMetadata::getName).anyMatch(pro -> pro.equals("enable"));
    }

    public static boolean hasHis(String basedataEntityId) {
        String entityType = HisCommonService.getInstance().entityInhRelation(basedataEntityId);
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    public static Map<String, String> getCountries() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query("bd_country", "id,number,areacode,twocountrycode", new QFilter[]{new QFilter("enable", "=", (Object)"1")}, "id asc");
        HashMap<String, String> countries = new HashMap<String, String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            countries.put(dynamicObject.getString("areacode"), dynamicObject.getString("number"));
            countries.put(dynamicObject.getString("twocountrycode"), dynamicObject.getString("number"));
        }
        return countries;
    }

    public static Object getPutWhereKey(JSONObject valueJson, String baseDataFormatValue, Map<String, Object> bdFieldMainPropName) {
        if (valueJson == null) {
            return "";
        }
        if ("number_name".equalsIgnoreCase(baseDataFormatValue)) {
            String realNumber = (String)bdFieldMainPropName.get("number");
            String realName = (String)bdFieldMainPropName.get("name");
            return valueJson.getOrDefault((Object)realNumber, (Object)"").toString() + valueJson.getOrDefault((Object)"$bdSplit", (Object)"").toString() + valueJson.getOrDefault((Object)realName, (Object)"").toString();
        }
        Object val = bdFieldMainPropName.get(baseDataFormatValue);
        if (val instanceof String) {
            String realProName = (String)val;
            return valueJson.getString(realProName);
        }
        if (val instanceof LongProp) {
            return Long.parseLong(valueJson.getString("id"));
        }
        if (val instanceof TextProp) {
            return valueJson.getString("id");
        }
        return null;
    }

    public static DynamicObject[] loadDynamicObjects(List<Object> ids, String enitynumber) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)enitynumber);
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)type);
    }

    public static HasPermOrgResult getEntityHasPermOrg(String enitytId, String appId) {
        String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)enitytId);
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)enitytId, (String)"47150e89000000ac");
    }

    public static boolean checkOrgFunction(Long orgID, String orgFunction) {
        OrgService service = new OrgService();
        return service.checkOrgFunction(orgID, orgFunction);
    }

    public static QFilter getMainOrgQfilter(HasPermOrgResult orgPers) {
        return new QFilter("id", "in", (Object)orgPers.getHasPermOrgs());
    }

    public static QFilter getDataRuleForBdProp(String enitytId, String appid, String permItemId, IDataEntityProperty prop) {
        return DataValidateServiceHelper.getDataRuleForBdProp(enitytId, appid, prop.getName(), permItemId);
    }

    private static List<DynamicObject[]> smartLoadDynamicObjectArray(String entityId, List<QFilter> qFilterList) {
        LinkedList<DynamicObject[]> listDys = new LinkedList<DynamicObject[]>();
        List<Object> temps = ImportServiceHelper.parseQFilter(qFilterList);
        QFilter qFilter = null;
        if (CollectionUtils.isNotEmpty(temps)) {
            qFilter = new QFilter(qFilterList.get(0).getProperty(), "in", temps);
        } else {
            for (QFilter qf : qFilterList) {
                if (qFilter == null) {
                    qFilter = qf.copy();
                    continue;
                }
                qFilter.or(qf);
            }
        }
        if (qFilter == null) {
            qFilter = new QFilter("1", "!=", (Object)1);
        }
        ArrayList<QFilter> tempList = new ArrayList<QFilter>(2);
        tempList.add(qFilter);
        if (ImportServiceHelper.hasHis(entityId)) {
            QFilter isCurQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            tempList.add(isCurQFilter);
        }
        try {
            DynamicObject[] dynamicObjects = new HRBaseServiceHelper(entityId).loadDynamicObjectArray(tempList.toArray(new QFilter[0]));
            listDys.add(dynamicObjects);
        }
        catch (Throwable e) {
            LOGGER.info("smartLoadDynamicObjectArray_qFilterList.size=" + qFilterList.size());
            if (qFilterList.size() < 100) {
                throw e;
            }
            List<List<QFilter>> averageAssignList = MethodUtil.averageAssign(qFilterList, 2);
            averageAssignList.forEach(list -> {
                List<DynamicObject[]> subDys = ImportServiceHelper.smartLoadDynamicObjectArray(entityId, list);
                listDys.addAll(subDys);
            });
        }
        return listDys;
    }

    private static List<Object> parseQFilter(List<QFilter> qFilterList) {
        LinkedList<Object> temps = new LinkedList<Object>();
        if (qFilterList.get(0).getNests(true).size() == 0) {
            qFilterList.forEach(qFilter -> temps.add(qFilter.getValue()));
        }
        return temps;
    }

    public static boolean isBuBaseData(String entityId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"useorg");
        boolean isBuBd = property instanceof OrgProp;
        return isBuBd;
    }

    public static void setUseOrgFieldValue(DynamicObject[] dynamicObjects) {
        for (DynamicObject dy : dynamicObjects) {
            if (dy.get("useorg") != null) continue;
            dy.set("useorg", dy.get("createorg"));
        }
    }
}

