/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.log;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.util.CollectionUtils;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="\u6570\u636e\u5f15\u5165\u9519\u8bef\u65e5\u5fd7")
public class ImportLog {
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = new ConcurrentHashMap(1);
    private ConcurrentHashMap<Integer, String> errorInfos = new ConcurrentHashMap(16);
    private ConcurrentHashMap<String, Set<Integer>> emptyRowIndex = new ConcurrentHashMap(1);
    private List<String> errorLogs = new LinkedList<String>();

    @SdkInternal
    public ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> getRowErrors() {
        return this.rowErrors;
    }

    @SdkInternal
    public void setRowErrors(ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors) {
        this.rowErrors = rowErrors;
    }

    @SdkInternal
    public ConcurrentHashMap<String, Set<Integer>> getEmptyRowIndex() {
        return this.emptyRowIndex;
    }

    @SdkInternal
    public void addEmptyRowIndex(String sheetName, Set<Integer> emptyRowIndex) {
        this.emptyRowIndex.put(sheetName, emptyRowIndex);
    }

    public void writeRowLog(String sheetName, int startIndex, int endIndex, String msg) {
        this.writeRowLog(new ImportRowErrorLog(sheetName, startIndex, endIndex, msg, this));
    }

    public void writeRowLog(String sheetName, int startIndex, int endIndex, int errorIndex, String msg) {
        this.writeRowLog(new ImportRowErrorLog(sheetName, startIndex, endIndex, errorIndex, msg, this));
    }

    @SdkInternal
    public void writeRowLog(ImportRowErrorLog errorLog) {
        errorLog.setImportLog(this);
        if (CollectionUtils.isEmpty(errorLog.getMsgHashCode())) {
            return;
        }
        ConcurrentHashMap logMap = this.rowErrors.computeIfAbsent(errorLog.getSheetName(), val -> new ConcurrentHashMap());
        ImportRowErrorLog log = (ImportRowErrorLog)logMap.get(errorLog.getErrorIndex());
        if (log != null) {
            log.getMsgHashCode().addAll(errorLog.getMsgHashCode());
        } else {
            logMap.put(errorLog.getErrorIndex(), errorLog);
        }
    }

    @SdkInternal
    public List<String> getErrorLogs() {
        return this.errorLogs;
    }

    @SdkInternal
    public ConcurrentHashMap<Integer, String> getErrorInfos() {
        return this.errorInfos;
    }
}

