/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.log;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.opmc.epa.business.domain.indicator.imp.constant.IndConstant;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;

public class ImportRowErrorLog
implements Serializable {
    private static final long serialVersionUID = 8537879060759292506L;
    private static Log log = LogFactory.getLog(ImportRowErrorLog.class);
    @JsonIgnore
    @JSONField(serialize=false)
    private String sheetName;
    @JsonIgnore
    @JSONField(serialize=false)
    private int startIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private int endIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private int errorIndex;
    @JsonIgnore
    @JSONField(serialize=false)
    private ImportLog importLog;
    private List<Integer> msgHashCode;

    public ImportRowErrorLog() {
    }

    public ImportRowErrorLog(String sheetName, int startIndex, int endIndex, String msg, ImportLog importLog) {
        this.initImportRowErrorLog(sheetName, startIndex, endIndex, startIndex, msg, importLog);
    }

    public ImportRowErrorLog(String sheetName, int startIndex, int endIndex, int errorIndex, String msg, ImportLog importLog) {
        this.initImportRowErrorLog(sheetName, startIndex, endIndex, errorIndex, msg, importLog);
    }

    public static String getExceptionInfoWithSys(Throwable throwable) {
        try {
            boolean showStackTrace = SystemParamServiceHelper.isShowStackTrace();
            if (showStackTrace) {
                return CommonUtil.formatException(throwable);
            }
            String importErrMsg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportRowErrorLog_0", (String)"opmc-epa-business", (Object[])new Object[0]);
            return importErrMsg;
        }
        catch (Throwable e) {
            log.error(e);
            return null;
        }
    }

    public ImportLog getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLog importLog) {
        this.importLog = importLog;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public String getMsg() {
        List<Integer> msgHashCode = this.getMsgHashCode();
        if (CollectionUtils.isEmpty(msgHashCode)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        List<Integer> collect = msgHashCode.stream().distinct().collect(Collectors.toList());
        collect.forEach(code -> {
            String info = this.importLog.getErrorInfos().get(code);
            builder.append(info).append(IndConstant.LINE_SEPARATOR);
        });
        return builder.toString();
    }

    public void setMsg(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        int hashCode = msg.hashCode();
        log.info("===hashCode==={}=======", (Object)hashCode);
        String errorInfo = this.importLog.getErrorInfos().get(hashCode);
        log.info("===errorInfo==={}=======", (Object)errorInfo);
        if (StringUtils.isEmpty((String)errorInfo)) {
            this.importLog.getErrorInfos().put(hashCode, msg);
        }
        this.getMsgHashCode().add(hashCode);
    }

    public List<Integer> getMsgHashCode() {
        return this.msgHashCode;
    }

    public void setMsgHashCode(List<Integer> msgHashCode) {
        this.msgHashCode = msgHashCode;
    }

    private final void initImportRowErrorLog(String sheetName, int startIndex, int endIndex, int errorIndex, String msg, ImportLog importLog) {
        this.sheetName = sheetName;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.errorIndex = errorIndex;
        this.importLog = importLog;
        this.msgHashCode = new LinkedList<Integer>();
        this.setMsg(msg);
    }
}

