/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.save;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.STConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;

public class DataConvertDynamicObject {
    private static Log log = LogFactory.getLog(DataConvertDynamicObject.class);
    public static final String NO_CACHE_ERROR = "can not find dynamicObject from cache";
    protected IndImportStart importStart;
    private IndSaveOpDispatcher dispatcher;
    protected String importtype;

    public DataConvertDynamicObject(IndImportStart importStart, IndSaveOpDispatcher dispatcher) {
        this.importStart = importStart;
        this.dispatcher = dispatcher;
        this.importtype = this.importStart.getImportContext().getOpType();
    }

    public DynamicObject[] toDynamicObject(List<ImportBillData> tempBilldatas, String groupType, DynamicObject blankDynamicObject) {
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(tempBilldatas.size());
        if ("new".equals(this.importtype) || "new".equals(groupType)) {
            long[] ids = DB.genGlobalLongIds((int)tempBilldatas.size());
            for (int i = 0; i < tempBilldatas.size(); ++i) {
                DynamicObject newDynamicObject;
                ImportBillData data = tempBilldatas.get(i);
                if (null == data.getPkId()) {
                    data.setPkId(ids[i]);
                }
                if ((newDynamicObject = this.createNewDynamicObject(data, blankDynamicObject)) == null) continue;
                this.setInstanceId(data, newDynamicObject);
                billObjs.add(newDynamicObject);
            }
        } else if ("update".equals(this.importtype) || "update".equals(groupType)) {
            List<DynamicObject> updateDatas = this.createUpdateDynamicObject(tempBilldatas);
            billObjs.addAll(updateDatas);
        } else if ("updateandnew".equals(this.importtype)) {
            List<ImportBillData> updateBillDatas;
            Map groupBilldatas = tempBilldatas.stream().collect(Collectors.groupingBy(item -> item.getOpType(), Collectors.toList()));
            List<ImportBillData> billDatas = groupBilldatas.get("new");
            if (CollectionUtils.isNotEmpty(billDatas)) {
                DynamicObject[] newDynamicObjects = this.toDynamicObject(billDatas, "new", blankDynamicObject);
                billObjs.addAll(Arrays.asList(newDynamicObjects));
            }
            if (CollectionUtils.isNotEmpty(updateBillDatas = groupBilldatas.get("update"))) {
                DynamicObject[] updateDynamicObjects = this.toDynamicObject(updateBillDatas, "update", blankDynamicObject);
                billObjs.addAll(Arrays.asList(updateDynamicObjects));
            }
        }
        return billObjs.toArray(new DynamicObject[0]);
    }

    private void setInstanceId(ImportBillData data, DynamicObject newDynamicObject) {
        Map<String, Object> objectMap;
        String sheetName = data.getSheetName();
        Map<String, Map<String, Object>> areaConfigMap = this.importStart.getImportContext().getAreaConfigMap();
        if (areaConfigMap != null && (objectMap = areaConfigMap.get(sheetName)) != null) {
            newDynamicObject.set("instanceid", objectMap.get("areainstance"));
        }
    }

    public List<DynamicObject> createUpdateDynamicObject(List<ImportBillData> tempBilldatas) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(tempBilldatas.size());
        Map<Object, Object> map = null;
        if (this.importStart.getImportContext().isSerialModel()) {
            DynamicObject[] dynamicObjects;
            map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
            List<Object> ids = tempBilldatas.stream().map(de -> de.getPkId()).collect(Collectors.toList());
            for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, tempBilldatas.get(0).getMainEntityId())) {
                map.put(oldBill.getPkValue(), oldBill);
            }
        } else {
            map = this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap();
        }
        for (ImportBillData data : tempBilldatas) {
            DynamicObject oldBill = (DynamicObject)map.get(data.getPkId());
            map.remove(data.getPkId());
            List<String> errors = this.setValues(oldBill, data);
            if (CollectionUtils.isEmpty(errors)) {
                list.add(oldBill);
                continue;
            }
            for (String error : errors) {
                ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                this.importStart.writeRowErrorLog(errResult);
            }
        }
        return list;
    }

    public DynamicObject createNewDynamicObject(ImportBillData data, DynamicObject blankDynamicObject) {
        OperationResult result = new OperationResult();
        DynamicObject newBill = null;
        try {
            newBill = (DynamicObject)OrmUtils.clone((IDataEntityBase)blankDynamicObject, (boolean)false, (boolean)true);
            List<String> errors = this.setValues(newBill, data);
            newBill.set("id", data.getPkId());
            if (CollectionUtils.isEmpty(errors)) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                for (String error : errors) {
                    ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                    this.importStart.writeRowErrorLog(errResult);
                }
            }
        }
        catch (Throwable e) {
            log.error("DataConvertDynamicObject_createNewDynamicObject exception.", e);
            result.setSuccess(false);
            result.setMessage(ImportRowErrorLog.getExceptionInfoWithSys(e));
        }
        if (!result.isSuccess() && StringUtils.isNotBlank((CharSequence)result.getMessage())) {
            ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), result.getMessage(), this.importStart.getImportContext().getImportLog());
            this.importStart.writeRowErrorLog(errResult);
        }
        if (result.isSuccess()) {
            return newBill;
        }
        return null;
    }

    protected List<String> setValues(DynamicObject bill, ImportBillData importBillData) {
        LinkedList<String> errors = new LinkedList<String>();
        DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
        JSONObject jsonObject1 = importBillData.getData().getJSONObject(bill.getDataEntityType().getName());
        for (Map.Entry next : jsonObject1.entrySet()) {
            Object prop = properties.get(next.getKey());
            if (ObjectUtils.isEmpty((Object)prop)) continue;
            try {
                Object propValue = this.getPropValue(prop, (String)next.getKey(), next.getValue(), bill, importBillData.getOpType());
                bill.set((String)next.getKey(), propValue);
            }
            catch (Throwable e) {
                log.error("DataConvertDynamicObject_setValues exception.", e);
                errors.add(ImportRowErrorLog.getExceptionInfoWithSys(e));
            }
        }
        return errors;
    }

    private Object getPropValue(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        if (this.importStart.getImportContext().isSerialModel()) {
            return this.getPropValueUsedBySerialModel(prop, key, val, bill, opType);
        }
        return this.getPropValueUsedByConcurrentModel(prop, key, val, bill, opType);
    }

    private Object getPropValueUsedBySerialModel(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        Object commonPropValue = this.getCommonPropValue(prop, key, val, bill, opType);
        if (commonPropValue != null) {
            return commonPropValue;
        }
        if (prop instanceof DateProp || prop instanceof DateTimeProp) {
            Timestamp timestamp = new Timestamp((Long)val);
            return timestamp;
        }
        if (prop instanceof TimeProp) {
            return LocalTime.parse((String)val);
        }
        return val;
    }

    private Object getPropValueUsedByConcurrentModel(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        Object commonPropValue = this.getCommonPropValue(prop, key, val, bill, opType);
        if (commonPropValue != null) {
            return commonPropValue;
        }
        if (prop instanceof BigDecimal) {
            BigDecimal bigDecimal = new BigDecimal((String)val);
            return bigDecimal;
        }
        if (prop instanceof TimeProp) {
            LocalTime localTime = (LocalTime)val;
            return localTime.getHour() * 60 * 60 + localTime.getMinute() * 60 + localTime.getSecond();
        }
        return val;
    }

    private Object getCommonPropValue(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        if (prop instanceof BasedataProp) {
            List<DynamicObject> basedataentity;
            JSONObject map = (JSONObject)val;
            Object id = map.get((Object)"id");
            if (ObjectUtils.isEmpty((Object)id)) {
                return null;
            }
            if (id instanceof Integer) {
                id = ((Integer)id).longValue();
            }
            if (CollectionUtils.isEmpty(basedataentity = this.importStart.getImportContext().getBaseDataContainer().getBasedataIdTable(map.getString("$basedataentity"), id))) {
                log.info("basedata_not_find,map=" + map.toJSONString());
                throw new KDBizException("basedata not find.");
            }
            return basedataentity.get(0);
        }
        if (prop instanceof MulBasedataProp) {
            MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection();
            DynamicObjectType dynamicCollectionItemPropertyType = ((MulBasedataProp)prop).getDynamicCollectionItemPropertyType();
            JSONArray items = (JSONArray)val;
            ListIterator objectListIterator = items.listIterator();
            while (objectListIterator.hasNext()) {
                JSONObject next = (JSONObject)objectListIterator.next();
                String key0 = next.getString("$basedataentity");
                if (StringUtils.isEmpty((CharSequence)key0)) continue;
                DynamicObject entryitem = new DynamicObject(dynamicCollectionItemPropertyType);
                List<DynamicObject> basedataentity = this.importStart.getImportContext().getBaseDataContainer().getBasedataIdTable(next.getString("$basedataentity"), next.get((Object)"id"));
                if (CollectionUtils.isEmpty(basedataentity)) {
                    log.info("basedata_not_find,next=" + next.toJSONString());
                    throw new KDBizException("basedata not find.");
                }
                entryitem.set("fbasedataid", (Object)basedataentity.get(0));
                entryitem.set("fbasedataid_id", basedataentity.get(0).getPkValue());
                collection.add(entryitem);
            }
            return collection;
        }
        if (prop instanceof ComboProp) {
            if (prop instanceof MulComboProp) {
                String temp = (String)val;
                String[] split = temp.split(",");
                ArrayList list = new ArrayList(split.length);
                for (String item : split) {
                    Map itemsMap = (Map)this.dispatcher.getComboItems().get((Object)this.findTopParentId(bill), (Object)key);
                    list.add(itemsMap.get(item));
                }
                return String.join((CharSequence)",", list);
            }
            Map itemsMap = (Map)this.dispatcher.getComboItems().get((Object)this.findTopParentId(bill), (Object)key);
            String combo = (String)itemsMap.get(val);
            return combo;
        }
        if (prop instanceof MuliLangTextProp) {
            if (val instanceof JSONObject) {
                JSONObject map = (JSONObject)val;
                ILocaleString localeString = bill.getLocaleString(key);
                for (Map.Entry next : map.entrySet()) {
                    localeString.setItem((String)next.getKey(), (Object)((String)next.getValue()));
                }
                if ("new".equalsIgnoreCase(opType) && StringUtils.isBlank((CharSequence)localeString.getLocaleValue_zh_TW()) && StringUtils.isNotBlank((CharSequence)localeString.getLocaleValue_zh_CN())) {
                    String tw = STConverter.sc2tc((String)((String)map.get((Object)"zh_CN")));
                    localeString.setLocaleValue_zh_TW(tw);
                }
                return localeString;
            }
        } else if (prop instanceof EntryProp) {
            DynamicObjectCollection collection = null;
            HashMap oldEntryMap = Maps.newHashMapWithExpectedSize((int)16);
            if ("update".equalsIgnoreCase(opType)) {
                collection = bill.getDynamicObjectCollection(key);
                for (DynamicObject item : collection) {
                    oldEntryMap.put(item.getLong("id"), item);
                }
            } else {
                collection = new DynamicObjectCollection();
            }
            JSONArray entryEntity = (JSONArray)val;
            DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection properties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
            int seq = 1;
            ListIterator objectListIterator = entryEntity.listIterator();
            while (objectListIterator.hasNext()) {
                JSONObject next = (JSONObject)objectListIterator.next();
                DynamicObject entryitem = null;
                if ("update".equalsIgnoreCase(opType)) {
                    String entryid = (String)next.get((Object)(key + "_id"));
                    if (StringUtils.isNotBlank((CharSequence)entryid)) {
                        entryitem = (DynamicObject)oldEntryMap.get(Long.parseLong(entryid));
                        if (entryitem == null) {
                            continue;
                        }
                    } else {
                        entryitem = this.createNewEntryRow(dynamicCollectionItemPropertyType);
                    }
                } else {
                    entryitem = this.createNewEntryRow(dynamicCollectionItemPropertyType);
                }
                for (Map.Entry next1 : next.entrySet()) {
                    String key1 = (String)next1.getKey();
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key1);
                    if (ObjectUtils.isEmpty((Object)property)) continue;
                    Object propValue = this.getPropValue(property, key1, next1.getValue(), entryitem, opType);
                    entryitem.set((String)next1.getKey(), propValue);
                }
                if (entryitem.getLong("id") == 0L) {
                    collection.add((Object)entryitem);
                    entryitem.setParent((Object)bill);
                }
                entryitem.set("seq", (Object)seq);
                ++seq;
            }
            return collection;
        }
        return null;
    }

    private DynamicObject createNewEntryRow(DynamicObjectType type) {
        DynamicObject entryitem = new DynamicObject(type);
        type.getProperties().forEach(pro -> {
            if (pro instanceof TimeProp) {
                entryitem.set(pro.getName(), (Object)-1);
            }
        });
        return entryitem;
    }

    private String findTopParentId(DynamicObject dy) {
        IDataEntityType parent = dy.getDataEntityType().getParent();
        if (parent == null) {
            return dy.getDataEntityType().getName();
        }
        IDataEntityType parent1 = parent.getParent();
        if (parent1 == null) {
            return parent.getName();
        }
        IDataEntityType parent2 = parent1.getParent();
        if (parent2 == null) {
            return parent1.getName();
        }
        return "";
    }
}

