/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.api.HRImExptTaskServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.IndImportTaskDispatcher;
import kd.opmc.epa.business.domain.indicator.imp.constant.ImportCacheKeyType;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportFileUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndMonitor;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTempStoreDispatcher;

public class BigExcelImportTask
implements Callable<Object> {
    private static final Log logger = LogFactory.getLog(BigExcelImportTask.class);
    private AtomicInteger childThreadMonitor;
    private IndImportTaskDispatcher dispatcher;
    private Map<String, Object> params;

    public BigExcelImportTask(Map<String, Object> params, IndImportTaskDispatcher dispatcher, AtomicInteger childThreadMonitor) {
        this.childThreadMonitor = childThreadMonitor;
        this.dispatcher = dispatcher;
        this.params = params;
    }

    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        ImportContext importContext = new ImportContext();
        importContext.setRecoveryTask((Boolean)this.params.get("isRecoveryTask"));
        IndImportStart importStart = new IndImportStart(importContext);
        try {
            Long taskPkid = (Long)this.params.get("taskPkId");
            IndMonitor monitor = new IndMonitor(importStart);
            importStart.getWorkers().put(monitor.getName(), monitor);
            this.recordTraceLog(importStart, this.params, start);
            Object sourceRc = this.params.get("requestContext");
            if (sourceRc instanceof RequestContext) {
                RequestContext.set((RequestContext)((RequestContext)sourceRc));
            } else {
                RequestContext.set((RequestContext)((RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)));
            }
            MethodUtil.syncRequestTraceId(RequestContext.get());
            ConcurrentHashMap<String, Object> other = importStart.getMonitor().getImportTrace().getOther();
            other.put("traceId", RequestContext.get().getTraceId());
            logger.info("BigExcelImportTask_started!trace_id=" + RequestContext.get().getTraceId() + ",params=".concat(JSONObject.toJSONString(this.params)));
            importContext.setRc(RequestContext.get());
            importContext.setFilePath((String)this.params.get("fileUrl"));
            IndParser parser = new IndParser(importStart);
            importStart.getWorkers().put(parser.getName(), parser);
            this.asyncDownloadFile(importStart);
            importContext.setImportLog(new ImportLog());
            importContext.setTaskPkId(taskPkid);
            importContext.setExtOption(this.initExtOption(this.params, null));
            importContext.setSerialModel(this.initSerialModel(this.params.get("serialModel")));
            importContext.setAppId((String)this.params.get("appId"));
            importContext.setServiceAppId((String)this.params.get("ServiceAppId"));
            importContext.setMainFormId((String)this.params.get("formId"));
            importContext.setPageId((String)this.params.get("pageId"));
            Object fileSize = this.params.get("fileSize");
            importContext.setFileSize(Long.valueOf(String.valueOf(fileSize)));
            importContext.setFileName((String)this.params.get("fileName"));
            importContext.setSheetEntityMap((Map)JSONObject.parseObject((String)((String)this.params.get("sheetEntityMap")), Map.class));
            importContext.setAreaConfigMap((Map)this.params.get("areaConfigMap"));
            importContext.setSheetRowCountMap((Map)JSONObject.parseObject((String)((String)this.params.get("sheetCountRow")), Map.class));
            importContext.setEffectSheetNames((List)JSONObject.parseObject((String)((String)this.params.get("effectSheetNames")), List.class));
            importContext.setTotalRowCount((Integer)this.params.get("totalRow"));
            importContext.setFileType(importContext.getFilePath().substring(importContext.getFilePath().lastIndexOf(".")));
            importContext.setScoreCalcway(String.valueOf(this.params.get("scorecalcway")));
            importContext.setNumAccuracy(String.valueOf(this.params.get("numaccuracy")));
            importContext.setMaxScore((BigDecimal)this.params.get("maxscore"));
            importContext.setMinScore((BigDecimal)this.params.get("minscore"));
            importContext.setGroup(this.params.get("isgroup") != null && (Boolean)this.params.get("isgroup") != false);
            importContext.setIndicatorgroupid(this.params.get("indicatorgroupid") != null ? (Long)this.params.get("indicatorgroupid") : 0L);
            importContext.setActevalObjid(this.params.get("actevalObjid") != null ? (Long)this.params.get("actevalObjid") : 0L);
            importContext.setPageCustomParams(this.params);
            importStart.start();
            logger.info("==================importContext:{}===========", (Object)importContext);
            IHRAppCache cache = HRAppCache.get((String)"epa");
            cache.put(MethodUtil.getTaskCachePath(String.valueOf(importContext.getTaskPkId()), ImportCacheKeyType.IMPORT, "status"), (Object)"finished");
        }
        catch (InterruptedException e) {
            logger.error("BigExcelImportTask_recievered_InterruptedException", (Throwable)e);
            boolean sysTerminator = importContext.isSysTerminator();
            boolean userHasTerminator = importContext.isUserHasTerminator();
            importStart.getMonitor().getImportTrace().getOther().put("sysTerminator", sysTerminator);
            importStart.getMonitor().getImportTrace().getOther().put("userHasTerminator", userHasTerminator);
            if (sysTerminator || userHasTerminator && importStart != null) {
                importStart.end(false);
                IHRAppCache cache = HRAppCache.get((String)"epa");
                cache.put(MethodUtil.getTaskCachePath(String.valueOf(importContext.getTaskPkId()), ImportCacheKeyType.IMPORT, "status"), (Object)"stop");
                logger.info("BigExcelImportTask_user_normally_InterruptedException.");
            }
        }
        catch (Throwable e) {
            logger.error("BigExcelImportTask_recievered_Exception", e);
            if (importStart != null) {
                importStart.end(false);
            }
            importStart.writeErrorLog(e);
            throw new KDException(new ErrorCode("001", "BigExcelImportTask_start failed."), "", e);
        }
        finally {
            try {
                IndTempStoreDispatcher.hasExtentColum = false;
                importContext.getExtOption().put("userEndTime", System.currentTimeMillis());
                this.collectAppCacheData(importStart, start);
                HRImExptTaskServiceHelper.feedbackProgress((String)String.valueOf(importContext.getTaskPkId()), (int)100, (String)ImportCacheKeyType.IMPORT);
                importStart.getMonitor().addExpenseStatistics(BigExcelImportTask.class, (Long)(System.currentTimeMillis() - start), true);
                this.saveTaskInfo(importStart, start);
                this.childThreadMonitor.getAndDecrement();
                this.dispatcher.getChildThreadSemaphore().release();
                OperateLogService.commonWriteLog((String)importContext.getAppId(), (String)importContext.getMainFormId(), (String)"bigExcelImport", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f00\u59cb\u5f15\u5165", "BigExcelImportTask_0", "opmc-epa-business"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f15\u5165\u5b8c\u6210", "BigExcelImportTask_1", "opmc-epa-business"), (String[])new String[0]);
            }
            catch (Throwable e) {
                logger.error("BigExcelImportTask_finally_error.", e);
            }
        }
        return null;
    }

    private void collectAppCacheData(IndImportStart importStart, long start) {
        IndSaveOpDispatcher saveOpDispatcher = (IndSaveOpDispatcher)importStart.getWorkers().get(IndSaveOpDispatcher.class.getSimpleName());
        saveOpDispatcher.waiteChildFinished(saveOpDispatcher.getWorkerMaxThread());
        ImportContext importContext = importStart.getImportContext();
        int successedBillCount = importContext.getSuccessedBillCount().get();
        int finishedBillCount = importContext.getFinishedBillCount().get();
        int totalBillCount = importContext.getTotalBillCount();
        int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
        int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
        long spense = System.currentTimeMillis() - start;
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("spendTotalTime", String.valueOf(spense));
        customData.put("successedBillCount", String.valueOf(successedBillCount));
        customData.put("finishedBillCount", String.valueOf(finishedBillCount));
        customData.put("totalBillCount", String.valueOf(totalBillCount));
        customData.put("finishedValidateBillCount", String.valueOf(finishedValidateBillCount));
        customData.put("successedValidateBillCount", String.valueOf(successedValidateBillCount));
        customData.put("progress", 100);
        boolean isSysTerminator = importContext.isSysTerminator();
        customData.put("sysTerminator", isSysTerminator);
        boolean userTerminator = importContext.isUserHasTerminator();
        customData.put("userHasTerminator", userTerminator);
        customData.put("userStartTime", String.valueOf(importContext.getExtOption().get("userStartTime")));
        customData.put("userEndTime", String.valueOf(importContext.getExtOption().get("userEndTime")));
        IHRAppCache cache = HRAppCache.get((String)"epa");
        cache.put(MethodUtil.getTaskCachePath(String.valueOf(importStart.getImportContext().getTaskPkId()), ImportCacheKeyType.IMPORT, "result"), (Object)customData);
    }

    private Map<String, Object> initExtOption(Map<String, Object> map, DynamicObject tpl) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("userStartTime", map.get("userStartTime"));
        option.put("extParam", map.get("extParam"));
        option.put("callopStandExpense", 3000);
        option.put("disableRepeatDataValidator", false);
        option.put("submitOP", "save");
        return option;
    }

    private boolean initSerialModel(Object serialModel) {
        return !"concurrent".equals(serialModel);
    }

    private void saveTaskInfo(IndImportStart importStart, long start) {
        try {
            ImportContext importContext = importStart.getImportContext();
            Long starttime = (Long)importContext.getExtOption().get("userStartTime");
            Long endtime = (Long)importContext.getExtOption().get("userEndTime");
            boolean sysTerminator = importContext.isSysTerminator();
            boolean userHasTerminator = importContext.isUserHasTerminator();
            long spense = System.currentTimeMillis() - start;
            importStart.getMonitor().addExpenseStatistics("total", (Long)spense, true);
            int successedBillCount = importStart.getImportContext().getSuccessedBillCount().get();
            int finishedBillCount = importStart.getImportContext().getFinishedBillCount().get();
            int totalBillCount = importStart.getImportContext().getTotalBillCount();
            int totalRowCount = importStart.getImportContext().getTotalRowCount();
            int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
            int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
            HashMap<String, Integer> billCount = importStart.getMonitor().getImportTrace().getBillCount();
            billCount.put("totalRowCount", totalRowCount);
            billCount.put("totalBillCount", totalBillCount);
            billCount.put("successedBillCount", successedBillCount);
            billCount.put("finishedBillCount", finishedBillCount);
            billCount.put("finishedValidateBillCount", finishedValidateBillCount);
            billCount.put("successedValidateBillCount", successedValidateBillCount);
            importStart.getMonitor().getImportTrace().getOther().put("sheetDataSize", importStart.getImportContext().getSheetDataSizeMap());
            importStart.getMonitor().computeAverageExpense();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            Long startTime = (Long)importContext.getExtOption().get("userStartTime");
            Long endTime = (Long)importContext.getExtOption().get("userEndTime");
            Long taskPkId = importContext.getTaskPkId();
            params.put("totalAmount", importContext.getTotalBillCount());
            params.put("sucAmount", importContext.getSuccessedBillCount().get());
            params.put("startTime", startTime);
            params.put("endTime", endTime);
            params.put("systemErrLog", SerializationUtils.toJsonString(importContext.getImportLog().getErrorLogs()));
            HRImExptTaskServiceHelper.dealTaskResult((Long)taskPkId, params, (sysTerminator || userHasTerminator ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            logger.error("saveTaskInfo_exception.", e);
        }
    }

    private void initGlobalSysParam(ImportContext context) {
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        context.setSysParam(sysparam);
    }

    private void asyncDownloadFile(final IndImportStart importStart) throws InterruptedException {
        final ImportContext importContext = importStart.getImportContext();
        final IndParser parser = (IndParser)importStart.getWorkers().get(IndParser.class.getSimpleName());
        parser.getFileDownloadSemaphore().acquire();
        importStart.getPool().submit((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                long start = System.currentTimeMillis();
                logger.info("asyncDownloadFileTask_started.");
                try {
                    MethodUtil.syncRequestTraceId(RequestContext.get());
                    String localPatch = ImportFileUtil.downloadFile(importContext.getFilePath());
                    importContext.setFileLocalPath(localPatch);
                }
                catch (Throwable e) {
                    logger.error(e);
                    importStart.writeErrorLog(e);
                }
                finally {
                    parser.getFileDownloadSemaphore().release();
                    importStart.getMonitor().addExpenseStatistics("asyncDownloadFileTask", (Long)(System.currentTimeMillis() - start), true);
                }
                return null;
            }
        });
    }

    private void recordTraceLog(IndImportStart importStart, Map map, long startTime) {
        ConcurrentHashMap<String, Object> other = importStart.getMonitor().getImportTrace().getOther();
        other.put("taskExecuteTime", HRDateTimeUtils.format((Date)new Date(startTime)));
        other.put("sourceIp", map.get("sourceIp"));
        other.put("excuteIp", NetAddressUtils.getLocalIpAddress());
        other.put("isRecoveryTask", this.params.get("isRecoveryTask"));
        other.put("routeAppId", map.get("routeAppId"));
        other.put("taskPkId", map.get("taskPkId"));
        other.put("memoryConfig", MethodUtil.getMemoryConfig());
    }
}

