/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;

public class BillDataSizeAssessTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(BillDataSizeAssessTask.class);
    public static final long FILE_SIZE_THRESHOLD = 0x200000L;
    public static final int TOTAL_ROW_COUNT_THRESHOLD = 10000;
    public static final int COLLECT_BILL_DATA_THRESHOLD = 10;
    public static final String TOTAL_SIZE = "totalSize";
    public static final String TOTAL_COUNT = "totalCount";
    public static final String PER_SIZE = "perSize";
    private IndParser parser;
    private List<ImportBillData> tempBilldatas;
    private String sheetName;

    public BillDataSizeAssessTask(IndParser parser, List<ImportBillData> tempBilldatas) {
        this.parser = parser;
        this.sheetName = tempBilldatas.get(0).getSheetName();
        this.tempBilldatas = tempBilldatas;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        IndImportStart importStart = this.parser.getImportStart();
        MethodUtil.syncRequestTraceId(importStart.getImportContext().getRc());
        String name = BillDataSizeAssessTask.class.getSimpleName();
        log.info(name + "_started.");
        try {
            Integer totalRowCount = importStart.getImportContext().getSheetRowCountMap().get(this.sheetName);
            long start1 = System.currentTimeMillis();
            Map<String, Integer> stringIntegerMap = this.assessParse(this.tempBilldatas, totalRowCount);
            long end1 = System.currentTimeMillis() - start1;
            importStart.getMonitor().addExpenseStatistics("assessParse", (Long)end1, false);
            importStart.getImportContext().getSheetDataSizeMap().put(this.sheetName, stringIntegerMap);
            importStart.getMonitor().getImportTrace().getOther().put("sheetDataSize", importStart.getImportContext().getSheetDataSizeMap());
        }
        catch (Throwable e) {
            log.error(e);
            importStart.writeErrorLog(e);
        }
        long end = System.currentTimeMillis() - start;
        importStart.getMonitor().addExpenseStatistics(name, (Long)end, false);
        return null;
    }

    private Map<String, Integer> assessParse(List<ImportBillData> tempBilldatas, int totalRowCount) {
        HashMap reuslt = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList sizeSamplingList = new ArrayList(10);
        ArrayList rowCountSamplingList = new ArrayList(10);
        if (tempBilldatas.size() <= 10) {
            tempBilldatas.forEach(data -> {
                sizeSamplingList.add(JSONObject.toJSONString((Object)data).length());
                int rowCount = this.parseEntryCount((ImportBillData)data);
                rowCountSamplingList.add(rowCount);
            });
        }
        long size = 0L;
        for (Object item : sizeSamplingList) {
            size += (long)((Integer)item * 2);
        }
        size /= (long)sizeSamplingList.size();
        int rowCount = 1;
        for (Integer item : rowCountSamplingList) {
            rowCount += item.intValue();
        }
        int totalCount = totalRowCount / (rowCount /= sizeSamplingList.size());
        long totalSize = (long)totalCount * size;
        int totalSize1 = (int)(totalSize / 1024L / 1024L);
        reuslt.put(TOTAL_SIZE, totalSize1);
        reuslt.put(TOTAL_COUNT, totalCount);
        reuslt.put(PER_SIZE, (int)size);
        log.info("assessImportBillDataSize_result:" + JSONObject.toJSONString((Object)reuslt));
        return reuslt;
    }

    private int parseEntryCount(ImportBillData billData) {
        ImportContext importContext = this.parser.getImportStart().getImportContext();
        int maxRow = 1;
        return maxRow;
    }

    private int maxEntityRow(JSONObject entity, String entityId) {
        String entityFields = this.parser.getEntityEntryFields().get(entityId);
        int maxRow = 1;
        for (Map.Entry next1 : entity.entrySet()) {
            JSONArray array;
            if (!(next1.getValue() instanceof JSONArray) || !entityFields.contains((String)next1.getKey() + ",") || (array = (JSONArray)next1.getValue()).size() <= maxRow) continue;
            maxRow = array.size();
        }
        return maxRow;
    }

    public static boolean canTriggerBillDataSizeAssess(ImportContext importContext) {
        long fileSize = importContext.getFileSize();
        int totalRowCount = importContext.getTotalRowCount();
        return fileSize >= 0x200000L && totalRowCount >= 10000;
    }
}

