/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;

public class CallDeleteOperationTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(CallDeleteOperationTask.class);
    private IndImportStart importStart;
    private List<ImportBillData> tempBilldatas;
    private String sheetName;
    private Map<Object, Map<String, Object>> idMapRowIndex;
    private AtomicInteger childThreadMonitor;
    private AtomicInteger dataCanStopFlag;
    private String formId;
    private IndSaveOpDispatcher dispatcher;

    public CallDeleteOperationTask(List<ImportBillData> tempBilldatas, IndImportStart importStart, String formId, IndSaveOpDispatcher dispatcher, AtomicInteger childThreadMonitor, AtomicInteger dataCanStopFlag) {
        this.childThreadMonitor = childThreadMonitor;
        this.dataCanStopFlag = dataCanStopFlag;
        this.dataCanStopFlag.getAndIncrement();
        this.tempBilldatas = tempBilldatas;
        this.importStart = importStart;
        this.sheetName = tempBilldatas.get(0).getSheetName();
        this.formId = formId;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(CallDeleteOperationTask.class.getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.dispatcher.getImportStart().getMonitor().addOtherListData(CallDeleteOperationTask.class.getSimpleName() + "_received", this.tempBilldatas.size());
            DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(this.formId);
            log.info("before_getDynamicObjects_count=" + this.tempBilldatas.size());
            DynamicObject[] dynamicObjects = this.getDynamicObjects();
            log.info("after_getDynamicObjects_count=" + dynamicObjects.length);
            this.idMapRowIndex = this.initIdMapRowIndex(this.tempBilldatas, blankDynamicObject.getDynamicObjectType().getProperties());
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                log.warn("getDynamicObjects_failed.count=" + this.tempBilldatas.size());
                importContext.addFinishedBillCount(this.tempBilldatas.size());
                this.dataCanStopFlag.getAndDecrement();
                Object var6_8 = null;
                return var6_8;
            }
            if (ImportServiceHelper.isBuBaseData(this.formId)) {
                ImportServiceHelper.setUseOrgFieldValue(dynamicObjects);
            }
            OperateOption operateOption = importContext.getOpParam();
            if (BaseDataServiceHelper.checkBaseDataCtrl((String)this.formId).booleanValue()) {
                Map<String, List<DynamicObject>> map = this.groupByCreateOrg(dynamicObjects);
                Iterator<Map.Entry<String, List<DynamicObject>>> iterator = map.entrySet().iterator();
                int index = 1;
                while (iterator.hasNext()) {
                    Map.Entry<String, List<DynamicObject>> next = iterator.next();
                    DynamicObject[] subDys = next.getValue().toArray(new DynamicObject[0]);
                    operateOption.setVariableValue("createOrg", next.getKey());
                    if (index >= map.size()) {
                        this.dataCanStopFlag.getAndDecrement();
                    }
                    ++index;
                    this.callOp(subDys, operateOption);
                }
            } else {
                this.dataCanStopFlag.getAndDecrement();
                this.callOp(dynamicObjects, operateOption);
            }
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(this.tempBilldatas.size());
            log.error(CallDeleteOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(this.tempBilldatas, this.importStart, e);
            this.dataCanStopFlag.getAndDecrement();
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(CallDeleteOperationTask.class.getSimpleName(), (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private void callOp(DynamicObject[] dys, OperateOption operateOption) {
        ImportContext importContext = this.importStart.getImportContext();
        String submitOP = (String)this.importStart.getImportContext().getExtOption().get("submitOP");
        long start1 = System.currentTimeMillis();
        String extParam = (String)importContext.getExtOption().get("extParam");
        HRMPOperationServiceImpl im = new HRMPOperationServiceImpl(this.formId);
        log.info("localInvokeOperation_dys.size=" + dys.length);
        operateOption.setVariableValue("extParam", extParam);
        if (this.importStart.isStoped()) {
            return;
        }
        OperationResult result = im.localInvokeOperation(submitOP, dys, operateOption);
        long spense = System.currentTimeMillis() - start1;
        this.dispatcher.getSuggester().addExpenseTimes(spense);
        this.importStart.getMonitor().addExpenseStatistics("callDeleteOp", (Long)spense, false);
        importContext.addSuccessedBillCount(result.getSuccessPkIds().size());
        this.importStart.getImportContext().addFinishedBillCount(this.tempBilldatas.size());
        if (!result.isSuccess()) {
            ImportUtil.writeOperationResultLog(result, this.idMapRowIndex, dys, this.importStart, this.sheetName);
        }
    }

    private Map<Object, Map<String, Object>> initIdMapRowIndex(List<ImportBillData> tempBilldatas, DataEntityPropertyCollection properties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        for (int i = 0; i < tempBilldatas.size(); ++i) {
            ImportBillData data = tempBilldatas.get(i);
            JSONObject obj = (JSONObject)data.getData().get((Object)data.getMainEntityId());
            Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), obj, properties);
            map.put(data.getPkId(), childMap);
        }
        return map;
    }

    private DynamicObject[] getDynamicObjects() {
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(this.tempBilldatas.size());
        Map<Object, Object> map = null;
        if (this.importStart.getImportContext().isSerialModel()) {
            DynamicObject[] dynamicObjects;
            map = Maps.newHashMapWithExpectedSize((int)this.tempBilldatas.size());
            List<Object> ids = this.tempBilldatas.stream().map(de -> de.getPkId()).collect(Collectors.toList());
            for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, this.tempBilldatas.get(0).getMainEntityId())) {
                map.put((Long)oldBill.getPkValue(), oldBill);
            }
        } else {
            map = this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap();
        }
        for (ImportBillData data : this.tempBilldatas) {
            DynamicObject oldBill = (DynamicObject)map.get(data.getPkId());
            if (oldBill != null) {
                billObjs.add(oldBill);
                map.remove(data.getPkId());
                continue;
            }
            ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), "can not find dynamicObject from cache", this.importStart.getImportContext().getImportLog());
            this.importStart.writeRowErrorLog(errResult);
        }
        return billObjs.toArray(new DynamicObject[billObjs.size()]);
    }

    private Map<String, List<DynamicObject>> groupByCreateOrg(DynamicObject[] dynamicObjects) {
        Map<String, List<DynamicObject>> map = Arrays.asList(dynamicObjects).stream().collect(Collectors.groupingBy(item -> item.getString("createorg.id"), Collectors.toList()));
        return map;
    }
}

