/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.save.DataConvertDynamicObject;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;

public class CallSingleOperationTask
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(CallSingleOperationTask.class);
    private final IndImportStart importStart;
    private final List<ImportBillData> tempBilldatas;
    private String sheetName;
    private Map<Object, Map<String, Object>> idMapRowIndex;
    private Map<Object, ImportBillData> idAndbillDataMap;
    private final AtomicInteger childThreadMonitor;
    private final AtomicInteger dataCanStopFlag;
    private final String formId;
    private final IndSaveOpDispatcher dispatcher;
    private final IndicatorGroupDomainService indicatorGroupDomainService;
    private final IndicatorGroupApplicationService indicatorService;

    public CallSingleOperationTask(List<ImportBillData> tempBilldatas, IndImportStart importStart, String formId, IndSaveOpDispatcher dispatcher, AtomicInteger childThreadMonitor, AtomicInteger dataCanStopFlag) {
        this.childThreadMonitor = childThreadMonitor;
        this.dataCanStopFlag = dataCanStopFlag;
        this.dataCanStopFlag.getAndIncrement();
        this.tempBilldatas = tempBilldatas;
        this.sheetName = tempBilldatas.get(0).getSheetName();
        this.importStart = importStart;
        this.formId = formId;
        this.dispatcher = dispatcher;
        this.indicatorGroupDomainService = IndicatorGroupDomainService.getInstance();
        this.indicatorService = IndicatorGroupApplicationService.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(CallSingleOperationTask.class.getSimpleName() + "_started.");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.dispatcher.getImportStart().getMonitor().addOtherListData(CallSingleOperationTask.class.getSimpleName() + "_received", this.tempBilldatas.size());
            DynamicObject blankDynamicObject = this.dispatcher.getEntityBlankDynamicObject().get(this.formId);
            if (blankDynamicObject == null) {
                blankDynamicObject = new HRBaseServiceHelper(this.formId).generateEmptyDynamicObject();
            }
            DataConvertDynamicObject convert = new DataConvertDynamicObject(this.importStart, this.dispatcher);
            log.info("before_convert.toDynamicObject_count=" + this.tempBilldatas.size());
            DynamicObject[] dynamicObjects = convert.toDynamicObject(this.tempBilldatas, null, blankDynamicObject);
            log.info("after_convert.toDynamicObject_count=" + dynamicObjects.length);
            this.idAndbillDataMap = this.initIdAndbillDataMap(this.tempBilldatas);
            this.idMapRowIndex = this.initIdMapRowIndex(this.tempBilldatas, blankDynamicObject.getDynamicObjectType().getProperties());
            if (dynamicObjects.length == 0) {
                log.warn("convert.toDynamicObject_failed.count=" + this.tempBilldatas.size());
                importContext.addFinishedBillCount(this.tempBilldatas.size());
                this.dataCanStopFlag.getAndDecrement();
                Object var7_9 = null;
                return var7_9;
            }
            Map<String, Map<String, Object>> areaConfigMap = importContext.getAreaConfigMap();
            Map<String, Object> areaMap = areaConfigMap.get(this.sheetName);
            String entityName = (String)areaMap.get("entityName");
            if (entityName.equals("epa_genareaind_assign") || entityName.equals("epa_genareaindicator")) {
                Long confId = (Long)areaMap.get("confid");
                DynamicObject conf = AssessFormDomainService.getInstance().queryNormalConfigByPk(confId);
                boolean isAllowEval = conf.getBoolean("reversepoints");
                if (isAllowEval && HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        dynamicObject.set("minevalscore", (Object)conf.getBigDecimal("lowerscore"));
                        dynamicObject.set("maxevalscore", (Object)conf.getBigDecimal("upperscore"));
                    }
                }
            }
            if (entityName.equals("epa_genareaind_assign")) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("realweight", dynamicObject.get("weight"));
                }
            }
            if (importContext.isGroup()) {
                this.saveGroupObj(dynamicObjects);
            } else {
                this.saveEvalObj(dynamicObjects);
            }
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(this.tempBilldatas.size());
            log.error(CallSingleOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(this.tempBilldatas, this.importStart, e);
            this.dataCanStopFlag.getAndDecrement();
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(CallSingleOperationTask.class.getSimpleName(), (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }

    private void saveGroupObj(DynamicObject[] dynamicObjects) {
        ImportContext importContext = this.importStart.getImportContext();
        List<ImportBillData> relateBilldatas = null;
        try {
            relateBilldatas = this.getRelateBilldatas(dynamicObjects);
            log.info("localInvokeOperation_dynamicObjects.size=" + dynamicObjects.length);
            if (this.importStart.isStoped()) {
                return;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.formId);
            Long areaId = dynamicObjects[0].getLong("instanceid");
            QFilter qFilter = new QFilter("instanceid", "in", (Object)areaId);
            DynamicObject[] indicator = hrBaseServiceHelper.query(new QFilter[]{qFilter});
            List<Long> indicatorIds = Arrays.stream(indicator).map(ind -> ind.getLong("id")).collect(Collectors.toList());
            this.deleteIndicator(indicatorIds);
            this.addIndicator(dynamicObjects, areaId);
            for (int index = 0; index < dynamicObjects.length; ++index) {
                dynamicObjects[index].set("entryseq", (Object)(index + 1));
            }
            hrBaseServiceHelper.deleteByFilter(new QFilter[]{qFilter});
            hrBaseServiceHelper.save(dynamicObjects);
            Long indicGroupId = this.importStart.getImportContext().getIndicatorgroupid();
            log.info("**********************indicGroupId={}***************", (Object)indicGroupId);
            if (indicGroupId != null && indicGroupId != 0L) {
                this.indicatorService.updateEvalObjByIndicGroupId(indicGroupId);
            }
            importContext.addSuccessedBillCount(dynamicObjects.length);
            this.importStart.getImportContext().addFinishedBillCount(dynamicObjects.length);
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(dynamicObjects.length);
            log.error(CallSingleOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(relateBilldatas, this.importStart, e);
        }
    }

    private void saveEvalObj(DynamicObject[] dynamicObjects) {
        ImportContext importContext = this.importStart.getImportContext();
        List<ImportBillData> relateBilldatas = null;
        try {
            relateBilldatas = this.getRelateBilldatas(dynamicObjects);
            log.info("localInvokeOperation_dynamicObjects.size=" + dynamicObjects.length);
            if (this.importStart.isStoped()) {
                return;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.formId);
            Long areaId = dynamicObjects[0].getLong("instanceid");
            QFilter qFilter = new QFilter("instanceid", "in", (Object)areaId);
            DynamicObject[] indicator = hrBaseServiceHelper.query(new QFilter[]{qFilter});
            for (int index = 0; index < dynamicObjects.length; ++index) {
                dynamicObjects[index].set("entryseq", (Object)(indicator.length + index + 1));
            }
            hrBaseServiceHelper.save(dynamicObjects);
            Long actevalObjid = importContext.getActevalObjid();
            log.info("**********************actevalObjid={}***************", (Object)actevalObjid);
            if (actevalObjid != null && actevalObjid != 0L) {
                this.indicatorService.updateWeightAndIndctrScore(actevalObjid);
            }
            importContext.addSuccessedBillCount(dynamicObjects.length);
            this.importStart.getImportContext().addFinishedBillCount(dynamicObjects.length);
        }
        catch (Throwable e) {
            this.importStart.getImportContext().addFinishedBillCount(dynamicObjects.length);
            log.error(CallSingleOperationTask.class.getSimpleName() + "_exception.", e);
            this.importStart.writeErrorLog(e);
            ImportUtil.writeExceptionRowLog(relateBilldatas, this.importStart, e);
        }
    }

    private void addIndicator(DynamicObject[] dynamicObjects, Long areaId) {
        block10: for (DynamicObject dynamicObject : dynamicObjects) {
            switch (this.formId) {
                case "epa_genareaindicator": {
                    this.indicatorGroupDomainService.addObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, areaId, dynamicObject);
                    continue block10;
                }
                case "epa_addsubareaind": {
                    this.indicatorGroupDomainService.addObjIndicatorAreaEntry(AssessRuleConstants.PLUS_MINUS_AREA_PK, areaId, dynamicObject);
                    continue block10;
                }
                case "epa_attachareaind": {
                    this.indicatorGroupDomainService.addObjIndicatorAreaEntry(AssessRuleConstants.ATTACH_AREA_PK, areaId, dynamicObject);
                    continue block10;
                }
            }
        }
    }

    private void deleteIndicator(List<Long> indicatorIds) {
        for (Long indicatorId : indicatorIds) {
            switch (this.formId) {
                case "epa_genareaindicator": {
                    this.indicatorGroupDomainService.deleteObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, indicatorId);
                    break;
                }
                case "epa_addsubareaind": {
                    this.indicatorGroupDomainService.deleteObjIndicatorAreaEntry(AssessRuleConstants.PLUS_MINUS_AREA_PK, indicatorId);
                    break;
                }
                case "epa_attachareaind": {
                    this.indicatorGroupDomainService.deleteObjIndicatorAreaEntry(AssessRuleConstants.ATTACH_AREA_PK, indicatorId);
                    break;
                }
            }
        }
    }

    private List<ImportBillData> getRelateBilldatas(DynamicObject[] dynamicObjects) {
        ArrayList<ImportBillData> subBilldatas = new ArrayList<ImportBillData>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            ImportBillData billData = this.idAndbillDataMap.get(dy.getPkValue());
            subBilldatas.add(billData);
        }
        return subBilldatas;
    }

    private Map<Object, Map<String, Object>> initIdMapRowIndex(List<ImportBillData> tempBilldatas, DataEntityPropertyCollection properties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        for (ImportBillData data : tempBilldatas) {
            JSONObject obj = (JSONObject)data.getData().get((Object)data.getMainEntityId());
            Map<String, Object> childMap = ImportUtil.getEntryRowIndex(data.getStartIndex(), data.getEndIndex(), obj, properties);
            map.put(data.getPkId(), childMap);
        }
        return map;
    }

    private Map<Object, ImportBillData> initIdAndbillDataMap(List<ImportBillData> tempBilldatas) {
        HashMap idAndbillDataMap = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
        tempBilldatas.forEach(item -> idAndbillDataMap.put(item.getPkId(), item));
        return idAndbillDataMap;
    }
}

