/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.opmc.epa.business.domain.indicator.imp.constant.IndConstant;
import org.apache.commons.lang3.StringUtils;

public class CommonUtil {
    public static IFormView createEntityFormView(String formId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        IFormView viewForWebApi = parameter.createViewForWebApi();
        viewForWebApi.initialize(parameter);
        return viewForWebApi;
    }

    public static String getSplitValue(Map<Integer, String> data) {
        return CommonUtil.getSplitValue(data.values().stream().findFirst().orElse(""));
    }

    public static String getSplitValue(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        String[] split = data.split("#", 2);
        if (split.length > 1) {
            return split[1].trim();
        }
        return data;
    }

    public static void showMessage(IFormView formView, String msg, String detail, ConfirmCallBackListener callBack) {
        HashMap<String, String> jo = new HashMap<String, String>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)formView.getService(IPageCache.class);
            cache.put("ConfirmCallBackListener." + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        jo.put("msg", msg);
        jo.put("detail", detail);
        jo.put("messageType", (String)MessageTypes.Default);
        ((AbstractFormView)formView).getClientProxy().addAction("showMessage", jo);
    }

    public static int excelNum2Digit(String excelNum) {
        char[] chars = excelNum.toCharArray();
        int digit = 0;
        for (char ch : chars) {
            digit = digit * 26 + (ch - 65 + 1);
        }
        return digit;
    }

    public static Boolean getBoolMap(String val) {
        HashSet<String> trueList = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"CommonUtil_0", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"CommonUtil_1", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"CommonUtil_2", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"CommonUtil_3", (String)"opmc-epa-business", (Object[])new Object[0]), "true", "yes", "ok"));
        if (trueList.contains(val)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean getBooleanOfFalse(String val) {
        HashSet<String> trueList = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u5426", (String)"CommonUtil_4", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5047", (String)"CommonUtil_5", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u52fe\u9009", (String)"CommonUtil_6", (String)"opmc-epa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9519", (String)"CommonUtil_7", (String)"opmc-epa-business", (Object[])new Object[0]), "false", "no", "no good"));
        if (trueList.contains(val)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Exception decompiling
     */
    public static String formatException(Throwable throwable) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getLegalSheetName(String name, String tmpltype) {
        name = IndConstant.SpecCharPattern.matcher(name).replaceAll("");
        if ("IMPT".equalsIgnoreCase(tmpltype) && name.length() > 28) {
            return name.substring(0, 28);
        }
        return name;
    }

    public static void getAllBDFieldKeys(DataEntityPropertyCollection properties, Set<String> allKeys, Set<String> allMulKeys) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                allKeys.add(property.getName());
                continue;
            }
            if (property instanceof MulBasedataProp) {
                allMulKeys.add(property.getName());
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            CommonUtil.getAllBDFieldKeys(entryProperties, allKeys, allMulKeys);
        }
    }

    public static String tranDecimalToBase26(int number) {
        StringBuilder stringBuilder = new StringBuilder();
        while (number > 0) {
            int m = number % 26;
            if (m != 0) {
                stringBuilder.insert(0, (char)(m - 1 + 65));
            } else {
                stringBuilder.insert(0, 'Z');
                number -= 26;
            }
            number = (number - m) / 26;
        }
        return stringBuilder.toString();
    }
}

