/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.opmc.epa.business.domain.indicator.imp.entity.ExportSheetStyle;
import kd.opmc.epa.business.domain.indicator.imp.entity.FieldStyle;
import kd.opmc.epa.business.domain.indicator.imp.helper.FieldStyleServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelStyleUtil {
    public static ExportSheetStyle getExportSheetStyle(DynamicObject templateData, SXSSFWorkbook wb) {
        String templateNumber = templateData.getString("number");
        JSONObject fieldStyle = FieldStyleServiceHelper.getCustomFieldStyle(templateNumber);
        if (fieldStyle == null || fieldStyle.isEmpty()) {
            return new ExportSheetStyle(wb);
        }
        boolean isGlobalSheetStyle = false;
        ExportSheetStyle styles = ExcelStyleUtil.getGlobalSheetStyle(wb, fieldStyle);
        isGlobalSheetStyle = true;
        ExcelStyleUtil.putCustomFieldMerges(templateData, styles);
        if (!isGlobalSheetStyle) {
            Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb);
            styles.setGlobalHeadCellStyle((CellStyle)cellStyleCellStyle.getLeft());
            styles.setGlobalContentCellStyle((CellStyle)cellStyleCellStyle.getRight());
        }
        return styles;
    }

    public static ExportSheetStyle getByListExportSheetStyle(SXSSFWorkbook wb) {
        return ExcelStyleUtil.getGlobalSheetStyle(wb);
    }

    public static CellStyle getByListExportCellStyle(SXSSFWorkbook wb) {
        ExportSheetStyle byListExportSheetStyle = ExcelStyleUtil.getByListExportSheetStyle(wb);
        return byListExportSheetStyle.getGlobalHeadCellStyle();
    }

    public static ExportSheetStyle getGlobalSheetStyle(SXSSFWorkbook wb) {
        ExportSheetStyle exportSheetStyle;
        JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
        if (globalFieldStyle != null && !globalFieldStyle.isEmpty()) {
            globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
            exportSheetStyle = ExcelStyleUtil.getGlobalSheetStyle(wb, globalFieldStyle);
        } else {
            exportSheetStyle = new ExportSheetStyle(wb);
        }
        return exportSheetStyle;
    }

    private static ExportSheetStyle getGlobalSheetStyle(SXSSFWorkbook wb, JSONObject fieldStyle) {
        Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb, fieldStyle);
        return new ExportSheetStyle(wb, (CellStyle)cellStyleCellStyle.getLeft(), (CellStyle)cellStyleCellStyle.getRight());
    }

    private static Pair<CellStyle, CellStyle> buildGlobalSheetStyle(SXSSFWorkbook wb) {
        return ExcelStyleUtil.buildGlobalSheetStyle(wb, FieldStyleServiceHelper.getGlobalFieldStyle());
    }

    private static Pair<CellStyle, CellStyle> buildGlobalSheetStyle(SXSSFWorkbook wb, JSONObject fieldStyle) {
        JSONObject contentJsonObject;
        XSSFWorkbook xssfWorkbook = wb.getXSSFWorkbook();
        CellStyle globalHeadCellStyle = null;
        CellStyle globalContentCellStyle = null;
        JSONObject headJsonObject = fieldStyle.getJSONObject("header");
        if (headJsonObject != null && !headJsonObject.isEmpty()) {
            FieldStyle globalHeadFieldStyle = (FieldStyle)headJsonObject.toJavaObject(FieldStyle.class);
            globalHeadCellStyle = globalHeadFieldStyle.getCellStyle(xssfWorkbook);
        }
        if ((contentJsonObject = fieldStyle.getJSONObject("content")) != null && !contentJsonObject.isEmpty()) {
            FieldStyle globalContentFieldStyle = (FieldStyle)contentJsonObject.toJavaObject(FieldStyle.class);
            globalContentCellStyle = globalContentFieldStyle.getCellStyle(xssfWorkbook);
        }
        return Pair.of(globalHeadCellStyle, globalContentCellStyle);
    }

    private static ExportSheetStyle getCustomSheetStyle(SXSSFWorkbook wb, JSONObject fieldStyle) {
        XSSFWorkbook xssfWorkbook = wb.getXSSFWorkbook();
        HashBasedTable customHeadCellStyles = HashBasedTable.create();
        HashBasedTable customContentCellStyles = HashBasedTable.create();
        fieldStyle.forEach((arg_0, arg_1) -> ExcelStyleUtil.lambda$getCustomSheetStyle$2(xssfWorkbook, (Table)customHeadCellStyles, (Table)customContentCellStyles, arg_0, arg_1));
        ExportSheetStyle styles = new ExportSheetStyle(wb, (Table<String, String, CellStyle>)customHeadCellStyles, (Table<String, String, CellStyle>)customContentCellStyles);
        return styles;
    }

    public static ExportSheetStyle getPreViewExportSheetStyle(SXSSFWorkbook wb, String fieldstyle) {
        JSONObject fieldStyle = StringUtils.isBlank((CharSequence)fieldstyle) ? FieldStyleServiceHelper.getGlobalFieldStyle() : JSON.parseObject((String)fieldstyle);
        if (fieldStyle == null || fieldStyle.isEmpty()) {
            return new ExportSheetStyle(wb);
        }
        boolean isGlobalSheetStyle = false;
        ExportSheetStyle styles = ExcelStyleUtil.getGlobalSheetStyle(wb, fieldStyle);
        isGlobalSheetStyle = true;
        if (!isGlobalSheetStyle) {
            Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb);
            styles.setGlobalHeadCellStyle((CellStyle)cellStyleCellStyle.getLeft());
            styles.setGlobalContentCellStyle((CellStyle)cellStyleCellStyle.getRight());
        }
        return styles;
    }

    private static boolean putCustomFieldMerges(String fieldmerge, ExportSheetStyle styles) {
        JSONObject customFieldMerge = JSON.parseObject((String)fieldmerge);
        if (customFieldMerge == null || customFieldMerge.isEmpty()) {
            return false;
        }
        return ExcelStyleUtil.putCustomFieldMerges(styles, customFieldMerge);
    }

    private static boolean putCustomFieldMerges(DynamicObject templateData, ExportSheetStyle styles) {
        String templateNumber = templateData.getString("number");
        JSONObject customFieldMerge = FieldStyleServiceHelper.getCustomFieldMerge(templateNumber);
        if (customFieldMerge == null || customFieldMerge.isEmpty()) {
            return false;
        }
        return ExcelStyleUtil.putCustomFieldMerges(styles, customFieldMerge);
    }

    private static boolean putCustomFieldMerges(ExportSheetStyle styles, JSONObject customFieldMerge) {
        HashBasedTable customFieldMerges = HashBasedTable.create();
        customFieldMerge.forEach((arg_0, arg_1) -> ExcelStyleUtil.lambda$putCustomFieldMerges$4((Table)customFieldMerges, arg_0, arg_1));
        if (ObjectUtils.isNotEmpty((Object)customFieldMerges)) {
            styles.setCustomFieldMerges((Table<String, String, String>)customFieldMerges);
            return true;
        }
        return false;
    }

    public static Map<String, ControlAp<?>> getFieldControlApMap(String mainEntityName) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityName, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return formMeta.getItems().stream().filter(item -> item instanceof FieldAp || item instanceof EntryFieldAp).collect(Collectors.toMap(item2 -> item2.getKey(), Function.identity(), (x1, x2) -> x1));
    }

    public static String getMask(Map<String, ControlAp<?>> fieldApMap, IDataEntityProperty prop) {
        boolean flag = prop instanceof DateTimeProp ? StringUtils.isBlank((CharSequence)((DateTimeProp)prop).getRelateDateTimeRange()) : StringUtils.isBlank((CharSequence)((TimeProp)prop).getRelateTimeRange());
        String propName = prop.getName();
        String mask = "";
        if (flag) {
            String string = mask = fieldApMap.get(propName) instanceof FieldAp ? ((FieldAp)fieldApMap.get(propName)).getMask() : ((EntryFieldAp)fieldApMap.get(propName)).getMask();
        }
        if (StringUtils.isBlank((CharSequence)mask)) {
            if (prop instanceof DateProp) {
                return ExcelStyleUtil.getDefaultMask("date");
            }
            if (prop instanceof TimeProp) {
                return ExcelStyleUtil.getDefaultMask("time");
            }
            return ExcelStyleUtil.getDefaultMask("datetime");
        }
        return ExcelStyleUtil.updateToLower(mask);
    }

    public static String updateToLower(String mask) {
        if (StringUtils.isNotBlank((CharSequence)mask)) {
            return mask.replace("YY", "yy").replace("DD", "dd");
        }
        return "";
    }

    public static String getDefaultMask(String type) {
        switch (type) {
            case "date": {
                return "yyyy-MM-dd";
            }
            case "time": {
                return "HH:mm:ss";
            }
        }
        return "yyyy-MM-dd HH:mm:ss";
    }

    private static /* synthetic */ void lambda$putCustomFieldMerges$4(Table customFieldMerges, String key, Object value) {
        JSONObject fields = JSON.parseObject((String)((String)value));
        fields.forEach((key1, value1) -> {
            String cfr_ignored_0 = (String)customFieldMerges.put((Object)key, key1, (Object)((String)value1));
        });
    }

    private static /* synthetic */ void lambda$getCustomSheetStyle$2(XSSFWorkbook xssfWorkbook, Table customHeadCellStyles, Table customContentCellStyles, String key, Object value) {
        JSONObject fields = (JSONObject)value;
        fields.forEach((key1, value1) -> {
            JSONObject cellStyles = (JSONObject)value1;
            cellStyles.forEach((key2, value2) -> {
                FieldStyle customFieldStyle = (FieldStyle)((JSONObject)value2).toJavaObject(FieldStyle.class);
                CellStyle customCellStyle = customFieldStyle.getCellStyle(xssfWorkbook);
                if ("header".equals(key2)) {
                    customHeadCellStyles.put((Object)key, key1, (Object)customCellStyle);
                } else if ("content".equals(key2)) {
                    customContentCellStyles.put((Object)key, key1, (Object)customCellStyle);
                }
            });
        });
    }
}

