/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;

public class ImportUtil {
    private static Log log = LogFactory.getLog(ImportUtil.class);
    private static final String defoutError = "unkonw error message from the operation result.";

    public static int statisticsBillCount(ImportBillData billData) {
        int count = 0;
        Collection values = billData.getData().values();
        for (Object val : values) {
            if (val instanceof JSONObject) {
                ++count;
                continue;
            }
            JSONArray valarr = (JSONArray)val;
            count += valarr.size();
        }
        return count;
    }

    public static void writeOperationResultLog(OperationResult result, Map<Object, Map<String, Object>> idMapRowIndex, DynamicObject[] dynamicObjects, IndImportStart importStart, String sheetName) {
        log.info("result.getSuccessPkIds().count=" + result.getSuccessPkIds().size());
        ImportContext importContext = importStart.getImportContext();
        String entityId = dynamicObjects[0].getDynamicObjectType().getName();
        HashMap successIdMap = Maps.newHashMapWithExpectedSize((int)16);
        result.getSuccessPkIds().forEach(pkid -> successIdMap.put(pkid, null));
        HashMap hasErrorInfoPkidMap = Maps.newHashMapWithExpectedSize((int)(dynamicObjects.length - result.getSuccessPkIds().size()));
        LinkedList unrespectPkids = new LinkedList();
        List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
        log.info("result.getAllErrorOrValidateInfo().count=" + allErrorOrValidateInfo.size());
        allErrorOrValidateInfo.forEach(error -> {
            ValidationErrorInfo info = (ValidationErrorInfo)error;
            Map entryMap = (Map)idMapRowIndex.get(info.getPkValue());
            if (entryMap != null) {
                String entityRowIndex = (String)entryMap.get("entity");
                hasErrorInfoPkidMap.put(info.getPkValue(), null);
                String[] split = StringUtils.split((String)entityRowIndex, (String)",");
                ImportRowErrorLog errorLog = null;
                if (!entityId.equalsIgnoreCase(info.getEntityKey())) {
                    Map entryRowIndexMap = (Map)entryMap.get(info.getEntityKey());
                    Integer rowIndex = null;
                    if (entryRowIndexMap != null) {
                        rowIndex = (Integer)entryRowIndexMap.get(info.getRowIndex());
                    }
                    errorLog = rowIndex != null ? new ImportRowErrorLog(sheetName, Integer.parseInt(split[0]), Integer.parseInt(split[1]), rowIndex, info.getMessage(), importContext.getImportLog()) : new ImportRowErrorLog(sheetName, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), info.getMessage(), importContext.getImportLog());
                } else {
                    errorLog = new ImportRowErrorLog(sheetName, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), info.getMessage(), importContext.getImportLog());
                }
                importStart.writeRowErrorLog(errorLog);
            } else {
                unrespectPkids.add(info.getPkValue());
            }
        });
        log.info("afterCallOperation_unrespectPkids:" + JSONObject.toJSONString(unrespectPkids));
        log.info("afterCallOperation_hasErrorInfoPkidMap.count=" + hasErrorInfoPkidMap.size());
        if (hasErrorInfoPkidMap.size() == 0) {
            log.info("afterCallOperation_can't_find_any_error_message OperationResult is:" + result.toString());
        }
        LinkedList<Object> noAdaptErrorIds = new LinkedList<Object>();
        for (Map.Entry<Object, Map<String, Object>> next : idMapRowIndex.entrySet()) {
            if (successIdMap.containsKey(next.getKey()) || hasErrorInfoPkidMap.containsKey(next.getKey())) continue;
            noAdaptErrorIds.add(next.getKey());
            String entityRowIndex = (String)next.getValue().get("entity");
            String[] split = StringUtils.split((String)entityRowIndex, (String)",");
            ImportRowErrorLog errorLog = new ImportRowErrorLog(sheetName, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), StringUtils.isEmpty((CharSequence)result.getMessage()) ? defoutError : result.getMessage(), importContext.getImportLog());
            importStart.writeRowErrorLog(errorLog);
        }
        if (CollectionUtils.isNotEmpty(noAdaptErrorIds)) {
            log.info("afterCallOperation_noAdaptErrorIds:" + JSONObject.toJSONString(noAdaptErrorIds));
        }
    }

    public static Map<String, Object> getEntryRowIndex(Integer startIndex, Integer endIndex, JSONObject obj, DataEntityPropertyCollection properties) {
        HashMap childMap = Maps.newHashMapWithExpectedSize((int)3);
        childMap.put("entity", String.valueOf(startIndex) + ',' + endIndex + ',' + obj.get((Object)"$excelIndex"));
        for (Map.Entry next : obj.entrySet()) {
            Object prop = properties.get(next.getKey());
            if (!(prop instanceof EntryProp)) continue;
            JSONArray entryEntity = (JSONArray)next.getValue();
            HashMap entryMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
            ListIterator objectListIterator = entryEntity.listIterator();
            int index = 0;
            while (objectListIterator.hasNext()) {
                JSONObject next1 = (JSONObject)objectListIterator.next();
                entryMap.put(index, next1.get((Object)"$excelIndex"));
            }
            childMap.put(next.getKey(), entryMap);
        }
        return childMap;
    }

    public static Object getBillDataValue(String fieldKey, JSONObject object) {
        String[] split = StringUtils.split((String)fieldKey, (String)".");
        if (split.length == 1) {
            return object.get((Object)split[0]);
        }
        JSONObject object1 = object.getJSONObject(split[0]);
        Object id = object1.get((Object)"id");
        if (id != null) {
            return id;
        }
        return object1.get((Object)split[1]);
    }

    public static void writeExceptionRowLog(List<ImportBillData> tempBilldatas, IndImportStart importStart, Throwable e) {
        if (CollectionUtils.isEmpty(tempBilldatas)) {
            return;
        }
        String exceptionInfoWithSys = ImportRowErrorLog.getExceptionInfoWithSys(e);
        tempBilldatas.forEach(data -> {
            ImportRowErrorLog errorLog = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), exceptionInfoWithSys, importStart.getImportContext().getImportLog());
            importStart.writeRowErrorLog(errorLog);
        });
    }

    public static Map<String, Map<String, DynamicObject>> getTplFieldConfig(DynamicObject tpl) {
        DynamicObjectCollection templateEntry = tpl.getDynamicObjectCollection("tpltreeentryentity");
        HashMap entityFieldInfoMap = Maps.newHashMapWithExpectedSize((int)templateEntry.size());
        Map roleIdAndParentsList = templateEntry.stream().collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        String entityNumber = "";
        Iterator iterator = roleIdAndParentsList.entrySet().iterator();
        while (iterator.hasNext()) {
            LinkedHashMap<String, DynamicObject> fieldSet = new LinkedHashMap<String, DynamicObject>();
            Map.Entry next = iterator.next();
            for (DynamicObject row : next.getValue()) {
                String attr = row.getString("fieldnumber");
                long pid = row.getLong("pid");
                if (pid != 0L && row.getBoolean("isimport")) {
                    fieldSet.put(attr, row);
                    continue;
                }
                if (pid != 0L) continue;
                entityNumber = attr;
                entityFieldInfoMap.put(entityNumber, fieldSet);
            }
        }
        return entityFieldInfoMap;
    }

    public static String getLevelOneKey(String key) {
        String[] split = StringUtils.split((String)key, (String)".");
        return split[0];
    }
}

