/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class MethodUtil {
    private static final Log logger = LogFactory.getLog(MethodUtil.class);

    public static String getTaskCachePath(String taskId, String importType, String type) {
        return "epa_" + importType + "_task_".concat(taskId).concat("_").concat(type);
    }

    public static String getUpgradeFlagCachePath(String type) {
        return "hr_hies_tplUpgrade_" + type;
    }

    public static Map<String, Map<String, Object>> getEntityBdMainProp(String entityId) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityId);
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            ((EntityType)entry.getValue()).getFields().values().forEach(fldProperty -> {
                Map<String, Object> bdMainProp = null;
                if (fldProperty instanceof IBasedataField) {
                    BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
                    bdMainProp = MethodUtil.getBdMainProp(type.getName());
                }
                if (bdMainProp != null) {
                    fieldMap.put(fldProperty.getName(), bdMainProp);
                }
            });
        }
        return fieldMap;
    }

    public static Map<String, Object> getBdMainProp(String bdId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if (StringUtils.isEmpty((String)bdId)) {
            return map;
        }
        MainEntityType bd = MetadataServiceHelper.getDataEntityType((String)bdId);
        if (bd instanceof BasedataEntityType) {
            BasedataEntityType type = (BasedataEntityType)bd;
            map.put("name", type.getNameProperty());
            map.put("number", type.getNumberProperty());
            map.put("id", type.getPrimaryKey());
            map.put("status", type.getBillStatus());
            map.put("enable", type.getForbidStatus());
            map.put("masterid", type.getMasteridPropName());
        } else if (bd instanceof BillEntityType) {
            BillEntityType type = (BillEntityType)bd;
            map.put("number", type.getBillNo());
        }
        return map;
    }

    public static Map<String, Object> getHRPersonMainProp(String baseEntityId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if ("hrpi_depempf7query".equals(baseEntityId) || "hrpi_employeef7query".equals(baseEntityId)) {
            map.put("name", "person.name");
            map.put("number", "person.number");
        } else {
            map.put("name", "name");
            map.put("number", "number");
        }
        return map;
    }

    private static String getBdSelectedAtrrStr(IDataEntityProperty prop) {
        if (prop instanceof BasedataProp) {
            BasedataProp bdpro = (BasedataProp)prop;
            DynamicObjectType dynamicComplexPropertyType = bdpro.getDynamicComplexPropertyType();
            RefEntityType ref = (RefEntityType)dynamicComplexPropertyType;
            String extendName = ref.getExtendName();
            String replace = extendName.replace(bdpro.getBaseEntityId(), "").replace("[", "").replace("]", "");
            return replace;
        }
        if (prop instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)prop;
        }
        return "";
    }

    public static IFormView initFormView(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)view.getService(IFormController.class);
        srv.registerListener();
        return view;
    }

    public static IFormView getViewNoPlugin(String pageId) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        return view;
    }

    public static void syncRequestTraceId(Object sourceRc) {
        RequestContext.get().setTraceId(((RequestContext)sourceRc).getTraceId());
        RequestContextThreadBinder.bind((RequestContext)RequestContext.get());
    }

    public static Map<String, Object> getRecoveryViewParams(String pageId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        map.put("cacheMap", JSONObject.toJSONString((Object)pageCache.getAll()));
        map.put("pageJson", JSONObject.toJSONString((Object)pageCache));
        return map;
    }

    public static IFormView recoveryView(String pageJson, Map<String, String> cacheMap) {
        PageCache newcache = (PageCache)JSONObject.parseObject((String)pageJson, PageCache.class);
        newcache.put(cacheMap);
        Map all = newcache.getAll();
        String parameter = (String)all.get(FormShowParameter.class.getSimpleName());
        FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)parameter);
        formShowParameter.endInit();
        IFormView view = formShowParameter.createView();
        view.addService(IPageCache.class, (Object)newcache);
        view.initialize(formShowParameter);
        return view;
    }

    public static boolean releaseView(IFormView view) {
        try {
            FormController controller = new FormController(view);
            controller.release(null);
            return true;
        }
        catch (Throwable e) {
            logger.error(e);
            return false;
        }
    }

    public static void shutdownNowThreadPool(ThreadPool pool) throws NoSuchFieldException, IllegalAccessException {
        if (pool == null) {
            return;
        }
        ThreadPoolImpl impl = (ThreadPoolImpl)pool;
        Field field = impl.getClass().getDeclaredField("es");
        ReflectionUtils.makeAccessible((Field)field);
        ExecutorService ex = (ExecutorService)field.get(impl);
        ex.shutdownNow();
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        LinkedList<List<T>> result = new LinkedList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    private static ThreadPoolExecutor getThreadPoolExecutor(String name) {
        try {
            Field poolMap = ThreadPools.class.getDeclaredField("poolMap");
            ReflectionUtils.makeAccessible((Field)poolMap);
            Map pools = (Map)poolMap.get(ThreadPools.class.newInstance());
            ThreadPoolImpl pool = (ThreadPoolImpl)pools.get(name);
            if (pool == null) {
                return null;
            }
            Field esf = pool.getClass().getDeclaredField("es");
            ReflectionUtils.makeAccessible((Field)esf);
            ExecutorService espol = (ExecutorService)esf.get(pool);
            Field del = espol.getClass().getDeclaredField("delegateService");
            ReflectionUtils.makeAccessible((Field)del);
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)del.get(espol);
            return tpe;
        }
        catch (Throwable e) {
            logger.error(e);
            return null;
        }
    }

    public static Map<String, Integer> getThreadPoolKeyInfo(String name) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        ThreadPoolExecutor pool = MethodUtil.getThreadPoolExecutor(name);
        if (pool == null) {
            return map;
        }
        map.put("queue", pool.getQueue().size());
        map.put("activeCount", pool.getActiveCount());
        return map;
    }

    public static String getRouteAppId(String serviceAppId) {
        String routeAppId = ServiceLookup.hasDeployedAppId((String)"imp-exp") ? "imp-exp" : serviceAppId;
        return routeAppId;
    }

    public static void addUrlPermitData(String url, String entityNum, String appId) {
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", appId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    public static Map<String, String> reversalMap(Map<String, String> sourceMap) {
        HashMap entitySheetMap = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        for (Map.Entry<String, String> next : sourceMap.entrySet()) {
            entitySheetMap.put(next.getValue(), next.getKey());
        }
        return entitySheetMap;
    }

    public static List<String> getTplAllEntitys(DynamicObject tpl) {
        LinkedList<String> list = new LinkedList<String>();
        if (tpl == null) {
            return list;
        }
        String mainid = tpl.getString("entity.id");
        list.add(mainid);
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            list.add(childId);
        }
        return list;
    }

    public static Map<String, String> samplingCpuMem() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long usedPhysicalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize() - operatingSystemMXBean.getFreePhysicalMemorySize();
        StringBuilder builder = new StringBuilder();
        builder.append("us:").append(usedPhysicalMemorySize / 1024L / 1024L);
        builder.append("M,uh:").append(heapMemoryUsage.getUsed() / 1024L / 1024L);
        builder.append("M");
        map.put("memory", builder.toString());
        double systemCpuLoad = operatingSystemMXBean.getSystemCpuLoad();
        double processCpuLoad = operatingSystemMXBean.getProcessCpuLoad();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("s:").append(String.format("%.0f", systemCpuLoad * 100.0));
        builder2.append("%,p:").append(String.format("%.0f", processCpuLoad * 100.0));
        builder2.append("%");
        map.put("cpu", builder2.toString());
        return map;
    }

    public static String getMemoryConfig() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize();
        StringBuilder builder = new StringBuilder();
        builder.append("totalPhysicalMemorySize:").append(totalPhysicalMemorySize / 1024L / 1024L);
        builder.append("M,heapMemoryMaxSize:").append(heapMemoryUsage.getMax() / 1024L / 1024L);
        builder.append("M");
        return builder.toString();
    }

    public static QFilter getDataInitQFilter(String billFormId) {
        Map allFields = MetadataServiceHelper.getDataEntityType((String)billFormId).getAllFields();
        for (IDataEntityProperty toPro : allFields.values()) {
            if (!HRStringUtils.equals((String)toPro.getName(), (String)"initdatasource") && !HRStringUtils.equals((String)toPro.getName(), (String)"initstatus") && !HRStringUtils.equals((String)toPro.getName(), (String)"initbatch")) continue;
            if (HRStringUtils.isEmpty((String)toPro.getAlias())) {
                return null;
            }
            QFilter statusFilter = new QFilter("initstatus", "=", (Object)"2");
            return statusFilter;
        }
        return null;
    }

    public static Map<String, Integer> getVirtualProcess(int trueProgress, int trueTimeRemaining, float finishedBillCount, int totalBillCount) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("progress", trueProgress >= 90 ? trueProgress : 90);
        result.put("timeRemaining", trueTimeRemaining < 3000 ? trueProgress : 3000);
        if (finishedBillCount > 0.0f && totalBillCount > 0) {
            float virtualFinishedBillCount = (float)totalBillCount * 0.9f;
            result.put("finishedBillCount", finishedBillCount >= virtualFinishedBillCount ? (int)finishedBillCount : (int)virtualFinishedBillCount);
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, Object>>> initEntityF7MainPropName(DynamicObject tpl) {
        String mainid = tpl.getString("entity.id");
        if (StringUtils.isEmpty((String)mainid)) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        HashMap map = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        map.put(mainid, MethodUtil.getEntityBdMainProp(mainid));
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            map.put(childId, MethodUtil.getEntityBdMainProp(childId));
        }
        return map;
    }

    public static String getLevelOneKey(String key) {
        String[] split = StringUtils.split((String)key, (boolean)true, (char[])new char[]{'.'});
        return split[0];
    }

    public static String getLastKey(String key) {
        String[] split = StringUtils.split((String)key, (boolean)true, (char[])new char[]{'.'});
        return split[split.length - 1];
    }

    public static Set<String> filterNotExistField(Set<String> selectFields, String baseDataEntityNum) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)baseDataEntityNum);
        return selectFields.stream().filter(field -> mainType.getProperties().stream().map(IMetadata::getName).anyMatch(pro -> pro.equals(field)) && mainType.getProperties().stream().filter(field1 -> StringUtils.isNotEmpty((String)field1.getAlias())).map(IMetadata::getName).anyMatch(pro -> pro.equals(field))).collect(Collectors.toSet());
    }
}

