/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.opmc.epa.business.domain.indicator.imp.ExcelReader;
import kd.opmc.epa.business.domain.indicator.imp.SheetHandler;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportFileUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.extpoint.ITemplateValidatorService;
import kd.opmc.epa.business.domain.indicator.imp.util.extpoint.impl.TemplateValidatorServiceImpl;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TemplateUtils {
    private static final Log LOGGER = LogFactory.getLog(TemplateUtils.class);

    public static Map<String, Object> checkTemplate(String localPath, List<Map<String, Object>> param) throws Exception {
        File file = new File(localPath);
        final int[] totalRow = new int[]{0};
        final HashMap sheetRowCountMap = Maps.newHashMapWithExpectedSize((int)3);
        final HashMap sheetEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        LinkedMultiValueMap templateValidater = new LinkedMultiValueMap();
        final ArrayList effectSheetNamesSetTemp = new ArrayList(6);
        final String[] templateNumber = new String[]{""};
        final String[] firstSheetName = new String[]{""};
        List[] tplDys = new List[]{null};
        SheetHandler sheetHandler = null;
        try {
            sheetHandler = new SheetHandler((MultiValueMap)templateValidater){
                private Pattern UpperCacePattern = Pattern.compile("[A-Z]");
                private Pattern IntPattern = Pattern.compile("[0-9]");
                private int colCount = 0;
                private int onlyParserCount = 16;
                final /* synthetic */ MultiValueMap val$templateValidater;
                {
                    this.val$templateValidater = multiValueMap;
                }

                @Override
                protected boolean isSkipEmptyRow() {
                    return false;
                }

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    int curRowNum = this.getRowHolder().getRowNum();
                    if (curRowNum >= this.onlyParserCount) {
                        throw new KDBizException(new ErrorCode("908", "sheet_parse_terminal."), new Object[0]);
                    }
                    super.startElement(uri, localName, name, attributes);
                    if ("dimension".equals(name)) {
                        String refdata = attributes.getValue("ref");
                        String rowCountStr = refdata.substring(refdata.indexOf(":") + 1).toUpperCase();
                        int sheetCountRow = Integer.parseInt(this.UpperCacePattern.matcher(rowCountStr).replaceAll(""));
                        sheetRowCountMap.put(this.getCurrentSheetName(), sheetCountRow - 5);
                        totalRow[0] = totalRow[0] + sheetCountRow;
                        this.colCount = CommonUtil.excelNum2Digit(this.IntPattern.matcher(rowCountStr).replaceAll(""));
                    }
                }

                @Override
                public void handleRow(SheetHandler.ParsedRow row) {
                    int currRowNum;
                    String currentSheetName = this.getCurrentSheetName();
                    if (StringUtils.isEmpty((CharSequence)firstSheetName[0])) {
                        firstSheetName[0] = currentSheetName;
                    }
                    if ((currRowNum = row.getRowNum()) == 0) {
                        templateNumber[0] = CommonUtil.getSplitValue(row.getData());
                    } else if (currRowNum < this.onlyParserCount && currRowNum > 0) {
                        if (currRowNum == 1) {
                            boolean emptyColum = StringUtils.isEmpty((CharSequence)CommonUtil.getSplitValue(row.get(0)));
                            String numberRow = emptyColum ? row.get(1) : row.get(0);
                            String entityName = CommonUtil.getSplitValue(numberRow);
                            try {
                                MetadataServiceHelper.getDataEntityType((String)entityName);
                                effectSheetNamesSetTemp.add(currentSheetName);
                            }
                            catch (Throwable e) {
                                LOGGER.warn(e.getMessage());
                            }
                            String entityNames = (String)sheetEntityMap.get(currentSheetName);
                            if (StringUtils.isBlank((CharSequence)entityNames)) {
                                sheetEntityMap.put(currentSheetName, entityName);
                            } else {
                                sheetEntityMap.put(currentSheetName, entityNames + ',' + entityName);
                            }
                        }
                        this.val$templateValidater.add((Object)currentSheetName, row.getData());
                        if (currRowNum == 5) {
                            HashMap<Integer, String> map = new HashMap<Integer, String>();
                            map.put(0, String.valueOf(this.colCount));
                            this.val$templateValidater.add((Object)currentSheetName, map);
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String name) throws SAXException {
                    if (this.getRowHolder().getRowNum() < this.onlyParserCount) {
                        super.endElement(uri, localName, name);
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                }
            };
            new ExcelReader(null).read(file, sheetHandler, false);
        }
        catch (Throwable e) {
            LOGGER.error("TemplateUtils_checkTemplate", e);
            if (e instanceof OLE2NotOfficeXmlFileException) {
                throw new KDBizException(new ErrorCode("909", ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0a\u4f20\u53ef\u80fd\u88ab\u52a0\u5bc6\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateUtils_0", (String)"opmc-epa-business", (Object[])new Object[0])), new Object[0]);
            }
            throw e;
        }
        finally {
            try {
                ImportFileUtil.deleteLocalTempFile(localPath);
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        List<Object> realSheetNames = new ArrayList(10);
        if (null != sheetHandler) {
            realSheetNames = sheetHandler.getAllSheetNames().stream().filter(sheetName -> !sheetName.endsWith("DDM")).collect(Collectors.toList());
        }
        TemplateValidatorServiceImpl validatorService = new TemplateValidatorServiceImpl();
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)validatorService, ITemplateValidatorService.class, (String)"kd.opmc.epa.business.domain.indicator.imp.util.extpoint.ITemplateValidatorService#validate", null);
        List<Object> finalRealSheetNames = realSheetNames;
        List results = pluginProxy.callReplaceIfPresent(arg_0 -> TemplateUtils.lambda$checkTemplate$1(param, (MultiValueMap)templateValidater, finalRealSheetNames, arg_0));
        String msg = (String)results.get(0);
        map.put("msg", msg);
        map.put("optypeText", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TemplateUtils_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        map.put("optype", "new");
        map.put("sheetEntityMap", JSONObject.toJSONString((Object)sheetEntityMap));
        map.put("sheetRowCountMap", JSONObject.toJSONString((Object)sheetRowCountMap));
        map.put("effectSheetNames", JSONObject.toJSONString(effectSheetNamesSetTemp));
        map.put("totalrow", totalRow[0] - 5);
        return map;
    }

    private static String getImporTtypeText(DynamicObject tpl, String val) {
        DynamicProperty prop = tpl.getDynamicObjectType().getProperty("importtype");
        ComboProp temp = (ComboProp)prop;
        String name = "";
        for (ValueMapItem item : temp.getComboItems()) {
            if (!item.getValue().equals(val)) continue;
            name = item.getName().getLocaleValue();
            break;
        }
        return name;
    }

    private static /* synthetic */ String lambda$checkTemplate$1(List param, MultiValueMap templateValidater, List finalRealSheetNames, ITemplateValidatorService p) {
        return p.validate(param, (MultiValueMap<String, Map<Integer, String>>)templateValidater, finalRealSheetNames);
    }
}

