/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.i18n.api.telephone.TelephoneService;
import kd.bos.metadata.form.ControlAp;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ExcelStyleUtil;

public class ValidatorUtils {
    private static final Pattern emailPattern = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+$");
    private static final Pattern emailPatternCN = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+$");
    private static final Map<Function<IDataEntityProperty, Boolean>, BiFunction<String, String, Object>> instanceofMap = Maps.newLinkedHashMapWithExpectedSize((int)16);

    public static boolean validateNumber(String value) {
        try {
            new BigDecimal(value);
        }
        catch (Exception exception) {
            return false;
        }
        int dotIndex = value.indexOf(".");
        if (dotIndex != -1) {
            String integerPart = value.substring(0, dotIndex);
            String decimalPart = value.substring(dotIndex + 1);
            if (HRStringUtils.isEmpty((String)integerPart)) {
                return false;
            }
            if (HRStringUtils.isEmpty((String)decimalPart)) {
                return false;
            }
            if (!ValidatorUtils.validateNumber(integerPart) || !ValidatorUtils.validateNumber(decimalPart)) {
                return false;
            }
        }
        return value.matches("[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+") || value.matches("^[-\\+]?[.\\d]*$");
    }

    public static int validateNumAccuracy(String value) {
        int dotIndex = value.indexOf(".");
        if (dotIndex != -1) {
            String decimalPart = value.substring(dotIndex + 1);
            return decimalPart.length();
        }
        return 0;
    }

    public static boolean isValidDate(String sDate) {
        String formatPattern = "\\d{4}-\\d{2}-\\d{2}";
        String datePattern = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        if (sDate != null) {
            Pattern pattern = Pattern.compile(formatPattern);
            Matcher match = pattern.matcher(sDate);
            if (match.matches()) {
                pattern = Pattern.compile(datePattern);
                match = pattern.matcher(sDate);
                return match.matches();
            }
            return false;
        }
        return false;
    }

    public static void formatValidate(JSONObject data, List<String> errCollect, IDataEntityProperty property, Map<String, String> marksMap) {
        if (data.get((Object)property.getName()) == null) {
            return;
        }
        for (Map.Entry<Function<IDataEntityProperty, Boolean>, BiFunction<String, String, Object>> entry : instanceofMap.entrySet()) {
            if (!entry.getKey().apply(property).booleanValue()) continue;
            try {
                data.put(property.getName(), entry.getValue().apply(data.getString(property.getName()), marksMap.get(property.getName())));
            }
            catch (RuntimeException runtimeException) {
                errCollect.add(data.getString(property.getName()));
            }
            break;
        }
    }

    public static void checkEmailFormat(String emailNumber, List<String> errEmailCollect) {
        if (!emailPattern.matcher(emailNumber).matches() && !emailPatternCN.matcher(emailNumber).matches()) {
            errEmailCollect.add(emailNumber);
        }
    }

    public static void checkTelFormat(String telephone, List<String> errTelephoneCollect, Map<String, String> getCountryToAreaCode) {
        String telephoneStr;
        String areaCode;
        if (telephone.contains("-") && telephone.split("-").length > 1) {
            String[] telephoneArray = telephone.split("-");
            areaCode = getCountryToAreaCode.get(telephoneArray[0]);
            telephoneStr = telephoneArray[1];
        } else {
            areaCode = getCountryToAreaCode.get(RequestContext.get().getLang().getLocale().getCountry());
            telephoneStr = telephone;
        }
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        Map result = service.verifyTelephoneNumberFormat(telephoneStr, new String[]{areaCode});
        if (!Boolean.parseBoolean((String)result.get("code"))) {
            errTelephoneCollect.add("\"" + telephone + "\"" + ((String)result.get("message")).replace("\u3002", ""));
        }
    }

    public static void getControlsFromContains(List<Control> contains, List<String> allTelephoneControls, List<String> allEmailControls, Map<String, String> allDateRangeControls, Map<String, String> allTimeRangeControls) {
        contains.forEach(control -> {
            if (control instanceof TelephoneEdit) {
                allTelephoneControls.add(control.getKey());
            } else if (control instanceof EmailEdit) {
                allEmailControls.add(control.getKey());
            } else if (control instanceof DateRangeEdit) {
                allDateRangeControls.put(((DateRangeEdit)control).getStartDateFieldKey(), ((DateRangeEdit)control).getEndDateFieldKey());
            } else if (control instanceof TimeRangeEdit) {
                allTimeRangeControls.put(((TimeRangeEdit)control).getStartDateFieldKey(), ((TimeRangeEdit)control).getEndDateFieldKey());
            } else if (control instanceof Container) {
                ValidatorUtils.getControlsFromContains(((Container)control).getItems(), allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls);
            }
        });
    }

    public static void getControlsFromContains(List<Control> contains, List<String> allTelephoneControls, List<String> allEmailControls, Map<String, String> allDateRangeControls, Map<String, String> allTimeRangeControls, Map<String, ControlAp<?>> fieldApMap, Map<String, String> marks) {
        contains.forEach(control -> {
            if (control instanceof TelephoneEdit) {
                allTelephoneControls.add(control.getKey());
            } else if (control instanceof EmailEdit) {
                allEmailControls.add(control.getKey());
            } else if (control instanceof DateRangeEdit) {
                allDateRangeControls.put(((DateRangeEdit)control).getStartDateFieldKey(), ((DateRangeEdit)control).getEndDateFieldKey());
                String mask = ExcelStyleUtil.getMask(fieldApMap, ((DateRangeEdit)control).getProperty());
                marks.put(((DateRangeEdit)control).getStartDateFieldKey(), mask);
                marks.put(((DateRangeEdit)control).getEndDateFieldKey(), mask);
            } else if (control instanceof TimeRangeEdit) {
                allTimeRangeControls.put(((TimeRangeEdit)control).getStartDateFieldKey(), ((TimeRangeEdit)control).getEndDateFieldKey());
                marks.put(control.getKey(), ExcelStyleUtil.getMask(fieldApMap, ((TimeRangeEdit)control).getProperty()));
            } else if (control instanceof DateEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask(fieldApMap, ((DateEdit)control).getProperty()));
            } else if (control instanceof DateTimeEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask(fieldApMap, ((DateTimeEdit)control).getProperty()));
            } else if (control instanceof TimeEdit) {
                marks.put(control.getKey(), ExcelStyleUtil.getMask(fieldApMap, ((TimeEdit)control).getProperty()));
            } else if (control instanceof Container) {
                ValidatorUtils.getControlsFromContains(((Container)control).getItems(), allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls, fieldApMap, marks);
            }
        });
    }

    static {
        instanceofMap.put(prop -> prop instanceof BooleanProp, (value, dataFormat) -> {
            if (CommonUtil.getBoolMap(String.valueOf(value)).booleanValue()) {
                return Boolean.TRUE;
            }
            if (CommonUtil.getBooleanOfFalse(String.valueOf(value)).booleanValue()) {
                return Boolean.FALSE;
            }
            throw new RuntimeException();
        });
        instanceofMap.put(prop -> prop instanceof LongProp, (value, dataFormat) -> Long.valueOf(value));
        instanceofMap.put(prop -> prop instanceof BigIntProp, (value, dataFormat) -> Long.valueOf(value));
        instanceofMap.put(prop -> prop instanceof IntegerProp, (value, dataFormat) -> Integer.valueOf(value));
        instanceofMap.put(prop -> prop instanceof DecimalProp, (value, dataFormat) -> new BigDecimal((String)value));
        instanceofMap.put(prop -> prop instanceof DateTimeProp, (value, dataFormat) -> {
            try {
                if (!ValidatorUtils.isValidDate(value)) {
                    throw new RuntimeException();
                }
                return new Timestamp(new SimpleDateFormat((String)dataFormat).parse((String)value).getTime());
            }
            catch (ParseException parseException) {
                throw new RuntimeException();
            }
        });
        instanceofMap.put(prop -> prop instanceof TimeProp, (value, dataFormat) -> {
            try {
                dataFormat = StringUtils.isBlank((CharSequence)dataFormat) ? "HH:mm:ss" : dataFormat;
                return new SimpleDateFormat((String)dataFormat).parse((String)value).toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
            }
            catch (ParseException parseException) {
                throw new RuntimeException();
            }
        });
    }
}

