/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.validators.GroupIndicatorScoreValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;

public class GroupIndicatorNameValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(GroupIndicatorScoreValidator.class);
    private ImportContext importContext;
    private IndicatorGroupDomainService indicatorGroupDomainService;

    public GroupIndicatorNameValidator(IndImportStart importStart) {
        this.importContext = importStart.getImportContext();
        this.indicatorGroupDomainService = IndicatorGroupDomainService.getInstance();
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (!this.importContext.isGroup()) {
            return;
        }
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            String sheetName = next.getSheetName();
            Map<String, Map<String, Object>> areaConfigMap = this.importContext.getAreaConfigMap();
            Map<String, Object> areaMap = areaConfigMap.get(sheetName);
            AtomicBoolean canRemove = new AtomicBoolean(false);
            Long areaInstance = (Long)areaMap.get("areainstance");
            next.getData().forEach((key, val) -> {
                JSONArray array = new JSONArray(1);
                if (val instanceof JSONArray) {
                    array = (JSONArray)val;
                } else if (val instanceof JSONObject) {
                    array.add(val);
                }
                for (Object item : array) {
                    boolean areaRegId;
                    JSONObject rowDataJson = (JSONObject)item;
                    Integer index = rowDataJson.getInteger("$excelIndex");
                    Object objectValue = ImportServiceHelper.getObjectValue(rowDataJson, "indctrname");
                    if (objectValue == null || !(areaRegId = this.indicatorGroupDomainService.checkNameIndicatorAreaEntry((Long)areaMap.get("areaRegId"), areaInstance, (String)objectValue))) continue;
                    String tip = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7684\u503c\u5728\u8be5\u5206\u7ec4\u4e0b\u201d\u5236\u5b9a\u5bf9\u8c61\u201c\u4e2d\u540c\u4e00\u4e2a\u533a\u57df\u6307\u6807\u540d\u79f0\u503c\u91cd\u590d\u3002", (String)"GroupIndicatorNameValidator_0", (String)"opmc-epa-business", (Object[])new Object[]{objectValue});
                    importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                    canRemove.set(true);
                }
            });
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }
}

