/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ValidatorUtils;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;

public final class GroupIndicatorScoreValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(GroupIndicatorScoreValidator.class);
    private ImportContext importContext;
    private ConcurrentHashMap<String, AtomicReference<BigDecimal>> scoreMap = new ConcurrentHashMap(16);

    public GroupIndicatorScoreValidator(IndImportStart importStart) {
        this.importContext = importStart.getImportContext();
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (!this.importContext.isGroup()) {
            return;
        }
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            String sheetName = next.getSheetName();
            this.scoreMap.putIfAbsent(sheetName, new AtomicReference<BigDecimal>(new BigDecimal(0)));
            Map<String, Map<String, Object>> areaConfigMap = this.importContext.getAreaConfigMap();
            Map<String, Object> areaMap = areaConfigMap.get(sheetName);
            String entityName = (String)areaMap.get("entityName");
            AtomicBoolean canRemove = new AtomicBoolean(false);
            if (entityName.equals("epa_genareaindicator")) {
                Long areaInstance = (Long)areaMap.get("areainstance");
                DynamicObject dynamicObject = new HRBaseServiceHelper("epa_genareainstance").loadSingle((Object)areaInstance);
                BigDecimal areaWeight = dynamicObject.getBigDecimal("areaweight");
                BigDecimal areaScore = dynamicObject.getBigDecimal("areascore");
                AtomicReference<BigDecimal> sheetScore = this.scoreMap.get(sheetName);
                next.getData().forEach((key, val) -> {
                    JSONArray array = new JSONArray(1);
                    if (val instanceof JSONArray) {
                        array = (JSONArray)val;
                    } else if (val instanceof JSONObject) {
                        array.add(val);
                    }
                    for (Object item : array) {
                        String tip;
                        Object objectValue;
                        JSONObject rowDataJson = (JSONObject)item;
                        Integer index = rowDataJson.getInteger("$excelIndex");
                        if (ScoreCalcWayEnum.SUM.getValue().equals(this.importContext.getScoreCalcway())) {
                            objectValue = ImportServiceHelper.getObjectValue(rowDataJson, "indctrscore");
                            if (objectValue == null) continue;
                            if (!ValidatorUtils.validateNumber((String)objectValue)) {
                                tip = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6307\u6807\u5206\u503c\"{1}\"\u5fc5\u987b\u662f\u6570\u5b57", (String)"GroupIndicatorScoreValidator_0", (String)"opmc-epa-business", (Object[])new Object[0]), index, objectValue);
                                importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                                canRemove.set(true);
                                continue;
                            }
                            if (this.importContext.getNumAccuracy() != null && ValidatorUtils.validateNumAccuracy((String)objectValue) > Integer.parseInt(this.importContext.getNumAccuracy())) {
                                tip = ResManager.loadKDString((String)"\u201c\u5206\u503c\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"GroupIndicatorScoreValidator_1", (String)"opmc-epa-business", (Object[])new Object[]{objectValue});
                                importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                                canRemove.set(true);
                                continue;
                            }
                            sheetScore.compareAndSet((BigDecimal)sheetScore.get(), ((BigDecimal)sheetScore.get()).add(new BigDecimal((String)objectValue)));
                            if (((BigDecimal)sheetScore.get()).compareTo(areaScore) <= 0) continue;
                            tip = MessageFormat.format(ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u5206\u503c{0}", (String)"GroupIndicatorScoreValidator_2", (String)"opmc-epa-business", (Object[])new Object[0]), areaScore);
                            importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                            canRemove.set(true);
                            continue;
                        }
                        objectValue = ImportServiceHelper.getObjectValue(rowDataJson, "weight");
                        if (objectValue == null) continue;
                        if (!ValidatorUtils.validateNumber((String)objectValue)) {
                            tip = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6307\u6807\u6743\u91cd\"{1}\"\u5fc5\u987b\u662f\u6570\u5b57", (String)"GroupIndicatorScoreValidator_3", (String)"opmc-epa-business", (Object[])new Object[0]), index, objectValue);
                            importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                            canRemove.set(true);
                            continue;
                        }
                        if (this.importContext.getNumAccuracy() != null && ValidatorUtils.validateNumAccuracy((String)objectValue) > Integer.parseInt(this.importContext.getNumAccuracy())) {
                            tip = ResManager.loadKDString((String)"\u201c\u6743\u91cd\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"GroupIndicatorScoreValidator_4", (String)"opmc-epa-business", (Object[])new Object[]{objectValue});
                            importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                            canRemove.set(true);
                            continue;
                        }
                        sheetScore.compareAndSet((BigDecimal)sheetScore.get(), ((BigDecimal)sheetScore.get()).add(new BigDecimal((String)objectValue)));
                        if (((BigDecimal)sheetScore.get()).compareTo(areaWeight) <= 0) continue;
                        tip = ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u6743\u91cd{0}", (String)"GroupIndicatorScoreValidator_5", (String)"opmc-epa-business", (Object[])new Object[]{areaWeight});
                        importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                        canRemove.set(true);
                    }
                });
            }
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }
}

