/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.IFormView;
import kd.bos.form.container.FormRoot;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.indicator.imp.BaseDataContainer;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.ValidateDataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorEnum;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.DataValidateParams;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ExcelStyleUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.util.ValidatorUtils;
import kd.opmc.epa.business.domain.indicator.imp.validators.AbstractValidateHandler;
import kd.opmc.epa.business.domain.indicator.imp.validators.GroupIndicatorNameValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.GroupIndicatorScoreValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndicatorAdjustTypeValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndicatorEvalTypeValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndicatorNameValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndicatorScoreValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;
import kd.opmc.epa.business.domain.indicator.imp.validators.RepeatDataValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.extpoint.IDataValidateService;
import kd.opmc.epa.business.domain.indicator.imp.validators.extpoint.IInnerValidatorBeforeService;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;

public class IndDataValidateManager
extends IndImportWorker {
    private static final Log LOGGER = LogFactory.getLog(IndDataValidateManager.class);
    private Date validateStartTime;
    private ValidateDataFlowSuggester suggester;
    private int workerMaxThread;
    private DataValidateParams dataValidateParams;
    private RepeatDataValidator repeatDataValidator;
    private GroupIndicatorScoreValidator groupIndicatorScoreValidator;
    private IndicatorScoreValidator indicatorScoreValidator;
    private GroupIndicatorNameValidator groupIndicatorNameValidator;
    private IndicatorEvalTypeValidator indicatorEvalTypeValidator;
    private IndicatorNameValidator indicatorNameValidator;
    private IndicatorAdjustTypeValidator indicatorAdjustTypeValidator;
    private MultiValueMap<ValidatorEnum, AbstractValidateHandler> customValidateHandlers = null;
    private static final IDataValidateService DATA_VALIDATE_SERVICE = IDataValidateService.getInstance();
    private static final IInnerValidatorBeforeService INNER_VALIDATOR_BEFORE_SERVICE = IInnerValidatorBeforeService.getInstance();

    public IndDataValidateManager(IndImportStart importStart, ImportQueue<ImportBillData> outQueue, int workerMaxThread) {
        super(IndDataValidateManager.class.getSimpleName(), importStart, importStart.getPaserQueue(), outQueue, workerMaxThread);
        this.workerMaxThread = workerMaxThread;
        this.repeatDataValidator = new RepeatDataValidator(importStart);
        this.groupIndicatorScoreValidator = new GroupIndicatorScoreValidator(importStart);
        this.groupIndicatorNameValidator = new GroupIndicatorNameValidator(importStart);
        this.indicatorEvalTypeValidator = new IndicatorEvalTypeValidator();
        this.indicatorScoreValidator = new IndicatorScoreValidator(importStart);
        this.indicatorNameValidator = new IndicatorNameValidator(importStart);
        this.indicatorAdjustTypeValidator = new IndicatorAdjustTypeValidator(importStart);
        this.suggester = new ValidateDataFlowSuggester(importStart, this.workerMaxThread, outQueue);
    }

    public Date getValidateStartTime() {
        return this.validateStartTime;
    }

    public ValidateDataFlowSuggester getSuggester() {
        return this.suggester;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        ImportContext importContext = this.importStart.getImportContext();
        MethodUtil.syncRequestTraceId(importContext.getRc());
        LOGGER.info("DataValidateManager_started.");
        try {
            importContext.setFormIdEntityFormViewMap(this.initEntityAllFormView());
            IndSaveOpDispatcher saveOpDispatcher = (IndSaveOpDispatcher)this.importStart.getWorkers().get(IndSaveOpDispatcher.class.getSimpleName());
            saveOpDispatcher.getEntityBlankDynamicObjectSemaphore().release();
            LOGGER.info("DataValidateManager_beforeValidate");
            this.beforeValidate();
            while (!this.importStart.isStoped() && !this.isEnd) {
                try {
                    if (!this.canSubmitTask()) continue;
                    List<ImportBillData> batchData = super.getBatchData(1000);
                    LOGGER.info("processInNormalModel_batchDataCount=" + batchData.size());
                    AtomicInteger countInit = new AtomicInteger();
                    batchData.forEach(item -> countInit.getAndAdd(ImportUtil.statisticsBillCount(item)));
                    if (this.validateStartTime == null && countInit.get() > 0) {
                        this.validateStartTime = new Date();
                    }
                    this.dataValidate(batchData, importContext, countInit);
                    this.submitTask(batchData, importContext, countInit);
                }
                catch (Throwable e) {
                    LOGGER.error(e);
                    this.importStart.writeErrorLog(e);
                    this.interruptMainThread();
                }
            }
            super.end(this.workerMaxThread);
        }
        catch (Throwable exception) {
            LOGGER.error("DataValidateManager-call() error:", exception);
            this.importStart.writeErrorLog(exception);
            super.interruptMainThread();
        }
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    private Map<String, IFormView> initEntityAllFormView() {
        long start = System.currentTimeMillis();
        Map<String, Map<String, Object>> areaConfigMap = this.getImportStart().getImportContext().getAreaConfigMap();
        HashMap formIdEntityFormViewMap = Maps.newHashMapWithExpectedSize((int)areaConfigMap.size());
        areaConfigMap.forEach((key, values) -> {
            String entityName = (String)values.get("entityName");
            IFormView mainEntityFormView = CommonUtil.createEntityFormView(entityName);
            formIdEntityFormViewMap.put(entityName, mainEntityFormView);
        });
        this.importStart.getMonitor().addExpenseStatistics("initEntityAllFormView", (Long)(System.currentTimeMillis() - start), true);
        return formIdEntityFormViewMap;
    }

    private void beforeValidate() {
        ImportContext importContext = this.importStart.getImportContext();
        String importType = "new";
        boolean isDeleteTemplate = false;
        this.dataValidateParams = new DataValidateParams(isDeleteTemplate);
        this.dataValidateParams.setSerialModel(importContext.isSerialModel());
        this.dataValidateParams.setBaseDataContainer(new BaseDataContainer());
        this.dataValidateParams.setImportStart(this.importStart);
        this.dataValidateParams.setCellIndexOfEntities(importContext.getCellIndexOfEntities());
        this.dataValidateParams.setCellNameIndexOfEntities(importContext.getCellNameIndexOfEntities());
        HashMap entityToFields = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, Object>> areaConfigMap = importContext.getAreaConfigMap();
        areaConfigMap.forEach((key, values) -> {
            ArrayList fields = Lists.newArrayListWithCapacity((int)16);
            String entityName = (String)values.get("entityName");
            String confEntity = (String)values.get("confEntity");
            Long confId = (Long)values.get("confid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(confEntity);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
            DataEntityPropertyCollection properties = mainType.getProperties();
            DynamicObject conf = serviceHelper.queryOne((Object)confId);
            DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
            for (DynamicObject fieldInfo : entryEntity) {
                DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
                if (!areaField.getBoolean("ismustinput")) continue;
                String fieldKey = fieldInfo.getString("areafield.number");
                properties.stream().filter(x -> HRStringUtils.equals((String)x.getName(), (String)fieldKey)).findFirst().ifPresent(fields::add);
            }
            entityToFields.put(key, fields);
        });
        this.dataValidateParams.setEntity2MustFillInFields(entityToFields);
        this.dataValidateParams.setCountryToAreaCode(ImportServiceHelper.getCountries());
        Map<String, IFormView> formIdEntityFormViewMap = importContext.getFormIdEntityFormViewMap();
        formIdEntityFormViewMap.forEach((key, value) -> {
            ArrayList<String> allTelephoneControls = new ArrayList<String>();
            ArrayList<String> allEmailControls = new ArrayList<String>();
            HashMap<String, String> allDateRangeControls = new HashMap<String, String>();
            HashMap<String, String> allTimeRangeControls = new HashMap<String, String>();
            HashMap<String, String> marks = new HashMap<String, String>();
            Map<String, ControlAp<?>> fieldApMap = ExcelStyleUtil.getFieldControlApMap(key);
            List contains = ((FormRoot)((IFormView)formIdEntityFormViewMap.get(key)).getRootControl()).getItems();
            ValidatorUtils.getControlsFromContains(contains, allTelephoneControls, allEmailControls, allDateRangeControls, allTimeRangeControls, fieldApMap, marks);
            this.dataValidateParams.setNeedFormatTelFields((String)key, (List<String>)allTelephoneControls);
            this.dataValidateParams.setNeedFormatEmailFields((String)key, (List<String>)allEmailControls);
            this.dataValidateParams.setDateRangeFields((String)key, (Map<String, String>)allDateRangeControls);
            this.dataValidateParams.setTimeRangeFields((String)key, (Map<String, String>)allTimeRangeControls);
            this.dataValidateParams.setMarksMap((String)key, (Map<String, String>)marks);
        });
        String permissionStatus = DataValidateServiceHelper.getPermissionStatus(importType);
        HashBasedTable entityToDataRuleScript = HashBasedTable.create();
        String mainFormId = this.importStart.getImportContext().getMainFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainFormId);
        this.putDataRuleScript(importType, permissionStatus, (Table<String, String, BOSExpression>)entityToDataRuleScript, mainFormId, entityType.getAppId());
        this.putFieldControlRules(mainFormId, entityType);
        this.dataValidateParams.setEntity2DataRuleScript((Table<String, String, BOSExpression>)entityToDataRuleScript);
        LOGGER.info("DataValidateManager.beforeValidate()_end");
    }

    private void putDataRuleScript(String importType, String permissionStatus, Table<String, String, BOSExpression> entityToDataRuleScript, String entityFormId, String appId) {
        LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_before,permissionStatus:{},entityFormId:{},appId:{}", new Object[]{permissionStatus, entityFormId, appId});
        BOSExpression bosExpression = DataValidateServiceHelper.getDataRuleScript(permissionStatus, entityFormId, appId);
        entityToDataRuleScript.put((Object)entityFormId, (Object)permissionStatus, (Object)bosExpression);
        LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_new,entityFormId:{},bosExpression:{}", (Object)entityFormId, (Object)bosExpression.toString());
        if (importType.equalsIgnoreCase("updateandnew")) {
            bosExpression = DataValidateServiceHelper.getDataRuleScript("4715a0df000000ac", entityFormId, appId);
            entityToDataRuleScript.put((Object)entityFormId, (Object)"4715a0df000000ac", (Object)bosExpression);
            LOGGER.info("DataValidateManager_getDataRuleScript()_permissionStatus_modify,entityFormId:{},bosExpression:{}", (Object)entityFormId, (Object)bosExpression.toString());
        }
    }

    private void putFieldControlRules(String entityFormId, MainEntityType baseEntityType) {
        Set<String> nonFieldPermSet = DataValidateServiceHelper.getFieldControlRules(baseEntityType.getAppId(), entityFormId);
        LOGGER.info("DataValidateManager_getFieldControlRules(),appId:{},entityFormId:{},nonFieldPermSet:{}", new Object[]{baseEntityType.getAppId(), entityFormId, nonFieldPermSet});
        if (nonFieldPermSet != null) {
            this.dataValidateParams.setNonFieldPermMap(entityFormId, nonFieldPermSet);
        }
    }

    private boolean canSubmitTask() {
        this.suggester.runDataFlowSuggest();
        if (this.suggester.getSuggestThreads() <= this.childThreadMonitor.get()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void dataValidate(List<ImportBillData> batchData, ImportContext importContext, AtomicInteger countInit) {
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)DATA_VALIDATE_SERVICE, IDataValidateService.class, (String)"kd.opmc.epa.business.domain.indicator.imp.validators.extpoint.IDataValidateService#dataValidate", (PluginFilter)null);
        proxy.callReplaceIfPresent(validata -> validata.dataValidate(batchData, importContext, countInit, this));
    }

    private void submitTask(List<ImportBillData> batchData, ImportContext importContext, AtomicInteger countInit) {
        String taskName = this.getClass().getSimpleName() + "_task";
        super.submitWithTimeOut(() -> {
            long start = System.currentTimeMillis();
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            AtomicInteger beforeDataValidatorCount = new AtomicInteger();
            try {
                this.childThreadMonitor.getAndIncrement();
                MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
                batchData.forEach(item -> beforeDataValidatorCount.getAndAdd(ImportUtil.statisticsBillCount(item)));
                List<ImportBillData> billDataList = this.handleBatchData(batchData);
                this.validatePutToOutQueue(billDataList);
            }
            catch (Throwable e) {
                LOGGER.error("DataValidateManager-processInNormalModel(),error:", e);
                this.importStart.writeErrorLog(e);
                ImportUtil.writeExceptionRowLog(batchData, this.importStart, e);
                importContext.addFinishedBillCount(beforeDataValidatorCount.get());
            }
            finally {
                this.importStart.getImportContext().addFinishedValidateBillCount(countInit.get());
                long spense = System.currentTimeMillis() - start;
                this.importStart.getMonitor().addExpenseStatistics(taskName, (Long)spense, false);
                this.childThreadMonitor.getAndDecrement();
                this.childThreadSemaphore.release();
            }
            return null;
        });
    }

    protected List<ImportBillData> handleBatchData(List<ImportBillData> billDataList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList toSort = Lists.newArrayList((Object[])ValidatorEnum.values());
        toSort.sort(Comparator.comparing(ValidatorEnum::getOrder));
        for (ValidatorEnum validator : toSort) {
            AbstractValidateHandler validateHandler = null;
            LinkedList<AbstractValidateHandler> list = new LinkedList<AbstractValidateHandler>();
            if (!StringUtils.isBlank((CharSequence)validator.getClassName())) {
                Class<?> validatorClass = Class.forName(validator.getClassName());
                validateHandler = (AbstractValidateHandler)validatorClass.newInstance();
            }
            if (this.customValidateHandlers != null && this.customValidateHandlers.get((Object)validator) != null) {
                List tempList = (List)this.customValidateHandlers.get((Object)validator);
                boolean has = tempList.stream().allMatch(x -> x.getValidatorOrderEnum() == ValidatorOrderEnum.REPLACE || x.getValidatorOrderEnum() == ValidatorOrderEnum.IGNORE);
                if (!has && validateHandler != null) {
                    list.add(validateHandler);
                }
                list.addAll(tempList);
                tempList.sort(Comparator.comparing(AbstractValidateHandler::getValidatorOrderEnum));
            } else if (validateHandler != null) {
                list.add(validateHandler);
            }
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)INNER_VALIDATOR_BEFORE_SERVICE, IInnerValidatorBeforeService.class, (String)"kd.opmc.epa.business.domain.indicator.imp.validators.extpoint.IInnerValidatorBeforeService#beforeInnerValidate", (PluginFilter)null);
            proxy.callReplaceIfPresent(validates -> validates.beforeInnerValidate(list));
            if (list.isEmpty()) continue;
            list.forEach(validatorTemp -> {
                if (this.importStart.isStoped()) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (validatorTemp instanceof InnerValidateHandler) {
                    InnerValidateHandler handler = (InnerValidateHandler)validatorTemp;
                    handler.setCustomParams(this.dataValidateParams);
                    validatorTemp.validate(billDataList, this.importStart.getImportContext().getImportLog());
                } else if (validatorTemp.getValidatorOrderEnum() != ValidatorOrderEnum.IGNORE) {
                    validatorTemp.validate(billDataList, this.importStart.getImportContext().getImportLog());
                }
                long spense = System.currentTimeMillis() - start;
                String simpleName = validatorTemp.getClass().getSimpleName();
                LOGGER.info(simpleName + "_validator_end.cost=" + spense);
                this.importStart.getMonitor().addExpenseStatistics(simpleName, (Long)spense, false);
            });
        }
        return billDataList;
    }

    protected void validatePutToOutQueue(List<ImportBillData> dataList) {
        if (this.dataValidateParams != null) {
            this.getImportStart().getImportContext().setBaseDataContainer(this.dataValidateParams.getBaseDataContainer());
        }
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = this.getImportStart().getImportContext().getImportLog().getRowErrors();
        List<ImportBillData> collect = dataList.stream().filter(billData -> {
            billData.clearBaseDataJson();
            ConcurrentHashMap errLogMap = (ConcurrentHashMap)rowErrors.get(billData.getSheetName());
            if (errLogMap == null) {
                return true;
            }
            Enumeration keys = errLogMap.keys();
            while (keys.hasMoreElements()) {
                Integer row = (Integer)keys.nextElement();
                if (billData.getStartIndex() > row || billData.getEndIndex() < row) continue;
                this.importStart.getImportContext().addFinishedBillCount(ImportUtil.statisticsBillCount(billData));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (collect.size() > 0) {
            super.putToOutQueue(collect);
            collect.forEach(item -> {
                int count = ImportUtil.statisticsBillCount(item);
                this.importStart.getImportContext().addSuccessedValidateBillCount(count);
            });
        }
    }
}

