/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ValidatorUtils;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;

public class IndicatorAdjustTypeValidator
extends InnerValidateHandler {
    private ImportContext importContext;

    public IndicatorAdjustTypeValidator(IndImportStart importStart) {
        this.importContext = importStart.getImportContext();
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            String sheetName = next.getSheetName();
            Map<String, Map<String, Object>> areaConfigMap = this.importContext.getAreaConfigMap();
            BigDecimal maxScore = this.importContext.getMaxScore();
            BigDecimal minScore = this.importContext.getMinScore();
            Map<String, Object> areaMap = areaConfigMap.get(sheetName);
            String entityName = (String)areaMap.get("entityName");
            Long confId = (Long)areaMap.get("confid");
            AtomicBoolean canRemove = new AtomicBoolean(false);
            if (entityName.equals("epa_genareaind_assign") || entityName.equals("epa_genareaindicator")) {
                DynamicObject conf = AssessFormDomainService.getInstance().queryNormalConfigByPk(confId);
                boolean isAllowEval = conf.getBoolean("reversepoints");
                String numAccuracy = this.importContext.getNumAccuracy();
                next.getData().forEach((key, val) -> {
                    JSONArray array = new JSONArray(1);
                    if (val instanceof JSONArray) {
                        array = (JSONArray)val;
                    } else if (val instanceof JSONObject) {
                        array.add(val);
                    }
                    HashMap<Integer, Set> errorLog = new HashMap<Integer, Set>(16);
                    for (Object item : array) {
                        String tip;
                        String tip2;
                        JSONObject rowDataJson = (JSONObject)item;
                        Integer index2 = rowDataJson.getInteger("$excelIndex");
                        HashSet<String> tips2 = new HashSet<String>(16);
                        errorLog.put(index2, tips2);
                        if (!isAllowEval || !HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) continue;
                        Object lowerScoreObj = ImportServiceHelper.getObjectValue(rowDataJson, "minevalscore");
                        Object upperScoreObj = ImportServiceHelper.getObjectValue(rowDataJson, "maxevalscore");
                        boolean checkFlag = false;
                        if (HRObjectUtils.isEmpty((Object)upperScoreObj)) {
                            tip2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"IndicatorAdjustTypeValidator_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                            tips2.add(tip2);
                            checkFlag = true;
                            canRemove.set(true);
                        }
                        if (HRObjectUtils.isEmpty((Object)lowerScoreObj)) {
                            tip2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"IndicatorAdjustTypeValidator_1", (String)"opmc-epa-business", (Object[])new Object[0]);
                            tips2.add(tip2);
                            checkFlag = true;
                            canRemove.set(true);
                        }
                        if (checkFlag) continue;
                        if (!ValidatorUtils.validateNumber((String)upperScoreObj)) {
                            tip2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5fc5\u987b\u662f\u5206\u503c", (String)"IndicatorAdjustTypeValidator_2", (String)"opmc-epa-business", (Object[])new Object[0]);
                            tips2.add(tip2);
                            canRemove.set(true);
                            checkFlag = true;
                        }
                        if (!ValidatorUtils.validateNumber((String)lowerScoreObj)) {
                            tip2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5fc5\u987b\u662f\u5206\u503c", (String)"IndicatorAdjustTypeValidator_3", (String)"opmc-epa-business", (Object[])new Object[0]);
                            tips2.add(tip2);
                            canRemove.set(true);
                            checkFlag = true;
                        }
                        if (checkFlag) continue;
                        if (numAccuracy != null && ValidatorUtils.validateNumAccuracy((String)upperScoreObj) > Integer.parseInt(numAccuracy)) {
                            tip2 = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"IndicatorAdjustTypeValidator_4", (String)"opmc-epa-business", (Object[])new Object[]{upperScoreObj});
                            canRemove.set(true);
                            checkFlag = true;
                            tips2.add(tip2);
                        }
                        if (numAccuracy != null && ValidatorUtils.validateNumAccuracy((String)lowerScoreObj) > Integer.parseInt(numAccuracy)) {
                            tip2 = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"IndicatorAdjustTypeValidator_4", (String)"opmc-epa-business", (Object[])new Object[]{lowerScoreObj});
                            canRemove.set(true);
                            checkFlag = true;
                            tips2.add(tip2);
                        }
                        if (checkFlag) continue;
                        BigDecimal upperScore = new BigDecimal((String)upperScoreObj);
                        BigDecimal lowerScore = new BigDecimal((String)lowerScoreObj);
                        if (upperScore.compareTo(new BigDecimal(0)) < 0) {
                            tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u22650", (String)"IndicatorAdjustTypeValidator_5", (String)"opmc-epa-business", (Object[])new Object[0]);
                            canRemove.set(true);
                            tips2.add(tip);
                        }
                        if (upperScore.compareTo(maxScore) > 0) {
                            tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"IndicatorAdjustTypeValidator_6", (String)"opmc-epa-business", (Object[])new Object[0]);
                            canRemove.set(true);
                            tips2.add(tip);
                        }
                        if (upperScore.compareTo(lowerScore) <= 0) {
                            tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u9700\uff1e\u8c03\u6574\u5206\u4e0b\u9650", (String)"IndicatorAdjustTypeValidator_7", (String)"opmc-epa-business", (Object[])new Object[0]);
                            canRemove.set(true);
                            tips2.add(tip);
                        }
                        if (maxScore.compareTo(new BigDecimal(0)) >= 0) {
                            if (lowerScore.compareTo(maxScore.negate()) >= 0) continue;
                            tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206\u7684\u76f8\u53cd\u6570\u3002", (String)"IndicatorAdjustTypeValidator_8", (String)"opmc-epa-business", (Object[])new Object[0]);
                            canRemove.set(true);
                            tips2.add(tip);
                            continue;
                        }
                        if (lowerScore.compareTo(maxScore) > 0) {
                            canRemove.set(true);
                            tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"IndicatorAdjustTypeValidator_9", (String)"opmc-epa-business", (Object[])new Object[0]);
                            tips2.add(tip);
                        }
                        if (lowerScore.compareTo(minScore) >= 0) continue;
                        canRemove.set(true);
                        tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u4f4e\u5206", (String)"IndicatorAdjustTypeValidator_10", (String)"opmc-epa-business", (Object[])new Object[0]);
                        tips2.add(tip);
                    }
                    if (!errorLog.isEmpty()) {
                        errorLog.forEach((index, tips) -> {
                            if (!tips.isEmpty()) {
                                String tip = String.join((CharSequence)";", tips);
                                importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), (int)index, tip);
                            }
                        });
                    }
                });
            }
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }
}

