/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.extplugin.PluginFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.extpoint.INotValidateIndFieldService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.impl.NotValidateIndFieldService;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ValidatorUtils;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;

public class IndicatorEvalTypeValidator
extends InnerValidateHandler {
    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        DynamicObject blankDynamicObject = new HRBaseServiceHelper("epa_genareaind_assign").generateEmptyDynamicObject();
        ComboProp comboProp = (ComboProp)blankDynamicObject.getDynamicObjectType().getProperties().get((Object)"evaltype");
        Map<String, String> map = comboProp.getComboItems().stream().collect(Collectors.toMap(pro -> pro.getName().getLocaleValue(), ValueMapItem::getValue));
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            AtomicBoolean canRemove = new AtomicBoolean(false);
            next.getData().forEach((key, val) -> {
                JSONArray array = new JSONArray(1);
                if (val instanceof JSONArray) {
                    array = (JSONArray)val;
                } else if (val instanceof JSONObject) {
                    array.add(val);
                }
                HashMap<Integer, Set> errorLog = new HashMap<Integer, Set>(16);
                for (Object item : array) {
                    JSONObject rowDataJson = (JSONObject)item;
                    Integer index2 = rowDataJson.getInteger("$excelIndex");
                    Object evalType = ImportServiceHelper.getObjectValue(rowDataJson, "evaltype");
                    if (evalType == null) continue;
                    HashSet<String> tips2 = new HashSet<String>(16);
                    errorLog.put(index2, tips2);
                    String type = (String)map.get(String.valueOf(evalType));
                    if (!HRStringUtils.equals((String)type, (String)"20")) continue;
                    NotValidateIndFieldService notValidateService = new NotValidateIndFieldService();
                    HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)notValidateService, INotValidateIndFieldService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.INotValidateIndFieldService#getNotValidateField", (PluginFilter)null);
                    List result = proxy.callReplaceIfPresent(INotValidateIndFieldService::getNotValidateField);
                    Set notValidateFields = new HashSet(16);
                    if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty(result.get(0))) {
                        notValidateFields = (Set)result.get(0);
                    }
                    Object qualityTarget = ImportServiceHelper.getObjectValue(rowDataJson, "qualitytarget");
                    if (!notValidateFields.contains("qualitytarget") && qualityTarget != null && this.opValidate((String)qualityTarget)) {
                        String tip = MessageFormat.format(ResManager.loadKDString((String)"\u76ee\u6807\u503c\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"IndicatorEvalTypeValidator_0", (String)"opmc-epa-business", (Object[])new Object[0]), qualityTarget);
                        canRemove.set(true);
                        tips2.add(tip);
                    }
                    Object qualityDare = ImportServiceHelper.getObjectValue(rowDataJson, "qualitydare");
                    if (!notValidateFields.contains("qualitydare") && qualityDare != null && this.opValidate((String)qualityDare)) {
                        String tip = MessageFormat.format(ResManager.loadKDString((String)"\u6311\u6218\u503c\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"IndicatorEvalTypeValidator_1", (String)"opmc-epa-business", (Object[])new Object[0]), qualityTarget);
                        tips2.add(tip);
                        canRemove.set(true);
                    }
                    Object qualityBase = ImportServiceHelper.getObjectValue(rowDataJson, "qualitybase");
                    if (!notValidateFields.contains("qualitybase") && qualityBase != null && this.opValidate((String)qualityBase)) {
                        String tip = MessageFormat.format(ResManager.loadKDString((String)"\u5e95\u7ebf\u503c\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"IndicatorEvalTypeValidator_2", (String)"opmc-epa-business", (Object[])new Object[0]), qualityTarget);
                        tips2.add(tip);
                        canRemove.set(true);
                    }
                    Object qualityRes = ImportServiceHelper.getObjectValue(rowDataJson, "qualityres");
                    if (notValidateFields.contains("qualityres") || qualityRes == null || !this.opValidate((String)qualityRes)) continue;
                    String tip = MessageFormat.format(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u503c\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"IndicatorEvalTypeValidator_3", (String)"opmc-epa-business", (Object[])new Object[0]), qualityRes);
                    tips2.add(tip);
                    canRemove.set(true);
                }
                if (!errorLog.isEmpty()) {
                    errorLog.forEach((index, tips) -> {
                        if (!tips.isEmpty()) {
                            String tip = String.join((CharSequence)";", tips);
                            importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), (int)index, tip);
                        }
                    });
                }
            });
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }

    public boolean opValidate(String value) {
        return !ValidatorUtils.validateNumber(value);
    }
}

