/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.validators.GroupIndicatorScoreValidator;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;

public class IndicatorNameValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(GroupIndicatorScoreValidator.class);
    private ImportContext importContext;

    public IndicatorNameValidator(IndImportStart importStart) {
        this.importContext = importStart.getImportContext();
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (this.importContext.isGroup()) {
            return;
        }
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            String sheetName = next.getSheetName();
            Map<String, Map<String, Object>> areaConfigMap = this.importContext.getAreaConfigMap();
            Map<String, Object> areaMap = areaConfigMap.get(sheetName);
            String entityName = (String)areaMap.get("entityName");
            AtomicBoolean canRemove = new AtomicBoolean(false);
            Long areaInstance = (Long)areaMap.get("areainstance");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
            DynamicObject[] instance = hrBaseServiceHelper.query("indctrname", new QFilter[]{new QFilter("instanceid", "in", (Object)areaInstance)});
            List names = Arrays.stream(instance).map(ins -> ins.getString("indctrname")).collect(Collectors.toList());
            next.getData().forEach((key, val) -> {
                JSONArray array = new JSONArray(1);
                if (val instanceof JSONArray) {
                    array = (JSONArray)val;
                } else if (val instanceof JSONObject) {
                    array.add(val);
                }
                for (Object item : array) {
                    JSONObject rowDataJson = (JSONObject)item;
                    Integer index = rowDataJson.getInteger("$excelIndex");
                    Object objectValue = ImportServiceHelper.getObjectValue(rowDataJson, "indctrname");
                    if (objectValue == null || !names.contains(objectValue)) continue;
                    String tip = MessageFormat.format(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0", (String)"IndicatorNameValidator_0", (String)"opmc-epa-business", (Object[])new Object[0]), objectValue);
                    importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                    canRemove.set(true);
                }
            });
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }
}

