/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.BaseDataContainer;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.DataValidateParams;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.ImportUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.AbstractValidateHandler;
import org.apache.commons.lang3.StringUtils;

class InnerValidateHandler
extends AbstractValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(InnerValidateHandler.class);
    protected boolean isEnable = true;
    private DataValidateParams customParams;

    InnerValidateHandler() {
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean enable) {
        this.isEnable = enable;
    }

    public void setCustomParams(DataValidateParams customParams) {
        this.customParams = customParams;
    }

    public DataValidateParams getDataValidateParams() {
        return this.customParams;
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return null;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
    }

    protected Object getPutWhereKey(DynamicObject dynamicObject, String customKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName) {
        String realNumber = (String)bdFieldMainPropName.get("number");
        String realName = (String)bdFieldMainPropName.get("name");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)realNumber)) {
            jsonObject.put(realNumber, dynamicObject.get(customKey.concat(realNumber)));
        }
        if (StringUtils.isNotEmpty((CharSequence)realName)) {
            jsonObject.put(realName, dynamicObject.get(customKey.concat(realName)));
        }
        if ("number_name".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("$bdSplit", (Object)"##");
        }
        if ("id".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("id", dynamicObject.get("id"));
        }
        return this.getPutWhereKey(jsonObject, baseDataFormat, bdFieldMainPropName);
    }

    protected Object getPutWhereKey(JSONObject valueJson, String baseDataFormat, Map<String, Object> bdFieldMainPropName) {
        return ImportServiceHelper.getPutWhereKey(valueJson, baseDataFormat, bdFieldMainPropName);
    }

    protected String getFieldKey(String fieldKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName) {
        if (!"number_name".equalsIgnoreCase(baseDataFormat)) {
            Object val = bdFieldMainPropName.get(baseDataFormat);
            String keytmp = val instanceof PKFieldProp ? "id" : (String)val;
            fieldKey = fieldKey.concat(".").concat(keytmp);
        }
        return fieldKey;
    }

    protected String getCellIndex(String fieldKey, String mainEntityId) {
        Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
        Map<String, String> cellIndexOfEntities = this.getDataValidateParams().getCellIndexOfEntities(mainEntityId);
        String cellIndex = cellIndexOfEntities.get(fieldKey);
        try {
            if (StringUtils.isBlank((CharSequence)cellIndex)) {
                DynamicObject fieldDy = tplFieldConfig.get(mainEntityId).get(ImportUtil.getLevelOneKey(fieldKey));
                String dbFormat = fieldDy.getString("imptattr");
                fieldKey = cellIndexOfEntities.get(fieldKey.concat(".").concat(dbFormat)) == null ? fieldKey.concat(".").concat(Lang.get().toString()) : fieldKey.concat(".").concat(dbFormat);
                cellIndex = cellIndexOfEntities.get(fieldKey);
            }
        }
        catch (NullPointerException exception) {
            LOGGER.info("AbstractValidateHandler.getCellIndex(),fieldKey:{},cellIndexOfEntities:{},mainEntityId:{}", new Object[]{fieldKey, cellIndexOfEntities, mainEntityId});
        }
        return cellIndex;
    }

    protected String getCellName(String fieldCellIndex, String mainEntityId) {
        Map<String, String> cellNameIndexOfEntities = this.getDataValidateParams().getCellNameIndexOfEntities(mainEntityId);
        LOGGER.info("============================{}=================================", cellNameIndexOfEntities);
        return cellNameIndexOfEntities.get(fieldCellIndex);
    }

    protected List<Long> getPermMainBU(BaseDataContainer baseDataContainer, MainEntityType entityType, String entityNumber) {
        List<Long> permBU = baseDataContainer.getPermBU(entityNumber);
        if (permBU == null) {
            if (StringUtils.isBlank((CharSequence)entityType.getMainOrg())) {
                permBU = Collections.singletonList(-2L);
            } else {
                String appId = DataValidateServiceHelper.getBizAppId(entityNumber);
                String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)entityNumber);
                LOGGER.info("ControlledBaseDataValidator--getPermOrg(),orgViewType:{},appId2:{},entityNumber:{}", new Object[]{orgViewType, appId, entityNumber});
                HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityNumber, (String)"47150e89000000ac");
                LOGGER.info("ControlledBaseDataValidator--getPermOrg(),hasAllOrgPerm:{},hasPermOrgs:{},entityNumber:{}", new Object[]{result.hasAllOrgPerm(), result.getHasPermOrgs(), entityNumber});
                permBU = result.hasAllOrgPerm() ? Collections.singletonList(-2L) : (Objects.isNull(result.getHasPermOrgs()) || result.getHasPermOrgs().size() == 0 ? Collections.singletonList(-1L) : result.getHasPermOrgs());
            }
            baseDataContainer.setPermBU(entityNumber, permBU);
        }
        return permBU;
    }
}

