/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;
import org.apache.commons.lang3.StringUtils;

public final class MustFillInValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(MustFillInValidator.class);

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable() || this.getDataValidateParams().isDeleteTemplate() || Objects.isNull(this.getDataValidateParams())) {
            return;
        }
        Map<String, List<IDataEntityProperty>> entityToFields = this.getDataValidateParams().getEntity2MustFillInFields();
        for (ImportBillData billData : billDataList) {
            for (Map.Entry entry : billData.getData().entrySet()) {
                String sheetName = billData.getSheetName();
                String entityNum = (String)entry.getKey();
                Object dataJson = entry.getValue();
                if (dataJson instanceof JSONArray) {
                    for (Object data : (JSONArray)dataJson) {
                        this.checkData(entityNum, billData, importLog, entityToFields.get(sheetName), (JSONObject)data);
                    }
                    continue;
                }
                this.checkData(entityNum, billData, importLog, entityToFields.get(sheetName), (JSONObject)dataJson);
            }
        }
    }

    private void checkData(String entityNum, ImportBillData billData, ImportLog importLog, List<IDataEntityProperty> entityOfMustFillFields, JSONObject dataJson) {
        if (entityOfMustFillFields == null) {
            return;
        }
        entityOfMustFillFields.remove(null);
        entityOfMustFillFields.forEach(fieldProp -> {
            String fieldKey = fieldProp.getName();
            if (fieldProp.getParent() instanceof EntryType) {
                JSONArray entryJsonArray = dataJson.getJSONArray(fieldProp.getParent().getName());
                if (entryJsonArray != null) {
                    entryJsonArray.forEach(entryJsonOb -> this.checkMustFillField(entityNum, billData, importLog, (IDataEntityProperty)fieldProp, (JSONObject)entryJsonOb, fieldKey));
                }
            } else {
                this.checkMustFillField(entityNum, billData, importLog, (IDataEntityProperty)fieldProp, dataJson, fieldKey);
            }
        });
        this.checkRangeFields(entityNum, billData, importLog, 12, this.getDataValidateParams().getDateRangeFields(billData.getMainEntityId()), dataJson);
        this.checkRangeFields(entityNum, billData, importLog, 15, this.getDataValidateParams().getTimeRangeFields(billData.getMainEntityId()), dataJson);
        dataJson.values().stream().filter(value -> value instanceof JSONArray && ((JSONArray)value).getJSONObject(0).containsKey((Object)"$excelIndex")).forEach(value2 -> ((JSONArray)value2).forEach(jsonOb -> {
            this.checkRangeFields(entityNum, billData, importLog, 12, this.getDataValidateParams().getDateRangeFields(billData.getMainEntityId()), (JSONObject)jsonOb);
            this.checkRangeFields(entityNum, billData, importLog, 15, this.getDataValidateParams().getTimeRangeFields(billData.getMainEntityId()), (JSONObject)jsonOb);
        }));
    }

    private void checkRangeFields(String entityNum, ImportBillData billData, ImportLog importLog, int errType, Map<String, String> rangeFields, JSONObject dataJson) {
        if (rangeFields == null) {
            return;
        }
        rangeFields.forEach((key, value) -> {
            if (dataJson.containsKey(key) && !dataJson.containsKey(value)) {
                String cellIndex = this.getCellIndex((String)value, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(errType, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNum));
            } else if (!dataJson.containsKey(key) && dataJson.containsKey(value)) {
                String cellIndex = this.getCellIndex((String)key, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(errType + 1, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNum));
            } else {
                this.compareDateOrTime(entityNum, billData, importLog, errType, dataJson, (String)key, (String)value);
            }
        });
    }

    private void compareDateOrTime(String entityNum, ImportBillData billData, ImportLog importLog, int errType, JSONObject dataJson, String key, String value) {
        try {
            if (dataJson.containsKey((Object)key) && dataJson.containsKey((Object)value)) {
                if (errType == 12 && ((Timestamp)dataJson.getTimestamp(key)).after((Timestamp)dataJson.getTimestamp(value))) {
                    DataValidateServiceHelper.writeRowErrorLog(errType + 2, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), this.getCellIndex(key, entityNum), this.getCellIndex(value, entityNum));
                } else if (errType == 15 && LocalTime.parse(dataJson.getString(key)).isAfter(LocalTime.parse(dataJson.getString(value)))) {
                    DataValidateServiceHelper.writeRowErrorLog(errType + 2, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), this.getCellIndex(key, entityNum), this.getCellIndex(value, entityNum));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.info("MustFillInValidator.compareDateOrTime(),error:{}", (Object)exception.getMessage());
        }
    }

    private void checkMustFillField(String entityNum, ImportBillData billData, ImportLog importLog, IDataEntityProperty fieldProp, JSONObject dataJsonValue, String fieldKey) {
        int rowIndex = dataJsonValue.getIntValue("$excelIndex");
        LOGGER.info("============rowIndex:{}, fieldKey:{}, value:{}", new Object[]{rowIndex, fieldKey, dataJsonValue.get((Object)fieldKey)});
        if (!dataJsonValue.containsKey((Object)fieldKey) || Objects.isNull(dataJsonValue.get((Object)fieldKey))) {
            String cellIndex = this.getCellIndex(fieldKey, entityNum);
            LOGGER.info("============cellIndex:{},fieldKey:{}, entityNum:{}", new Object[]{cellIndex, fieldKey, entityNum});
            DataValidateServiceHelper.writeRowErrorLog(0, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNum));
        } else if (fieldProp instanceof MuliLangTextProp && dataJsonValue.get((Object)fieldProp.getName()) instanceof JSONObject && StringUtils.isBlank((CharSequence)dataJsonValue.getJSONObject(fieldProp.getName()).getString(Lang.get().toString()))) {
            fieldKey = fieldKey.concat(".").concat(Lang.get().toString());
            String cellIndex = this.getCellIndex(fieldKey, entityNum);
            LOGGER.info("**************cellIndex:{},fieldKey:{}, entityNum:{}", new Object[]{cellIndex, fieldKey, entityNum});
            DataValidateServiceHelper.writeRowErrorLog(0, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNum));
        }
    }
}

