/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ValidatorOrderEnum;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.helper.ImportServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportLog;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.InnerValidateHandler;

public final class RepeatDataValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(RepeatDataValidator.class);
    private Map<String, Map<Integer, Object>> tempMap;
    private Map<String, List<String>> uniqueKeyFieldsFormatMap;
    private ImportContext importContext;

    public RepeatDataValidator(IndImportStart importStart) {
        this.importContext = importStart.getImportContext();
        this.tempMap = Maps.newHashMapWithExpectedSize((int)this.importContext.getSheetRowCountMap().size());
        this.uniqueKeyFieldsFormatMap = Maps.newHashMapWithExpectedSize((int)this.importContext.getSheetRowCountMap().size());
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        ArrayList uniqueKeyFieldsMapdsFormat = Lists.newArrayListWithCapacity((int)1);
        uniqueKeyFieldsMapdsFormat.add("indctrname");
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            String sheetName = next.getSheetName();
            AtomicBoolean canRemove = new AtomicBoolean(false);
            next.getData().forEach((key, val) -> {
                JSONArray array = new JSONArray(1);
                if (val instanceof JSONArray) {
                    array = (JSONArray)val;
                } else if (val instanceof JSONObject) {
                    array.add(val);
                }
                for (Object item : array) {
                    JSONObject rowDataJson = (JSONObject)item;
                    Integer index = rowDataJson.getInteger("$excelIndex");
                    StringBuilder uniqueValBuilder = new StringBuilder();
                    for (String field : uniqueKeyFieldsMapdsFormat) {
                        Object objectValue = ImportServiceHelper.getObjectValue(rowDataJson, field);
                        uniqueValBuilder.append(objectValue);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)uniqueValBuilder.toString())) continue;
                    int hashCode = uniqueValBuilder.toString().hashCode();
                    Map<Integer, Object> hashMap = this.tempMap.getOrDefault(sheetName, Maps.newHashMapWithExpectedSize((int)16));
                    Object exsit = hashMap.get(hashCode);
                    if (exsit == null) {
                        hashMap.put(hashCode, index);
                        this.tempMap.put(sheetName, hashMap);
                        continue;
                    }
                    String tip = ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepeatDataValidator_0", (String)"opmc-epa-business", (Object[])new Object[]{exsit});
                    importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                    canRemove.set(true);
                }
            });
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }

    private List<String> formatUniqueKeyFields(String entityId) {
        String values = this.importContext.getEntityIdToUniqueValMap().get(entityId);
        String[] split = StringUtils.split((String)values, (String)",");
        List<String> uniqueKeyFields = Arrays.asList(split);
        ArrayList<String> uniqueKeyFieldsFormat = new ArrayList<String>(uniqueKeyFields.size());
        uniqueKeyFields.forEach(key -> {
            DynamicProperty property = this.importContext.getEntityType().getProperty(key);
            if (property instanceof BasedataProp) {
                Map<String, Object> bdMainProp = MethodUtil.getBdMainProp(((BasedataProp)property).getBaseEntityId());
                DynamicObject fieldDy = this.importContext.getTplFieldConfig().get(entityId).get(key);
                String baseDataFormatValue = fieldDy.getString("imptattr");
                if ("number_name".equalsIgnoreCase(baseDataFormatValue)) {
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get("number"));
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get("name"));
                } else if ("id".equalsIgnoreCase(baseDataFormatValue)) {
                    uniqueKeyFieldsFormat.add(key + ".id");
                } else {
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get(baseDataFormatValue));
                }
            } else {
                uniqueKeyFieldsFormat.add((String)key);
            }
        });
        return uniqueKeyFieldsFormat;
    }
}

