/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.validators;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.constant.IndConstant;
import kd.opmc.epa.business.domain.indicator.imp.util.CommonUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.AbstractTemplateValidator;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import org.springframework.util.MultiValueMap;

public class TemplateValidator
extends AbstractTemplateValidator {
    private static final Log LOGGER = LogFactory.getLog(TemplateValidator.class);
    private List<String> realSheetNames;

    public TemplateValidator(List<String> realSheetNames) {
        this.realSheetNames = realSheetNames;
    }

    public String validate(MultiValueMap<String, Map<Integer, String>> data, List<Map<String, Object>> param) {
        LOGGER.info("TemplateValidator.validate(),data:{}", (Object)data.toString());
        StringBuilder errMsg = new StringBuilder();
        if (CollectionUtils.isEmpty(param)) {
            return errMsg.append(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u6307\u6807\u533a\u914d\u7f6e\u4fe1\u606f\u3002", (String)"TemplateValidator_0", (String)"opmc-epa-business", (Object[])new Object[0])).append(IndConstant.LINE_SEPARATOR).toString();
        }
        HashMap nameConfig = new HashMap(16);
        HashMap<String, String> numberConfig = new HashMap<String, String>(16);
        HashMap entryMap = new HashMap(16);
        param.stream().forEach(item -> {
            Long confId = (Long)item.get("confid");
            HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_normalconf");
            DynamicObject conf = HELPER.queryOne((Object)confId);
            String customName = conf.getString("areacustname");
            DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
            entryMap.put(customName, entryEntity);
            boolean isAllowEval = conf.getBoolean("reversepoints");
            String adjustType = conf.getString("adjusttype");
            nameConfig.put(customName, isAllowEval && !"1".equals(adjustType));
            String entityName = (String)item.get("entityName");
            numberConfig.put(customName, entityName);
        });
        Set notLoadFiled = Arrays.stream(AssessTableConfConstants.GEN_IGNORE_FIELD).collect(Collectors.toSet());
        Map<String, Map<String, DynamicObject>> areaFieldMap = entryMap.entrySet().stream().collect(Collectors.toMap(itemK -> (String)itemK.getKey(), itemV -> {
            HashMap<String, DynamicObject> fieldMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject fieldInfo : (DynamicObjectCollection)itemV.getValue()) {
                String fieldKey = fieldInfo.getString("areafield.number");
                if (notLoadFiled.contains(fieldKey)) continue;
                DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
                fieldMap.put(fieldKey, areaField);
            }
            return fieldMap;
        }));
        for (Map.Entry<String, Map> stringMapEntry : areaFieldMap.entrySet()) {
            String key = stringMapEntry.getKey();
            Map value = stringMapEntry.getValue();
            MainEntityType EntityType2 = EntityMetadataCache.getDataEntityType((String)"epa_areafieldreg");
            if (((Boolean)nameConfig.get(key)).booleanValue()) {
                DynamicObject minEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
                minEvalScoreField.set("number", (Object)"minevalscore");
                minEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650", (String)"TemplateValidator_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                minEvalScoreField.set("ismustinput", (Object)Boolean.TRUE);
                value.put("minevalscore", minEvalScoreField);
                DynamicObject maxEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
                maxEvalScoreField.set("number", (Object)"maxevalscore");
                maxEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650", (String)"TemplateValidator_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                maxEvalScoreField.set("ismustinput", (Object)Boolean.TRUE);
                value.put("maxevalscore", maxEvalScoreField);
            }
            DynamicObject maxEvalScoreField = new DynamicObject((DynamicObjectType)EntityType2);
            maxEvalScoreField.set("number", (Object)"iseditable");
            maxEvalScoreField.set("name", (Object)ResManager.loadKDString((String)"\u5141\u8bb8\u4fee\u6539", (String)"TemplateValidator_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            maxEvalScoreField.set("ismustinput", (Object)Boolean.FALSE);
            value.put("iseditable", maxEvalScoreField);
        }
        if (this.realSheetNames.size() != areaFieldMap.size()) {
            return errMsg.append(ResManager.loadKDString((String)"Excel\u6587\u6863\u4e2dsheet\u6570\u91cf\u9700\u4e0e\u8bc4\u4f30\u8868\u5355\u8bbe\u8ba1\u4e2d\u533a\u57df\u6570\u91cf\u4fdd\u6301\u4e00\u81f4\u3002", (String)"TemplateValidator_4", (String)"opmc-epa-business", (Object[])new Object[0])).append(IndConstant.LINE_SEPARATOR).toString();
        }
        for (String sheetName : this.realSheetNames) {
            if (areaFieldMap.containsKey(sheetName)) continue;
            return errMsg.append(ResManager.loadKDString((String)"Excel\u6587\u6863\u4e2dsheet\u540d\u79f0\u4e0e\u8bc4\u4f30\u8868\u5355\u8bbe\u8ba1\u4e2d\u533a\u57df\u540d\u79f0\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"TemplateValidator_5", (String)"opmc-epa-business", (Object[])new Object[0])).append(IndConstant.LINE_SEPARATOR).toString();
        }
        boolean flag = Boolean.FALSE;
        int firstDataRowNum = 6;
        for (Map.Entry sheetDatas : data.entrySet()) {
            this.validateRowData(areaFieldMap, sheetDatas, numberConfig, errMsg);
            if (((List)sheetDatas.getValue()).size() <= firstDataRowNum) continue;
            flag = Boolean.TRUE;
        }
        if (!flag) {
            errMsg.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u6240\u6709sheet\u9875\u524d10\u884c\u65e0\u6570\u636e\uff0c\u89c6\u4e3a\u8be5\u6a21\u677f\u4e3a\u7a7a\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"TemplateValidator_6", (String)"opmc-epa-business", (Object[])new Object[0])).append(IndConstant.LINE_SEPARATOR);
        }
        return errMsg.toString();
    }

    private void validateRowData(Map<String, Map<String, DynamicObject>> fieldSetMapping, Map.Entry<String, List<Map<Integer, String>>> sheetDatas, Map<String, String> numberConfig, StringBuilder errMsg) {
        ArrayList errInfo = Lists.newArrayList();
        String sheetName = sheetDatas.getKey();
        List<Map<Integer, String>> sheetData = sheetDatas.getValue();
        Map<String, DynamicObject> fieldMap = fieldSetMapping.get(sheetName);
        List ismustinputFields = fieldMap.entrySet().stream().filter(item -> ((DynamicObject)item.getValue()).getBoolean("ismustinput")).map(it -> (String)it.getKey()).collect(Collectors.toList());
        List allConfigFields = fieldMap.entrySet().stream().map(it -> (String)it.getKey()).collect(Collectors.toList());
        if (sheetData.size() < 4) {
            errInfo.add(sheetName);
            this.addErrMsg("-2", errMsg, sheetName, 6, errInfo);
            return;
        }
        String numberRow = sheetData.get(0).get(0);
        String entityNameSp = CommonUtil.getSplitValue(numberRow);
        String entityName = numberConfig.get(sheetName);
        if (StringUtils.isNotEmpty((String)entityName) && !entityName.equals(entityNameSp)) {
            errInfo.add(entityNameSp);
            this.addErrMsg("-6", errMsg, sheetName, 2, errInfo);
            errInfo.clear();
        }
        Collection<String> sheetFieldCollection = sheetData.get(3).values();
        if (CollectionUtils.isNotEmpty(ismustinputFields)) {
            ismustinputFields.stream().forEach(ismustinputField -> {
                if (!sheetFieldCollection.contains(ismustinputField)) {
                    errInfo.add(ismustinputField);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)errInfo)) {
                this.addErrMsg("2", errMsg, sheetName, 5, errInfo);
                errInfo.clear();
            }
        }
        if (CollectionUtils.isNotEmpty(sheetFieldCollection)) {
            sheetFieldCollection.stream().forEach(field -> {
                if (!allConfigFields.contains(field)) {
                    errInfo.add(field);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)errInfo)) {
                this.addErrMsg("3", errMsg, sheetName, 5, errInfo);
                errInfo.clear();
            }
        }
    }
}

