/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.FinishedDataPackage;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;

public class IndImportWorker
implements Callable<Object> {
    private static Log log = LogFactory.getLog(IndImportWorker.class);
    protected String name;
    protected IndImportStart importStart;
    private Thread parentThread;
    protected ImportQueue<ImportBillData> inQueue;
    protected ImportQueue<ImportBillData> outQueue;
    protected ThreadPool pool;
    protected boolean isEnd = false;
    protected AtomicInteger childThreadMonitor = new AtomicInteger(0);
    protected Semaphore childThreadSemaphore;

    public IndImportWorker(String name, IndImportStart importStart, ImportQueue<ImportBillData> inQueue, ImportQueue<ImportBillData> outQueue, int workerMaxThread) {
        this.name = name;
        this.importStart = importStart;
        this.inQueue = inQueue;
        this.outQueue = outQueue;
        this.parentThread = Thread.currentThread();
        if (workerMaxThread > 0) {
            this.pool = ThreadPools.newCachedThreadPool((String)(this.name + RequestContext.get().getTraceId()), (int)1, (int)workerMaxThread);
            this.childThreadSemaphore = new Semaphore(workerMaxThread);
        }
    }

    public IndImportWorker(String name, IndImportStart importStart) {
        this.name = name;
        this.importStart = importStart;
        this.parentThread = Thread.currentThread();
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    public ThreadPool getPool() {
        return this.pool;
    }

    public IndImportStart getImportStart() {
        return this.importStart;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public String getName() {
        return this.name;
    }

    public AtomicInteger getChildThreadMonitor() {
        return this.childThreadMonitor;
    }

    public Semaphore getChildThreadSemaphore() {
        return this.childThreadSemaphore;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                List<ImportBillData> tempBilldatas = this.getBatchData(1000);
                this.putToOutQueue(tempBilldatas);
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        this.end();
        return null;
    }

    protected void end() {
        this.end(MCConfigConstant.getWorkerMaxThread());
    }

    protected void end(int workerMaxThread) {
        this.isEnd = true;
        if (this.childThreadSemaphore != null) {
            try {
                boolean result = this.childThreadSemaphore.tryAcquire(workerMaxThread, 20L, TimeUnit.MINUTES);
                if (!result) {
                    throw new KDException(new ErrorCode("901", "waiteThreadPoolFinished_timeout."), new Object[0]);
                }
                this.childThreadSemaphore.release(workerMaxThread);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        if (this.outQueue != null) {
            int count = 100;
            this.putToOutQueue(new FinishedDataPackage(), count);
        }
        if (this.pool != null) {
            this.pool.close();
        }
        log.info(this.name.concat("_normally_finished!"));
    }

    public void waiteChildFinished() {
        this.waiteChildFinished(MCConfigConstant.getWorkerMaxThread());
    }

    public void waiteChildFinished(int workerMaxThread) {
        if (this.childThreadSemaphore != null) {
            try {
                boolean result = this.childThreadSemaphore.tryAcquire(workerMaxThread, 20L, TimeUnit.MINUTES);
                if (!result) {
                    throw new KDException(new ErrorCode("901", "waiteThreadPoolFinished_timeout."), new Object[0]);
                }
                this.childThreadSemaphore.release(workerMaxThread);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
    }

    protected List<ImportBillData> getBatchData(int size) {
        ArrayList<ImportBillData> tempBilldatas = new ArrayList<ImportBillData>(size);
        if (this.importStart.isStoped() || this.isEnd) {
            return tempBilldatas;
        }
        int count = this.inQueue.getQueue().drainTo(tempBilldatas, size);
        if (count == 0) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
            }
            return tempBilldatas;
        }
        if (tempBilldatas.get(tempBilldatas.size() - 1) instanceof FinishedDataPackage) {
            tempBilldatas.remove(tempBilldatas.size() - 1);
            this.isEnd = true;
        }
        return tempBilldatas;
    }

    protected void putToOutQueue(List<ImportBillData> dataList) {
        for (ImportBillData data : dataList) {
            int count = 100;
            this.putToOutQueue(data, count);
        }
    }

    public void putToOutQueue(ImportBillData data, int count) {
        try {
            boolean result = this.outQueue.getQueue().offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.importStart.getMonitor().addQueueStatistics(this.outQueue.getName(), 0, -1);
                if (count < 10) {
                    this.importStart.getMonitor().addQueueStatistics(this.name + "_timeOut", 1, null);
                }
                if (count < 1) {
                    throw new KDBizException(new ErrorCode("906", this.name + "'s outQueue has full.and no retry times"), new Object[0]);
                }
                if (!this.importStart.isStoped()) {
                    this.putToOutQueue(data, --count);
                }
            } else {
                this.importStart.getMonitor().addQueueStatistics(this.outQueue.getName(), 1, this.outQueue.getQueue().size());
            }
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            if ("906".equalsIgnoreCase(e.getErrorCode().getCode())) {
                ImportRowErrorLog log = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), e.getErrorCode().getMessage(), this.importStart.getImportContext().getImportLog());
                this.importStart.writeRowErrorLog(log);
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.getImportStart().writeErrorLog(e);
        }
    }

    public void putToInQueue(List<ImportBillData> dataList) {
        for (ImportBillData data : dataList) {
            this.putToInQueue(data);
        }
    }

    protected void putToInQueue(ImportBillData data) {
        try {
            boolean result = this.inQueue.getQueue().offer(data, 10L, TimeUnit.SECONDS);
            if (!result) {
                this.importStart.getMonitor().addQueueStatistics(this.inQueue.getName(), 0, -1);
                if (!this.importStart.isStoped()) {
                    this.putToInQueue(data);
                }
            } else {
                this.importStart.getMonitor().addQueueStatistics(this.inQueue.getName(), 1, this.inQueue.getQueue().size());
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.getImportStart().writeErrorLog(e);
        }
    }

    protected synchronized void interruptMainThread() {
        if (!this.importStart.isMainThreadInterrupt()) {
            log.info(this.getClass().getSimpleName() + "trigger_interruptThread.");
            if (!this.importStart.getImportContext().isUserHasTerminator()) {
                this.importStart.getImportContext().setSysTerminator(true);
            }
            this.getParentThread().interrupt();
            this.importStart.setMainThreadInterrupt(true);
        }
    }

    protected void submitWithTimeOut(Callable<Object> task) {
        try {
            long start = System.currentTimeMillis();
            if (!this.childThreadSemaphore.tryAcquire(20L, TimeUnit.MINUTES)) {
                throw new KDException(new ErrorCode("900", "waiteHasFreePoolThread_timeout."), new Object[0]);
            }
            this.importStart.getMonitor().addExpenseStatistics(this.getName() + "_submitWithTimeOut", (Long)(System.currentTimeMillis() - start), false);
            this.pool.submit(task);
        }
        catch (Throwable e) {
            this.importStart.writeErrorLog(e);
            this.interruptMainThread();
        }
    }
}

