/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.BaseDataContainer;
import kd.opmc.epa.business.domain.indicator.imp.DataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.ValidateDataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportPerformance;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportSampling;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportTrace;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndDataValidateManager;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndReporter;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndSaveOpDispatcher;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTempStoreDispatcher;

public class IndMonitor
extends IndImportWorker {
    private static Log log = LogFactory.getLog(IndReporter.class);
    private long lastRunTimeStap = System.currentTimeMillis();
    private ReentrantLock expenseLock = new ReentrantLock();
    private ReentrantLock queueLock = new ReentrantLock();
    private ReentrantLock cacheLock = new ReentrantLock();
    private ReentrantLock otherLock = new ReentrantLock();
    private ReentrantLock memsLock = new ReentrantLock();
    private ImportPerformance importPerformance = new ImportPerformance();
    private ImportSampling importSampling = new ImportSampling();
    private ImportTrace importTrace = new ImportTrace();

    public ImportPerformance getImportPerformance() {
        return this.importPerformance;
    }

    public void setImportPerformance(ImportPerformance importPerformance) {
        this.importPerformance = importPerformance;
    }

    public ImportSampling getImportSampling() {
        return this.importSampling;
    }

    public void setImportSampling(ImportSampling importSampling) {
        this.importSampling = importSampling;
    }

    public ImportTrace getImportTrace() {
        return this.importTrace;
    }

    public void setImportTrace(ImportTrace importTrace) {
        this.importTrace = importTrace;
    }

    public IndMonitor(IndImportStart importStart) {
        super(IndMonitor.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                BaseDataContainer baseDataContainer;
                IndImportWorker importWorker3;
                IndImportWorker importWorker2;
                TimeUnit.MILLISECONDS.sleep(2000L);
                ImportQueue<ImportBillData> paserQueue = this.importStart.getPaserQueue();
                this.addSamplingData(paserQueue.getName(), paserQueue.getQueue().size());
                ImportQueue<ImportBillData> tempStoreQueue = this.importStart.getTempStoreQueue();
                this.addSamplingData(tempStoreQueue.getName(), tempStoreQueue.getQueue().size());
                ImportQueue<ImportBillData> bdValidateresultQueue = this.importStart.getWaitInStoreQueue();
                this.addSamplingData(bdValidateresultQueue.getName(), bdValidateresultQueue.getQueue().size());
                IndImportWorker importWorker = this.importStart.getWorkers().get(IndSaveOpDispatcher.class.getSimpleName());
                if (importWorker != null) {
                    IndSaveOpDispatcher saveOpDispatcher = (IndSaveOpDispatcher)importWorker;
                    DataFlowSuggester suggester = saveOpDispatcher.getSuggester();
                    this.addSamplingData("suggestBatchSize", suggester.getSuggestBatchSize());
                    this.addSamplingData("suggestThreads", suggester.getSuggestThreads());
                    this.addSamplingData(saveOpDispatcher.getName() + "_workingThreadCount", saveOpDispatcher.getChildThreadMonitor().get());
                }
                if ((importWorker2 = this.importStart.getWorkers().get(IndTempStoreDispatcher.class.getSimpleName())) != null) {
                    IndTempStoreDispatcher tempStoreDispatcher = (IndTempStoreDispatcher)importWorker2;
                    this.addSamplingData(tempStoreDispatcher.getName() + "_workingThreadCount", tempStoreDispatcher.getChildThreadMonitor().get());
                }
                if ((importWorker3 = this.importStart.getWorkers().get(IndDataValidateManager.class.getSimpleName())) != null) {
                    IndDataValidateManager dataValidateManager = (IndDataValidateManager)importWorker3;
                    ValidateDataFlowSuggester suggester = dataValidateManager.getSuggester();
                    this.addSamplingData("Validator_suggestThreads", suggester.getSuggestThreads());
                    this.addSamplingData(dataValidateManager.getName() + "_workingThreadCount", dataValidateManager.getChildThreadMonitor().get());
                }
                if ((baseDataContainer = this.importStart.getImportContext().getBaseDataContainer()) != null && System.currentTimeMillis() - this.lastRunTimeStap > 30000L) {
                    Map<Object, DynamicObject> existsEntityDyMap = baseDataContainer.getExistsEntityDyMap();
                    this.addSamplingData("basedataIdTableCount", baseDataContainer.getBasedataIdTable().values().size());
                    this.addSamplingData("basedataTableCount", baseDataContainer.getBasedataTable().values().size());
                    this.addSamplingData("existsEntityDyMapCount", existsEntityDyMap.size());
                }
                Map<String, String> samplingCpuMem = MethodUtil.samplingCpuMem();
                this.addSamplingData("memory", samplingCpuMem.get("memory"));
                this.addSamplingData("cpu", samplingCpuMem.get("cpu"));
                if (!"true".equals(MCConfigConstant.isPrintMonitorLog()) || System.currentTimeMillis() - this.lastRunTimeStap <= 60000L) continue;
                log.info("Performancelog->{}", (Object)this.getPerformancelog());
                this.lastRunTimeStap = System.currentTimeMillis();
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        log.info(this.name + "_timeOut_started.");
        Date start = new Date();
        while (!this.isEnd) {
            LinkedList alives = new LinkedList();
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
                Map<String, IndImportWorker> workers = this.importStart.getWorkers();
                workers.values().forEach(worker -> {
                    if (!worker.isEnd() && !this.name.equalsIgnoreCase(worker.getName())) {
                        alives.add(worker);
                    }
                });
                if (System.currentTimeMillis() - start.getTime() <= 600000L) continue;
                alives.forEach(worker -> {
                    worker.setEnd(true);
                    try {
                        MethodUtil.shutdownNowThreadPool(worker.getPool());
                    }
                    catch (Throwable e) {
                        log.error(e);
                    }
                });
                List names = alives.stream().map(de -> de.getName()).collect(Collectors.toList());
                this.importTrace.getOther().put("timeOutWorkers", names);
                this.isEnd = true;
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.end();
        return null;
    }

    public String getPerformancelog() {
        HashMap jsonMap = Maps.newHashMapWithExpectedSize((int)3);
        jsonMap.put("performance", this.importStart.getMonitor().getImportPerformance());
        jsonMap.put("trace", this.importStart.getMonitor().getImportTrace());
        jsonMap.put("sampling", this.importStart.getMonitor().getImportSampling());
        return JSONObject.toJSONString((Object)jsonMap);
    }

    public void addExpenseStatistics(Class obj, Long value, boolean isSingle) {
        String simpleName = obj.getSimpleName();
        this.addExpenseStatistics(simpleName, value, isSingle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpenseStatistics(String key, Long value, boolean isSingle) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.expenseLock.lock();
            ConcurrentHashMap<String, Integer> totalExpense = this.importPerformance.getTotalExpense();
            Integer oldValue = (Integer)totalExpense.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalExpense.put(key, Math.toIntExact(value));
            } else {
                totalExpense.put(key, Math.toIntExact((long)oldValue.intValue() + value));
            }
            if (isSingle) {
                return;
            }
            this.addMaxExpense(key, value);
            this.addTotalExcuteCount(key);
        }
        finally {
            this.expenseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueStatistics(String key, Integer value, Integer total) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.queueLock.lock();
            ConcurrentHashMap<String, Integer> totalQueueCount = this.importPerformance.getTotalQueueCount();
            Integer oldValue = (Integer)totalQueueCount.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalQueueCount.put(key, value);
            } else {
                totalQueueCount.put(key, oldValue + value);
            }
            if (total != null) {
                this.addMaxQueueCount(key, total);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTotalCachedCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.cacheLock.lock();
            ConcurrentHashMap<String, Integer> totalCachedCount = this.importPerformance.getTotalCachedCount();
            Integer oldValue = (Integer)totalCachedCount.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalCachedCount.put(key, value);
            } else {
                totalCachedCount.put(key, oldValue + value);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherTotalCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getOther();
            Integer oldValue = (Integer)other.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                other.put(key, value);
            } else {
                other.put(key, oldValue + value);
            }
        }
        finally {
            this.otherLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMEMSTotalCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.memsLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getMems();
            Integer oldValue = (Integer)other.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                other.put(key, value);
            } else {
                other.put(key, oldValue + value);
            }
        }
        finally {
            this.memsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherListData(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getOther();
            List logs = (List)other.computeIfAbsent(key, val -> new LinkedList());
            logs.add(value);
        }
        finally {
            this.otherLock.unlock();
        }
    }

    public void addSamplingData(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        Map<String, List<Object>> sampling = this.importSampling.getSampling();
        List logs = sampling.computeIfAbsent(key, val -> new LinkedList());
        logs.add(value);
    }

    public synchronized void computeAverageExpense() {
        for (Map.Entry<String, Integer> next : this.importPerformance.getTotalExpense().entrySet()) {
            Integer count = this.importPerformance.getTotalExcuteCount().get(next.getKey());
            if (ObjectUtils.isEmpty((Object)count)) continue;
            int avg = next.getValue() / count;
            this.importPerformance.getAverageExpense().put(next.getKey(), avg);
        }
    }

    private void addMaxExpense(String key, Long value) {
        ConcurrentHashMap<String, Integer> maxExpense = this.importPerformance.getMaxExpense();
        Integer oldValue = (Integer)maxExpense.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1L)) {
            maxExpense.put(key, Math.toIntExact(value));
        } else if (value > (long)oldValue.intValue()) {
            maxExpense.put(key, Math.toIntExact(value));
        }
    }

    private void addTotalExcuteCount(String key) {
        ConcurrentHashMap<String, Integer> totalExcuteCount = this.importPerformance.getTotalExcuteCount();
        Integer count = (Integer)totalExcuteCount.get(key);
        if (ObjectUtils.isEmpty((Object)count)) {
            totalExcuteCount.put(key, 1);
        } else {
            count = count + 1;
            totalExcuteCount.put(key, count);
        }
    }

    private void addMaxQueueCount(String key, Integer value) {
        ConcurrentHashMap<String, Integer> maxQueueCount = this.importPerformance.getMaxQueueCount();
        Integer oldValue = (Integer)maxQueueCount.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1)) {
            maxQueueCount.put(key, value);
        } else if (!oldValue.equals(-1) && value > oldValue) {
            maxQueueCount.put(key, value);
        }
    }
}

