/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.ExcelImportSheetHandler;
import kd.opmc.epa.business.domain.indicator.imp.ExcelReader;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;

public class IndParser
extends IndImportWorker {
    private static final Log LOGGER = LogFactory.getLog(IndParser.class);
    private Semaphore fileDownloadSemaphore = new Semaphore(1);
    private Map<String, String> entityEntryFields;
    private Map<String, List<ImportBillData>> sheetDataSamplingMap = new HashMap<String, List<ImportBillData>>(6);

    public IndParser(IndImportStart importStart) {
        super(IndParser.class.getSimpleName(), importStart, null, importStart.getPaserQueue(), 0);
    }

    public Semaphore getFileDownloadSemaphore() {
        return this.fileDownloadSemaphore;
    }

    public Map<String, String> getEntityEntryFields() {
        return this.entityEntryFields;
    }

    public Map<String, List<ImportBillData>> getSheetDataSamplingMap() {
        return this.sheetDataSamplingMap;
    }

    public void setSheetDataSamplingMap(Map<String, List<ImportBillData>> sheetDataSamplingMap) {
        this.sheetDataSamplingMap = sheetDataSamplingMap;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        LOGGER.info("Parser_started.");
        try {
            this.resolveExcel();
            super.end();
        }
        catch (Throwable exception) {
            LOGGER.error("Parser-call() error:", exception);
            this.importStart.writeErrorLog(exception);
            super.interruptMainThread();
        }
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    protected void resolveExcel() throws Exception {
        ImportContext importContext = this.importStart.getImportContext();
        this.fileDownloadSemaphore.acquire();
        this.fileDownloadSemaphore.release();
        File file = new File(importContext.getFileLocalPath());
        if (importContext.getFileType().equalsIgnoreCase(".xlsx")) {
            ExcelImportSheetHandler excelImportSheetHandler = new ExcelImportSheetHandler(this);
            new ExcelReader(this.importStart).read(file, excelImportSheetHandler, false);
            importContext.setMergeCellList(excelImportSheetHandler.getMergeCellList());
        }
    }
}

