/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.api.HRImExptTaskServiceHelper;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.ImportCacheKeyType;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndReporter;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndTimeRemainingAnalyser;

public class IndProgresser
extends IndImportWorker {
    private static Log log = LogFactory.getLog(IndReporter.class);
    private int lastProgressUpload;

    public IndProgresser(IndImportStart importStart) {
        super(IndProgresser.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        ImportContext importContext = this.importStart.getImportContext();
        MethodUtil.syncRequestTraceId(importContext.getRc());
        log.info("Progresser_started.");
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("hasGetAllAssessTotalBillCount", false);
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                int totalBillCount = importContext.getTotalBillCount();
                int totalRowCount = importContext.getTotalRowCount();
                int finishedRowCount = importContext.getFinishedRowCount();
                int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
                int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
                float finishedBillCount = importContext.getFinishedBillCount().floatValue();
                IndImportWorker importWorker = this.importStart.getWorkers().get(IndParser.class.getSimpleName());
                if (importWorker != null && !importWorker.isEnd()) {
                    IndTimeRemainingAnalyser.getAssessTotalBillCount(importContext, params);
                    int assessTotalBillCount = (Integer)params.get("assessTotalBillCount");
                    if (assessTotalBillCount > importContext.getTotalBillCount()) {
                        totalBillCount = assessTotalBillCount;
                        this.importStart.getMonitor().getImportTrace().getOther().put("progUsedAssessCount", true);
                    }
                }
                HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
                customData.put("totalRowCount", String.valueOf(totalRowCount));
                customData.put("finishedRowCount", String.valueOf(finishedRowCount));
                customData.put("totalBillCount", String.valueOf(totalBillCount));
                customData.put("finishedBillCount", String.valueOf((int)finishedBillCount));
                customData.put("finishedValidateBillCount", String.valueOf(finishedValidateBillCount));
                customData.put("successedValidateBillCount", String.valueOf(successedValidateBillCount));
                IndTimeRemainingAnalyser timeRemainingAnalyser = (IndTimeRemainingAnalyser)this.importStart.getWorkers().get(IndTimeRemainingAnalyser.class.getSimpleName());
                customData.put("validateTimeRemaining", timeRemainingAnalyser.getValidateTimeRemaining());
                int progressUpload = this.getAnalysisProgress(finishedBillCount, totalBillCount);
                int timeRemaining = timeRemainingAnalyser.getTimeRemaining();
                if (!importContext.isCanUserTerminate()) {
                    Map<String, Integer> virtualProcess = MethodUtil.getVirtualProcess(progressUpload, timeRemainingAnalyser.getTimeRemaining(), finishedBillCount, totalBillCount);
                    progressUpload = virtualProcess.get("progress");
                    timeRemaining = virtualProcess.get("timeRemaining");
                    Integer finishedBillCount2 = virtualProcess.get("finishedBillCount");
                    if (finishedBillCount2 != null) {
                        customData.put("finishedBillCount", String.valueOf(finishedBillCount2));
                    }
                }
                customData.put("timeRemaining", timeRemaining);
                customData.put("progress", progressUpload);
                String taskPKId = String.valueOf(this.importStart.getImportContext().getTaskPkId());
                IHRAppCache cache = HRAppCache.get((String)"epa");
                cache.put(MethodUtil.getTaskCachePath(taskPKId, ImportCacheKeyType.IMPORT, "processing"), (Object)customData);
                if (progressUpload <= 0 || progressUpload == this.lastProgressUpload) continue;
                this.lastProgressUpload = progressUpload;
                HRImExptTaskServiceHelper.feedbackProgress((String)taskPKId, (int)progressUpload, (String)ImportCacheKeyType.IMPORT);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }

    private int getAnalysisProgress(float finishedBillCount, int totalBillCount) {
        float progress = 0.0f;
        if (finishedBillCount > 0.0f) {
            progress = finishedBillCount / (float)totalBillCount * 100.0f;
        } else if (totalBillCount <= 1000) {
            progress = 50.0f;
        } else if (totalBillCount <= 2000) {
            progress = 40.0f;
        } else if (totalBillCount <= 3000) {
            progress = 30.0f;
        } else if (totalBillCount <= 4000) {
            progress = 20.0f;
        } else if (totalBillCount <= 5000) {
            progress = 10.0f;
        } else if (totalBillCount <= 6000) {
            progress = 5.0f;
        }
        if (progress < 1.0f) {
            progress = 1.0f;
        }
        return (int)progress;
    }
}

