/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.opmc.epa.business.domain.indicator.imp.DataFlowSuggester;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.constant.OprType;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.task.CallDeleteOperationTask;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.extpoint.IIndSaveOpDispatcherService;

public class IndSaveOpDispatcher
extends IndImportWorker {
    private static Log log = LogFactory.getLog(IndSaveOpDispatcher.class);
    protected AtomicInteger dataCanStopFlag = new AtomicInteger(0);
    private Table<String, String, Map<String, String>> comboItems = HashBasedTable.create();
    protected Map<String, ImportQueue<ImportBillData>> groupImportBillData = Maps.newHashMapWithExpectedSize((int)6);
    private Date callopStartTime;
    private int workerMaxThread;
    private DataFlowSuggester suggester;
    private Semaphore entityBlankDynamicObjectSemaphore = new Semaphore(1);
    private Map<String, DynamicObject> entityBlankDynamicObject = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, String> entitySheetMap = Maps.newHashMapWithExpectedSize((int)6);
    private static final IIndSaveOpDispatcherService IND_SAVE_OP_DISPATCHER_SERVICE = IIndSaveOpDispatcherService.getInstance();

    public Date getCallopStartTime() {
        return this.callopStartTime;
    }

    public IndSaveOpDispatcher(IndImportStart importStart, int workerMaxThread) {
        super(IndSaveOpDispatcher.class.getSimpleName(), importStart, importStart.getWaitInStoreQueue(), null, workerMaxThread);
        this.workerMaxThread = workerMaxThread;
        this.suggester = new DataFlowSuggester(importStart, this.workerMaxThread);
        this.suggester.initDataFlowSuggest();
    }

    public int getWorkerMaxThread() {
        return this.workerMaxThread;
    }

    public Table<String, String, Map<String, String>> getComboItems() {
        return this.comboItems;
    }

    public Semaphore getEntityBlankDynamicObjectSemaphore() {
        return this.entityBlankDynamicObjectSemaphore;
    }

    public DataFlowSuggester getSuggester() {
        return this.suggester;
    }

    public void setSuggester(DataFlowSuggester suggester) {
        this.suggester = suggester;
    }

    public Map<String, DynamicObject> getEntityBlankDynamicObject() {
        return this.entityBlankDynamicObject;
    }

    public Map<String, String> getEntitySheetMap() {
        return this.entitySheetMap;
    }

    @Override
    public Object call() {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        try {
            this.initEntitySheetMap();
            this.setOperateOption();
            this.waiteInitEntityBlankDynamicObject();
            this.initComboItems();
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                this.suggester.runDataFlowSuggest();
                if (this.suggester.getSuggestThreads() <= this.childThreadMonitor.get()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e);
                    }
                    continue;
                }
                int suggestBatchSize = this.suggester.getSuggestBatchSize();
                List<ImportBillData> tempBilldatas = this.getBatchData(suggestBatchSize);
                log.info(this.name + "_receivedTempBilldatas.count=" + tempBilldatas.size());
                List<String> effectSheetNames = this.importStart.getImportContext().getEffectSheetNames();
                if (CollectionUtils.isNotEmpty(effectSheetNames) && effectSheetNames.size() > 1) {
                    this.groupImportBillData(tempBilldatas);
                    for (Map.Entry<String, ImportQueue<ImportBillData>> next : this.groupImportBillData.entrySet()) {
                        ImportQueue<ImportBillData> dataQueue = next.getValue();
                        this.submitTask(dataQueue, suggestBatchSize);
                    }
                    continue;
                }
                if (this.callopStartTime == null) {
                    this.callopStartTime = new Date();
                }
                if (tempBilldatas.size() <= 0) continue;
                this.submitToCallOpTask(tempBilldatas.get(0).getMainEntityId(), tempBilldatas);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        this.end();
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void end() {
        Object cache;
        if (this.dataCanStopFlag.get() <= 0) {
            this.importStart.getImportContext().setCanUserTerminate(false);
            cache = HRAppCache.get((String)"epa");
            cache.put(MethodUtil.getTaskCachePath(String.valueOf(this.importStart.getImportContext().getTaskPkId()), OprType.IMPORT.getValue(), "status"), (Object)"canotstop");
        }
        super.end(this.workerMaxThread);
        cache = this.importStart.syncLock;
        synchronized (cache) {
            this.importStart.syncLock.notify();
        }
        if (this.groupImportBillData != null && this.groupImportBillData.size() > 0) {
            StringBuilder builder = new StringBuilder("groupImportBillData_queue_size,");
            this.groupImportBillData.values().forEach(queue -> builder.append(queue.getName()).append("=").append(queue.getQueue().size()).append(","));
            log.info(builder.toString());
        }
    }

    private void submitTask(ImportQueue<ImportBillData> dataQueue, int suggestBatchSize) {
        ArrayList<ImportBillData> dataCall = new ArrayList<ImportBillData>(0);
        int size = dataQueue.getQueue().size();
        if (this.isEnd && size > 0) {
            if (this.callopStartTime == null) {
                this.callopStartTime = new Date();
            }
            dataCall = new ArrayList(size);
            dataQueue.getQueue().drainTo(dataCall, size);
            log.info("submitTask_isEnd_dataCall.count=" + dataCall.size());
        } else if (size >= suggestBatchSize) {
            if (this.callopStartTime == null) {
                this.callopStartTime = new Date();
            }
            dataCall = new ArrayList(suggestBatchSize);
            dataQueue.getQueue().drainTo(dataCall, suggestBatchSize);
            log.info("submitTask_suggestBatchSize_dataCall.count=" + dataCall.size());
        }
        if (dataCall.size() > 0) {
            String entityId = ((ImportBillData)dataCall.get(0)).getMainEntityId();
            this.submitToCallOpTask(entityId, dataCall);
        }
    }

    private void submitToCallOpTask(String entityId, List<ImportBillData> dataCall) {
        log.info("submitToCallOpTask_dataCall.count=" + dataCall.size());
        if (dataCall.size() > 0) {
            Callable<Object> task = null;
            String importtype = this.importStart.getImportContext().getOpType();
            if ("delete".equals(importtype)) {
                log.info("submitToCallOpTask_CallDeleteOperationTask_dataCall.count=" + dataCall.size());
                task = new CallDeleteOperationTask(dataCall, this.importStart, entityId, this, this.childThreadMonitor, this.dataCanStopFlag);
            } else {
                log.info("submitToCallOpTask_CallSingleOperationTask_dataCall.count=" + dataCall.size());
                HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)IND_SAVE_OP_DISPATCHER_SERVICE, IIndSaveOpDispatcherService.class, (String)"kd.opmc.epa.business.domain.indicator.imp.worker.extpoint.IIndSaveOpDispatcherService#getSingleOperationTask", (PluginFilter)null);
                List tasks = proxy.callReplaceIfPresent(dispatcherService -> dispatcherService.getSingleOperationTask(dataCall, this, entityId, this.dataCanStopFlag));
                if (tasks != null && tasks.size() > 0) {
                    task = (Callable)tasks.get(0);
                }
            }
            if (task != null) {
                super.submitWithTimeOut(task);
            }
        }
    }

    protected void groupImportBillData(List<ImportBillData> importBillDataList) {
        for (ImportBillData data : importBillDataList) {
            boolean result;
            ImportQueue<ImportBillData> tempdataQueue = this.groupImportBillData.get(data.getSheetName());
            if (tempdataQueue == null) {
                tempdataQueue = new ImportQueue(this.name + "_groupQueue-".concat(data.getSheetName()), new LinkedBlockingQueue(3000), this.importStart);
                this.groupImportBillData.put(data.getSheetName(), tempdataQueue);
            }
            if (result = tempdataQueue.putOnce(data)) continue;
            this.submitTask(tempdataQueue, this.suggester.getSuggestBatchSize());
            tempdataQueue.putOnce(data);
        }
    }

    private void setOperateOption() {
        ImportContext importContext = this.importStart.getImportContext();
        if (importContext.getOpParam() == null) {
            String importtype;
            OperateOption option = OperateOption.create();
            switch (importtype = importContext.getOpType()) {
                case "update": {
                    importtype = "override";
                    break;
                }
                case "updateandnew": {
                    importtype = "overridenew";
                }
            }
            option.setVariableValue("importtype", "new");
            option.setVariableValue("autogeneratebillno", String.valueOf(true));
            option.setVariableValue("currbizappid", this.importStart.getImportContext().getAppId());
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("importtag_of_datasource", String.valueOf(true));
            option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            option.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(true));
            importContext.setOpParam(option);
        }
    }

    private void waiteInitEntityBlankDynamicObject() throws InterruptedException {
        if (!this.entityBlankDynamicObjectSemaphore.tryAcquire(20L, TimeUnit.MINUTES)) {
            throw new KDException(new ErrorCode("902", "waiteInitEntityBlankDynamicObject_timeout."), new Object[0]);
        }
        Map<String, IFormView> formIdEntityFormViewMap = this.importStart.getImportContext().getFormIdEntityFormViewMap();
        for (Map.Entry<String, IFormView> next : formIdEntityFormViewMap.entrySet()) {
            IDataModel model = next.getValue().getModel();
            model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
            model.beginInit();
            model.createNewData();
            model.endInit();
            model.getDataEntityType().getAllEntities().values().forEach(enti -> {
                if (enti instanceof EntryType) {
                    model.deleteEntryData(enti.getName());
                }
            });
            this.entityBlankDynamicObject.put(next.getKey(), model.getDataEntity());
        }
        Map<String, Map<String, Object>> areaConfigMap = this.importStart.getImportContext().getAreaConfigMap();
        for (Map.Entry<String, Map<String, Object>> mapEntry : areaConfigMap.entrySet()) {
            Map<String, Object> objectMap = mapEntry.getValue();
            String entityName = (String)objectMap.get("entityName");
            this.entityBlankDynamicObject.put(entityName, new HRBaseServiceHelper(entityName).generateEmptyDynamicObject());
        }
        this.entityBlankDynamicObjectSemaphore.release();
    }

    private void initComboItems() {
        for (Map.Entry<String, DynamicObject> next : this.entityBlankDynamicObject.entrySet()) {
            DynamicObjectType dynamicObjectType = next.getValue().getDynamicObjectType();
            dynamicObjectType.getProperties().forEach(prop -> {
                if (prop instanceof ComboProp) {
                    HashMap<String, String> itmes = new HashMap<String, String>(16);
                    this.comboItems.put(next.getKey(), (Object)prop.getName(), itmes);
                    ComboProp temp = (ComboProp)prop;
                    for (ValueMapItem item : temp.getComboItems()) {
                        itmes.put(item.getName().getLocaleValue(), item.getValue());
                    }
                } else if (prop instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)prop;
                    entryProp.getDynamicCollectionItemPropertyType().getProperties().forEach(prop2 -> {
                        if (prop2 instanceof ComboProp) {
                            HashMap<String, String> itmes = new HashMap<String, String>(16);
                            this.comboItems.put(next.getKey(), (Object)prop2.getName(), itmes);
                            ComboProp temp = (ComboProp)prop2;
                            for (ValueMapItem item : temp.getComboItems()) {
                                itmes.put(item.getName().getLocaleValue(), item.getValue());
                            }
                        }
                    });
                }
            });
        }
    }

    private void initEntitySheetMap() {
        for (Map.Entry<String, String> next : this.importStart.getImportContext().getSheetEntityMap().entrySet()) {
            this.entitySheetMap.put(next.getValue(), next.getKey());
        }
    }
}

